/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.HintType;
import com.elluminate.framework.feature.hints.HintTypeBoolean;
import com.elluminate.framework.feature.hints.HintTypeFloat;
import com.elluminate.framework.feature.hints.HintTypeImage;
import com.elluminate.framework.feature.hints.HintTypeInteger;
import com.elluminate.framework.feature.hints.HintTypeResource;
import com.elluminate.framework.feature.hints.HintTypeString;
import com.elluminate.framework.feature.hints.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class TypedElement
extends XmlElement {
    public static final String TYPE_ATTR = "type";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_RESOURCE = "resource";
    protected HintType type = null;

    protected TypedElement(String name) {
        super(name, false);
    }

    public HintType getType() {
        return this.type;
    }

    public void setType(HintType type) {
        this.type = type;
    }

    protected void parseType(Attributes attrs) throws SAXException {
        String tName = attrs.getValue("", TYPE_ATTR);
        if (tName != null) {
            if (TYPE_STRING.equals(tName)) {
                this.type = new HintTypeString();
            } else if (TYPE_BOOLEAN.equals(tName)) {
                this.type = new HintTypeBoolean();
            } else if (TYPE_INTEGER.equals(tName)) {
                this.type = new HintTypeInteger();
            } else if (TYPE_FLOAT.equals(tName)) {
                this.type = new HintTypeFloat();
            } else if (TYPE_IMAGE.equals(tName)) {
                this.type = new HintTypeImage();
            } else if (TYPE_RESOURCE.equals(tName)) {
                this.type = new HintTypeResource();
            } else {
                throw new SAXException("Invalid type attribute '" + tName + "'");
            }
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nm = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            if (TYPE_ATTR.equals(nm) || this.type != null && this.type.processTypeArg(nm, val)) continue;
            this.nonTypeAttr(nm, val);
        }
    }

    protected void nonTypeAttr(String nm, String val) throws SAXException {
        throw new SAXException("Unknown attribute '" + nm + "' on " + this.getName() + " element");
    }
}

