/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.HintLocalizer;
import com.elluminate.framework.feature.hints.HintType;
import com.elluminate.framework.feature.hints.LocalizationContext;
import org.xml.sax.SAXException;

public class HintTypeFloat
extends HintType {
    public static final String MIN_ARG = "min";
    public static final String MAX_ARG = "max";
    public float minValue = Float.NEGATIVE_INFINITY;
    public float maxValue = Float.POSITIVE_INFINITY;

    public HintTypeFloat setMinValue(float min) {
        this.minValue = min;
        return this;
    }

    public HintTypeFloat setMaxValue(float max) {
        this.maxValue = max;
        return this;
    }

    @Override
    public Object validate(String value, LocalizationContext ctxt, HintLocalizer localizer) {
        float v;
        if (ctxt != LocalizationContext.NONE) {
            return null;
        }
        try {
            v = Float.parseFloat(value);
        }
        catch (Throwable t) {
            return null;
        }
        if (v < this.minValue) {
            return false;
        }
        if (v > this.maxValue) {
            return false;
        }
        return Float.valueOf(v);
    }

    public String toString() {
        if (this.minValue == Float.MIN_VALUE && this.maxValue == Float.MAX_VALUE) {
            return "float";
        }
        StringBuilder msg = new StringBuilder("float");
        msg.append("(");
        msg.append(this.minValue);
        msg.append("..");
        msg.append(this.maxValue);
        msg.append(")");
        return msg.toString();
    }

    @Override
    public boolean processTypeArg(String name, String value) throws SAXException {
        if (MIN_ARG.equals(name)) {
            try {
                this.minValue = Float.parseFloat(value);
            }
            catch (Throwable t) {
                throw new SAXException("Invalid value for min attribute '" + value + "'");
            }
            if (this.minValue >= this.maxValue) {
                throw new SAXException("Invalid value for min attribute - min must be less than max");
            }
            return true;
        }
        if (MAX_ARG.equals(name)) {
            try {
                this.maxValue = Float.parseFloat(value);
            }
            catch (Throwable t) {
                throw new SAXException("Invalid value for max attribute '" + value + "'");
            }
            if (this.minValue >= this.maxValue) {
                throw new SAXException("Invalid value for max attribute - min must be less than max");
            }
            return true;
        }
        return false;
    }
}

