/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.HintImage;
import com.elluminate.framework.feature.hints.LocalizationContext;
import com.elluminate.util.I18n;
import com.elluminate.util.Resource;
import java.io.InputStream;
import java.net.URL;

public class HintLocalizer {
    private I18n configI18n;
    private I18n featureI18n;

    public HintLocalizer(I18n cfg, I18n ftr) {
        this.configI18n = cfg;
        this.featureI18n = ftr;
    }

    public String getString(LocalizationContext context, String rsrc) {
        switch (context) {
            case NONE: {
                return rsrc;
            }
            case CONFIG: {
                return this.getString(this.configI18n, rsrc);
            }
            case FEATURE: {
                return this.getString(this.featureI18n, rsrc);
            }
        }
        return null;
    }

    private String getString(I18n from, String rsrc) {
        try {
            return from.getStringLegacy(rsrc);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public HintImage getImage(LocalizationContext context, String rsrc) {
        switch (context) {
            case NONE: {
                return null;
            }
            case CONFIG: {
                return this.getImage(this.configI18n, rsrc);
            }
            case FEATURE: {
                return this.getImage(this.featureI18n, rsrc);
            }
        }
        return null;
    }

    private HintImage getImage(I18n from, String rsrc) {
        try {
            URL url = from.getURLforPath(rsrc);
            InputStream istr = url.openStream();
            istr.close();
            return new HintImage(from, rsrc);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Resource getResource(LocalizationContext context, String rsrc) {
        switch (context) {
            case NONE: {
                return null;
            }
            case CONFIG: {
                return this.getResource(this.configI18n, rsrc);
            }
            case FEATURE: {
                return this.getResource(this.featureI18n, rsrc);
            }
        }
        return null;
    }

    private Resource getResource(I18n from, String rsrc) {
        return from.getResource(rsrc);
    }
}

