/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.Hint;
import com.elluminate.framework.feature.hints.HintElement;
import com.elluminate.framework.feature.hints.Hints;
import com.elluminate.framework.feature.hints.HintsElement;
import com.elluminate.framework.feature.hints.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeatureElement
extends XmlElement {
    public static final String ELEMENT_NAME = "Feature";
    public static final String PATH_ATTR = "path";
    private HintsElement parent;
    private String path = null;
    private Hints hints = null;

    public FeatureElement() {
        super(ELEMENT_NAME, false);
    }

    @Override
    protected void enter(XmlElement outer, Attributes attrs) throws SAXException {
        this.parent = (HintsElement)outer;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nm = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            if (!PATH_ATTR.equals(nm)) {
                throw new SAXException("Unknown attribute '" + nm + "' in " + ELEMENT_NAME);
            }
            this.path = val;
        }
        if (this.path == null) {
            throw new SAXException("Missing path attribute on Feature element.");
        }
        if (this.parent.getHints(this.path) != null) {
            throw new SAXException("Multiple Feature specifications for feature '" + this.path + "'");
        }
    }

    @Override
    protected void leave() throws SAXException {
        if (this.hints == null) {
            throw new SAXException("No hints defined for path '" + this.path + "'");
        }
        this.parent.addHints(this.path, this.hints);
    }

    @Override
    public void reset() {
        this.parent = null;
        this.path = null;
        this.hints = null;
    }

    @Override
    public void validateChild(XmlElement child) throws SAXException {
        if (child instanceof HintElement) {
            return;
        }
        throw new SAXException("Invalid element '" + child.getName() + "' in the context of a <" + this.getName() + ">");
    }

    public String getPath() {
        return this.path;
    }

    public Hint getHint(String name) {
        if (this.hints == null) {
            return null;
        }
        return this.hints.get(name);
    }

    public void addHint(Hint hint) {
        if (this.hints == null) {
            this.hints = new Hints();
        }
        this.hints.add(hint);
    }
}

