/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.HintEnumRegistry;
import com.elluminate.framework.feature.hints.HintEnumSet;
import com.elluminate.framework.feature.hints.HintTypeEnum;
import com.elluminate.framework.feature.hints.TypedElement;
import com.elluminate.framework.feature.hints.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnumElement
extends XmlElement {
    public static final String ELEMENT_NAME = "Enum";
    public static final String NAME_ATTR = "name";
    private HintEnumRegistry registry;
    private TypedElement parent;
    private HintEnumSet which;

    public EnumElement(HintEnumRegistry reg) {
        super(ELEMENT_NAME, false);
        this.registry = reg;
    }

    @Override
    protected void enter(XmlElement outer, Attributes attrs) throws SAXException {
        this.parent = (TypedElement)outer;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nm = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            if (nm.equals(NAME_ATTR)) {
                this.which = this.registry.getEnum(val);
                if (this.which != null) continue;
                throw new SAXException("Unknown enumeration specified: '" + val + "'");
            }
            throw new SAXException("Unknown attribute '" + nm + "' on " + ELEMENT_NAME + " element");
        }
        if (this.which == null) {
            throw new SAXException("Missing name attribute on Enum element.");
        }
    }

    @Override
    protected void leave() throws SAXException {
        this.parent.setType(new HintTypeEnum(this.which));
    }

    @Override
    public void reset() {
        this.parent = null;
        this.which = null;
    }
}

