/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.Hintable;
import com.elluminate.framework.feature.hints.HintingEngine;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractHintable
implements Hintable {
    private Object owner;
    private boolean isLoaded;
    private HintingEngine engine;
    private Map<String, Object> hints = new HashMap<String, Object>();

    @Inject
    public void initHintingEngine(HintingEngine engine) {
        this.engine = engine;
    }

    public void initOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHint(String name, Object value) {
        Map<String, Object> map = this.hints;
        synchronized (map) {
            this.hints.put(name, value);
        }
    }

    @Override
    public boolean hasHint(String name) {
        return this.getHintValue(name) != null;
    }

    @Override
    public boolean hasHintValue(String name, Object value) {
        Object hv = this.getHintValue(name);
        if (hv == value) {
            return true;
        }
        if (hv == null || value == null) {
            return false;
        }
        return hv.equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getHintValue(String name) {
        Map<String, Object> map = this.hints;
        synchronized (map) {
            if (!this.isLoaded) {
                this.engine.hint(this);
                this.isLoaded = true;
            }
            return this.hints.get(name);
        }
    }

    @Override
    public <T> T getHintValue(String name, Class<T> type) {
        return (T)this.getHintValue(name);
    }

    @Override
    public <T> T getHintValue(String name, T dftValue) {
        Object value = this.getHintValue(name);
        if (value == null) {
            value = dftValue;
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHintList() {
        Map<String, Object> map = this.hints;
        synchronized (map) {
            if (!this.isLoaded) {
                this.engine.hint(this);
                this.isLoaded = true;
            }
            return this.hints.keySet().toArray(new String[this.hints.size()]);
        }
    }
}

