/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.FeaturePathSupport;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.feature.hints.AbstractHintable;
import com.google.inject.Inject;

public class NotificationImpl
extends AbstractHintable
implements Notification {
    private String path;
    private String message;
    private long timestamp;
    protected FeaturePathSupport pathSupport;

    protected NotificationImpl() {
    }

    @Inject
    public void initPathSupport(FeaturePathSupport pathSupport) {
        if (this.pathSupport != null) {
            throw new IllegalStateException("PathSupport already set");
        }
        this.pathSupport = pathSupport;
    }

    void initPath(String path) {
    }

    protected void init(Object owner, String path, String message, long timestamp) {
        super.initOwner(owner);
        if (this.getPath() != null) {
            throw new IllegalStateException("Notification path already set");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null feature path");
        }
        this.pathSupport.validatePath(path);
        if (!this.pathSupport.isAbsolutePath(path)) {
            throw new IllegalArgumentException("Relative path not allowed: " + path);
        }
        this.path = path;
        this.message = message;
        this.timestamp = timestamp;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

