/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.feature.ValueFeature;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Image;
import java.util.Collection;
import java.util.Iterator;

@Singleton
public class FeatureFactory {
    private Provider<ActionFeature> actionFeatureProvider;
    private Provider<LoadFeature> loadFeatureProvider;
    private Provider<BooleanFeature> booleanFeatureProvider;
    private Provider<ComponentFeature> componentFeatureProvider;
    private Provider<EnumeratedFeature> enumeratedFeatureProvider;
    private Provider<NumericFeature> numericFeatureProvider;
    private Provider<StringFeature> stringFeatureProvider;
    private Provider<ListFeature> listFeatureProvider;
    private Provider<ValueFeature> valueFeatureProvider;

    @Inject
    public void initActionFeatureProvider(Provider<ActionFeature> actionFeatureProvider) {
        if (this.actionFeatureProvider != null) {
            throw new IllegalStateException("actionFeatureProvider already initialized");
        }
        this.actionFeatureProvider = actionFeatureProvider;
    }

    @Inject
    public void initLoadFeatureProvider(Provider<LoadFeature> loadFeatureProvider) {
        if (this.loadFeatureProvider != null) {
            throw new IllegalStateException("loadFeatureProvider already initialized");
        }
        this.loadFeatureProvider = loadFeatureProvider;
    }

    @Inject
    public void initBooleanFeatureProvider(Provider<BooleanFeature> booleanFeatureProvider) {
        if (this.booleanFeatureProvider != null) {
            throw new IllegalStateException("booleanFeatureProvider already initialized");
        }
        this.booleanFeatureProvider = booleanFeatureProvider;
    }

    @Inject
    public void initComponentFeatureProvider(Provider<ComponentFeature> componentFeatureProvider) {
        if (this.componentFeatureProvider != null) {
            throw new IllegalStateException("componentFeatureProvider already initialized");
        }
        this.componentFeatureProvider = componentFeatureProvider;
    }

    @Inject
    public void initEnumeratedFeatureProvider(Provider<EnumeratedFeature> enumeratedFeatureProvider) {
        if (this.enumeratedFeatureProvider != null) {
            throw new IllegalStateException("enumeratedFeatureProvider already initialized");
        }
        this.enumeratedFeatureProvider = enumeratedFeatureProvider;
    }

    @Inject
    public void initNumericFeatureProvider(Provider<NumericFeature> numericFeatureProvider) {
        if (this.numericFeatureProvider != null) {
            throw new IllegalStateException("numericFeatureProvider already initialized");
        }
        this.numericFeatureProvider = numericFeatureProvider;
    }

    @Inject
    public void initStringFeatureProvider(Provider<StringFeature> stringFeatureProvider) {
        if (this.stringFeatureProvider != null) {
            throw new IllegalStateException("stringFeatureProvider already initialized");
        }
        this.stringFeatureProvider = stringFeatureProvider;
    }

    @Inject
    public void initListFeatureProvider(Provider<ListFeature> listFeatureProvider) {
        if (this.listFeatureProvider != null) {
            throw new IllegalStateException("listFeatureProvider already initialized");
        }
        this.listFeatureProvider = listFeatureProvider;
    }

    @Inject
    public void initValueFeatureProvider(Provider<ValueFeature> valueFeatureProvider) {
        if (this.valueFeatureProvider != null) {
            throw new IllegalStateException("valueFeatureProvider already initialized");
        }
        this.valueFeatureProvider = valueFeatureProvider;
    }

    public ActionFeature createActionFeature(Object owner, String path, Collection<ActionParameterDescriptor> paramDesc, String name, String desc) {
        ActionFeature feature = (ActionFeature)this.actionFeatureProvider.get();
        this.configFeature(feature, owner, path, name, desc);
        feature.initParameterDescriptors(paramDesc);
        return feature;
    }

    public ActionFeature createActionFeature(Object owner, String path, ActionParameterDescriptor[] paramDesc, String name, String desc) {
        ActionFeature feature = (ActionFeature)this.actionFeatureProvider.get();
        this.configFeature(feature, owner, path, name, desc);
        feature.initParameterDescriptors(paramDesc);
        return feature;
    }

    public LoadFeature createLoadFeature(Object owner, String path, String name, String desc) {
        LoadFeature feature = (LoadFeature)this.loadFeatureProvider.get();
        this.configFeature(feature, owner, path, name, desc);
        ActionParameterDescriptor paramDesc = new ActionParameterDescriptor("files", ActionParameterDescriptor.Type.FILE, 1, Integer.MAX_VALUE);
        feature.initParameterDescriptors(new ActionParameterDescriptor[]{paramDesc});
        return feature;
    }

    public BooleanFeature createBooleanFeature(Object owner, String path, boolean mutable, boolean initialValue, String name, String desc) {
        BooleanFeature feature = (BooleanFeature)this.booleanFeatureProvider.get();
        this.configValueFeature(feature, owner, path, mutable, initialValue, name, desc);
        return feature;
    }

    public ComponentFeature createComponentFeature(Object owner, String path, ComponentProvider factory, String name, String desc) {
        ComponentFeature feature = (ComponentFeature)this.componentFeatureProvider.get();
        this.configFeature(feature, owner, path, name, desc);
        feature.initFactory(factory);
        return feature;
    }

    public ComponentFeature createComponentFeature(Object owner, String path, Component component, String name, String desc) {
        ComponentFeature feature = (ComponentFeature)this.componentFeatureProvider.get();
        this.configFeature(feature, owner, path, name, desc);
        feature.initComponent(component);
        return feature;
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initialValue, T[] allowedValues, String name, String desc) {
        return this.createEnumeratedFeature(owner, path, type, mutable, initialValue, allowedValues, null, null, null, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initialValue, T[] allowedValues, String[] valueText, String name, String desc) {
        return this.createEnumeratedFeature(owner, path, type, mutable, initialValue, allowedValues, valueText, null, null, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initialValue, T[] allowedValues, String[] valueText, String[] valueDesc, Image[] valueIconImage, String name, String desc) {
        int ix;
        EnumeratedFeature feature = (EnumeratedFeature)this.enumeratedFeatureProvider.get();
        feature.initType(type);
        feature.initEnumeration(allowedValues);
        this.configValueFeature(feature, owner, path, mutable, initialValue, name, desc);
        if (valueText != null) {
            if (valueText.length != allowedValues.length) {
                throw new IllegalArgumentException("Display text list length differs from allowed values list length");
            }
            for (ix = 0; ix < allowedValues.length; ++ix) {
                feature.setValueText(allowedValues[ix], valueText[ix]);
            }
        }
        if (valueDesc != null) {
            if (valueDesc.length != allowedValues.length) {
                throw new IllegalArgumentException("Description list length differs from allowed values list length");
            }
            for (ix = 0; ix < allowedValues.length; ++ix) {
                feature.setValueDescription(allowedValues[ix], valueDesc[ix]);
            }
        }
        if (valueIconImage != null) {
            if (valueIconImage.length != allowedValues.length) {
                throw new IllegalArgumentException("Icon image list length differs from allowed values list length");
            }
            for (ix = 0; ix < allowedValues.length; ++ix) {
                feature.setValueIconImage(allowedValues[ix], valueIconImage[ix]);
            }
        }
        if (initialValue != null) {
            feature.setValue(initialValue);
        }
        return feature;
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initialValue, Collection<T> allowedValues, String name, String desc) {
        return this.createEnumeratedFeature(owner, path, type, mutable, initialValue, allowedValues, null, null, null, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initialValue, Collection<T> allowedValues, Collection<String> valueText, String name, String desc) {
        return this.createEnumeratedFeature(owner, path, type, mutable, initialValue, allowedValues, valueText, null, null, name, desc);
    }

    public <T> EnumeratedFeature<T> createEnumeratedFeature(Object owner, String path, Class<T> type, boolean mutable, T initialValue, Collection<T> allowedValues, Collection<String> valueText, Collection<String> valueDesc, Collection<Image> valueIconImage, String name, String desc) {
        Iterator<T> valItr;
        EnumeratedFeature feature = (EnumeratedFeature)this.enumeratedFeatureProvider.get();
        feature.initType(type);
        feature.initEnumeration(allowedValues);
        this.configValueFeature(feature, owner, path, mutable, initialValue, name, desc);
        if (valueText != null) {
            if (valueText.size() != allowedValues.size()) {
                throw new IllegalArgumentException("Display text list length differs from allowed values list length");
            }
            valItr = allowedValues.iterator();
            Iterator<String> textItr = valueText.iterator();
            while (valItr.hasNext() && textItr.hasNext()) {
                feature.setValueText(valItr.next(), textItr.next());
            }
        }
        if (valueDesc != null) {
            if (valueDesc.size() != allowedValues.size()) {
                throw new IllegalArgumentException("Description list length differs from allowed values list length");
            }
            valItr = allowedValues.iterator();
            Iterator<String> descItr = valueDesc.iterator();
            while (valItr.hasNext() && descItr.hasNext()) {
                feature.setValueDescription(valItr.next(), descItr.next());
            }
        }
        if (valueIconImage != null) {
            if (valueIconImage.size() != allowedValues.size()) {
                throw new IllegalArgumentException("Icon image list length differs from allowed values list length");
            }
            valItr = allowedValues.iterator();
            Iterator<Image> imgItr = valueIconImage.iterator();
            while (valItr.hasNext() && imgItr.hasNext()) {
                feature.setValueIconImage(valItr.next(), imgItr.next());
            }
        }
        if (initialValue != null) {
            feature.setValue(initialValue);
        }
        return feature;
    }

    public NumericFeature<Integer> createNumericFeature(Object owner, String path, boolean mutable, int initialValue, String name, String desc) {
        NumericFeature feature = (NumericFeature)this.numericFeatureProvider.get();
        feature.initType(Integer.class);
        this.configValueFeature(feature, owner, path, mutable, initialValue, name, desc);
        return feature;
    }

    public NumericFeature<Integer> createNumericFeature(Object owner, String path, boolean mutable, int initialValue, int minValue, int maxValue, String name, String desc) {
        NumericFeature feature = (NumericFeature)this.numericFeatureProvider.get();
        feature.initOwner(owner);
        feature.initPath(path);
        feature.initType(Integer.class);
        feature.initMutable(mutable);
        feature.setName(name);
        feature.setDescription(desc);
        feature.setValue(initialValue);
        feature.setMinimumValue(minValue);
        feature.setMaximumValue(maxValue);
        return feature;
    }

    public NumericFeature<Double> createNumericFeature(Object owner, String path, boolean mutable, double initialValue, String name, String desc) {
        NumericFeature feature = (NumericFeature)this.numericFeatureProvider.get();
        feature.initOwner(owner);
        feature.initPath(path);
        feature.initType(Double.class);
        feature.initMutable(mutable);
        feature.setName(name);
        feature.setDescription(desc);
        feature.setValue(initialValue);
        return feature;
    }

    public StringFeature createStringFeature(Object owner, String path, boolean mutable, String initialValue, String name, String desc) {
        StringFeature feature = (StringFeature)this.stringFeatureProvider.get();
        this.configValueFeature(feature, owner, path, mutable, initialValue, name, desc);
        return feature;
    }

    public StringFeature createStringFeature(Object owner, String path, boolean mutable, String initialValue, StringFeature.Validator validator, String name, String desc) {
        StringFeature feature = (StringFeature)this.stringFeatureProvider.get();
        feature.initType(String.class);
        this.configValueFeature(feature, owner, path, mutable, initialValue, name, desc);
        feature.setValidator(validator, initialValue);
        return feature;
    }

    public <T> ValueFeature<T> createValueFeature(Object owner, String path, boolean mutable, T initalValue, String name, String desc) {
        return this.createValueFeature(owner, path, mutable, initalValue.getClass(), initalValue, name, desc);
    }

    public <T> ValueFeature<T> createValueFeature(Object owner, String path, boolean mutable, Class<T> type, T initalValue, String name, String desc) {
        ValueFeature vf = (ValueFeature)this.valueFeatureProvider.get();
        vf.initType(type);
        this.configValueFeature(vf, owner, path, mutable, initalValue, name, desc);
        return vf;
    }

    private <T> void configValueFeature(ValueFeature<T> vf, Object owner, String path, boolean mutable, T initialValue, String name, String desc) {
        this.configFeature(vf, owner, path, name, desc);
        vf.initMutable(mutable);
        vf.setValue(initialValue);
    }

    private void configFeature(AbstractFeature f, Object owner, String path, String name, String desc) {
        f.initOwner(owner);
        f.initPath(path);
        f.setName(name);
        f.setDescription(desc);
    }

    public <T> ListFeature<T> createListFeature(Object owner, String path, Class<T> type, Collection<T> initalVals, String name, String desc) {
        ListFeature feature = (ListFeature)this.listFeatureProvider.get();
        this.configFeature(feature, owner, path, name, desc);
        if (initalVals != null) {
            Iterator<T> itr = initalVals.iterator();
            while (itr.hasNext()) {
                feature.add(itr.next());
            }
        }
        return feature;
    }
}

