/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureDirectoryFactory;
import com.elluminate.framework.feature.FeaturePublicationEvent;
import com.elluminate.framework.feature.FeaturePublicationListener;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class FeatureDirectory
extends AbstractFeature {
    private final Map<String, Feature> map = new TreeMap<String, Feature>();
    private final ListenerRegistry<FeaturePublicationListener> pubListeners = new ListenerRegistry(this.throwableProxy);
    private FeatureDirectoryFactory factory;
    private FeatureDirectory parent;

    @Inject
    public void initFactory(FeatureDirectoryFactory factory) {
        if (this.factory != null) {
            throw new IllegalStateException("Factory already set");
        }
        this.factory = factory;
    }

    void initParent(FeatureDirectory parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Parent already set");
        }
        if (parent == this) {
            throw new IllegalArgumentException("Self-referential parent");
        }
        this.parent = parent;
    }

    private String getPathAsPrefix() {
        String prefix = this.getPath();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    public boolean isContainedPath(String featurePath) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Not an absolute path");
        }
        return featurePath.startsWith(this.getPathAsPrefix());
    }

    public boolean isLocalPath(String featurePath) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Not an absolute path");
        }
        try {
            LocalPath localPath = new LocalPath(featurePath);
            return localPath.subpath == null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String getSelfRelativePath(String featurePath) {
        if (!this.pathSupport.isAbsolutePath(featurePath)) {
            throw new IllegalArgumentException("Not an absolute path");
        }
        String prefix = this.getPathAsPrefix();
        if (!featurePath.startsWith(prefix)) {
            throw new IllegalArgumentException("Feature rooted in another subtree: " + featurePath);
        }
        return featurePath.substring(prefix.length());
    }

    public FeatureDirectory getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        FeatureDirectory featureDirectory = this;
        synchronized (featureDirectory) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        FeatureDirectory featureDirectory = this;
        synchronized (featureDirectory) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPaths() {
        ArrayList<String> result;
        FeatureDirectory featureDirectory = this;
        synchronized (featureDirectory) {
            result = new ArrayList<String>(this.map.size());
            for (String key : this.map.keySet()) {
                result.add(this.pathSupport.composePath(this.getPath(), key));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public Iterator<String> pathIterator() {
        return new PathIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Feature> featureIterator() {
        FeatureDirectory featureDirectory = this;
        synchronized (featureDirectory) {
            return this.map.values().iterator();
        }
    }

    public boolean hasFeature(String featurePath) {
        return this.getFeature(featurePath) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature getFeature(String featurePath) {
        Feature feature;
        LocalPath localPath = new LocalPath(featurePath);
        FeatureDirectory featureDirectory = this;
        synchronized (featureDirectory) {
            feature = this.map.get(localPath.name);
        }
        if (localPath.subpath == null) {
            return feature;
        }
        if (feature == null) {
            return null;
        }
        if (!(feature instanceof FeatureDirectory)) {
            throw new IllegalArgumentException("Invalid path '" + featurePath + "' at token " + localPath.name);
        }
        FeatureDirectory dir = (FeatureDirectory)feature;
        return dir.getFeature(localPath.subpath);
    }

    public <T extends Feature> T getFeatureAs(Class<T> type, String featurePath) {
        Feature feature = this.getFeature(featurePath);
        if (feature == null) {
            return null;
        }
        if (type.isAssignableFrom(feature.getClass())) {
            Feature result = feature;
            return (T)result;
        }
        throw new IllegalArgumentException("Feature at " + featurePath + " cannot be coerced to " + type);
    }

    public FeatureDirectory getFeatureDirectory(String featurePath) {
        return this.getFeatureAs(FeatureDirectory.class, featurePath);
    }

    public boolean setFeaturePublished(Feature feature, boolean publish) {
        boolean wasPublished = feature.isPublished();
        if (publish != wasPublished) {
            if (publish) {
                this.addFeature(feature);
            } else {
                this.removeFeature(feature);
            }
        }
        return wasPublished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(Feature feature) {
        if (feature instanceof FeatureDirectory) {
            throw new IllegalArgumentException("Cannot manually add FeatureDirectory: " + feature);
        }
        LocalPath localPath = new LocalPath(feature.getPath());
        if (localPath.subpath == null) {
            boolean wasPublished = false;
            FeatureDirectory featureDirectory = this;
            synchronized (featureDirectory) {
                Feature orig = this.map.get(localPath.name);
                if (orig != null && orig != feature) {
                    throw new IllegalStateException("A different feature is published as " + feature.getPath() + ": " + orig);
                }
                wasPublished = orig != null;
                this.map.put(localPath.name, feature);
            }
            if (!wasPublished) {
                if (feature instanceof AbstractFeature) {
                    ((AbstractFeature)feature).setPublished(true);
                }
                this.fireFeatureAdded(feature);
            }
            return;
        }
        FeatureDirectory dir = this.makeDirectory(localPath.name);
        dir.addFeature(feature);
    }

    public FeatureDirectory addFeatureDirectory(String featurePath) {
        LocalPath localPath = new LocalPath(featurePath);
        FeatureDirectory dir = this.makeDirectory(localPath.name);
        if (localPath.subpath != null) {
            return dir.addFeatureDirectory(localPath.subpath);
        }
        return dir;
    }

    public boolean removeFeature(Feature feature) {
        if (feature != null && this.removeFeature(feature.getPath(), feature)) {
            return true;
        }
        if (feature instanceof AbstractFeature) {
            ((AbstractFeature)feature).setPublished(false);
        }
        return false;
    }

    public void announceFeature(Feature feature) {
        this.fireFeatureAnnounced(feature);
    }

    public boolean removeFeature(String featurePath) {
        return this.removeFeature(featurePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFeature(String featurePath, Feature orig) {
        LocalPath localPath = new LocalPath(featurePath);
        if (localPath.subpath == null) {
            Feature feature = null;
            FeatureDirectory featureDirectory = this;
            synchronized (featureDirectory) {
                feature = this.map.get(localPath.name);
                if (feature != null) {
                    if (feature instanceof FeatureDirectory) {
                        throw new IllegalArgumentException("Cannot remove FeatureDirectory: " + feature);
                    }
                    if (orig != null && orig != feature) {
                        throw new IllegalArgumentException("Feature published at " + featurePath + " is not Feature being removed: " + orig);
                    }
                    this.map.remove(localPath.name);
                }
            }
            if (feature != null) {
                if (feature instanceof AbstractFeature) {
                    ((AbstractFeature)feature).setPublished(false);
                }
                this.fireFeatureRemoved(feature);
                return true;
            }
            return false;
        }
        Feature node = null;
        FeatureDirectory featureDirectory = this;
        synchronized (featureDirectory) {
            node = this.map.get(localPath.name);
        }
        if (node == null) {
            return false;
        }
        if (!(node instanceof FeatureDirectory)) {
            throw new IllegalArgumentException("Invalid path '" + featurePath + "' at token " + localPath.name);
        }
        FeatureDirectory dir = (FeatureDirectory)node;
        return dir.removeFeature(localPath.subpath);
    }

    public void addFeaturePublicationListener(FeaturePublicationListener l) {
        this.pubListeners.add((Object)l);
    }

    public void removeFeaturePublicationListener(FeaturePublicationListener l) {
        this.pubListeners.remove((Object)l);
    }

    protected void fireFeatureAdded(final Feature feature) {
        this.pubListeners.fire((FiringFunctor)new FiringFunctor<FeaturePublicationListener>(){
            private FeaturePublicationEvent event = null;

            public void fire(FeaturePublicationListener l) {
                if (this.event == null) {
                    this.event = new FeaturePublicationEvent(feature);
                }
                l.featureAdded(this.event);
            }
        });
        if (this.parent != null) {
            this.parent.fireFeatureAdded(feature);
        }
    }

    protected void fireFeatureRemoved(final Feature feature) {
        this.pubListeners.fire((FiringFunctor)new FiringFunctor<FeaturePublicationListener>(){
            private FeaturePublicationEvent event = null;

            public void fire(FeaturePublicationListener l) {
                if (this.event == null) {
                    this.event = new FeaturePublicationEvent(feature);
                }
                l.featureRemoved(this.event);
            }
        });
        if (this.parent != null) {
            this.parent.fireFeatureRemoved(feature);
        }
    }

    protected void fireFeatureAnnounced(final Feature feature) {
        this.pubListeners.fire((FiringFunctor)new FiringFunctor<FeaturePublicationListener>(){
            private FeaturePublicationEvent event = null;

            public void fire(FeaturePublicationListener l) {
                if (this.event == null) {
                    this.event = new FeaturePublicationEvent(feature);
                }
                l.featureAnnounced(this.event);
            }
        });
        if (this.parent != null) {
            this.parent.fireFeatureAnnounced(feature);
        }
    }

    private synchronized FeatureDirectory makeDirectory(String nodeName) {
        Feature node = this.map.get(nodeName);
        if (node != null) {
            if (!(node instanceof FeatureDirectory)) {
                String featurePath = this.pathSupport.composePath(this.getPath(), nodeName);
                throw new IllegalArgumentException("Path '" + featurePath + "' includes leaf node at " + nodeName);
            }
            return (FeatureDirectory)node;
        }
        String dirPath = this.pathSupport.composePath(this.getPath(), nodeName);
        FeatureDirectory dir = this.factory.create(dirPath);
        dir.initPath(dirPath);
        dir.initParent(this);
        dir.setPublished(true);
        this.map.put(nodeName, dir);
        return dir;
    }

    private class LocalPath {
        private String name = null;
        private String subpath = null;

        private LocalPath(String featurePath) {
            FeatureDirectory.this.pathSupport.validatePath(featurePath);
            String relPath = featurePath;
            if (FeatureDirectory.this.pathSupport.isAbsolutePath(featurePath)) {
                relPath = FeatureDirectory.this.getSelfRelativePath(featurePath);
            }
            String[] tokens = relPath.split(Pattern.quote("/"), 2);
            this.name = tokens[0];
            this.subpath = tokens.length == 1 ? null : tokens[1];
        }
    }

    private class PathIterator
    implements Iterator<String> {
        private Iterator<String> keyIterator;

        private PathIterator() {
            this.keyIterator = FeatureDirectory.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext();
        }

        @Override
        public String next() {
            return FeatureDirectory.this.pathSupport.composePath(FeatureDirectory.this.getPath(), this.keyIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

