/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.ComponentProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;

public class ComponentFeature
extends AbstractFeature {
    public static final String ICON_IMAGE = "ComponentFeature.iconImage";
    public static final String REQUESTED_SIZE = "ComponentFeature.requestedSize";
    private Component component = null;
    private ComponentProvider provider;

    public ComponentFeature() {
        this.initMetaDatumType(ICON_IMAGE, Image.class);
        this.initMetaDatumType(REQUESTED_SIZE, Dimension.class);
    }

    public void initFactory(ComponentProvider provider) {
        if (this.provider != null) {
            throw new IllegalStateException("provider already initialized");
        }
        if (this.component != null) {
            throw new IllegalStateException("component already initialized");
        }
        this.provider = provider;
    }

    public void initComponent(Component component) {
        if (this.component != null) {
            throw new IllegalStateException("component already initialized");
        }
        if (this.provider != null) {
            throw new IllegalStateException("provider already initialized");
        }
        this.component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.component == null) {
                this.component = this.provider.get(this);
                if (this.component == null) {
                    throw new RuntimeException("ComponentProvider failed to provide: " + this.getPath());
                }
            }
        }
        return this.component;
    }

    public void setIconImage(Image image) {
        this.setMetaDatum(ICON_IMAGE, image);
    }

    public Image getIconImage() {
        return this.getMetaDatumAs(Image.class, ICON_IMAGE);
    }

    public void setRequestedSize(Dimension size) {
        this.setMetaDatum(REQUESTED_SIZE, size);
    }

    public Dimension getRequestedSize() {
        return this.getMetaDatumAs(Dimension.class, REQUESTED_SIZE);
    }
}

