/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import java.io.File;
import java.util.Collection;

public class ActionParameterDescriptor {
    private String key = null;
    private Type type = Type.INVALID;
    private Class implType = null;
    private int minCount = 1;
    private int maxCount = 1;
    private String description = null;
    private Validator validator = null;

    public ActionParameterDescriptor(String key, Type type) {
        this(key, type, 1, 1, null, null);
    }

    public ActionParameterDescriptor(String key, Type type, int minCount, int maxCount) {
        this(key, type, minCount, maxCount, null, null);
    }

    public ActionParameterDescriptor(String key, Type type, String description, Validator validator) {
        this(key, type, 1, 1, description, validator);
    }

    public ActionParameterDescriptor(String key, Type type, int minCount, int maxCount, String description, Validator validator) {
        if (key == null) {
            throw new IllegalArgumentException("null parameter key");
        }
        if (minCount < 0) {
            throw new IllegalArgumentException("invalid minCount: " + minCount);
        }
        if (maxCount < 1) {
            throw new IllegalArgumentException("invalid maxCount: " + maxCount);
        }
        if (maxCount < minCount) {
            throw new IllegalArgumentException("invalid count range: " + minCount + ".." + maxCount);
        }
        this.key = key;
        this.type = type;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.description = description;
        this.validator = validator;
        switch (type) {
            case PARTICIPANT: {
                this.implType = CRParticipant.class;
                break;
            }
            case ROOM: {
                this.implType = CRRoom.class;
                break;
            }
            case FILE: {
                this.implType = File.class;
                break;
            }
            case STRING: {
                this.implType = String.class;
                break;
            }
            case BOOLEAN: {
                this.implType = Boolean.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter type: " + (Object)((Object)type));
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append("{");
        result.append("key=" + this.key);
        result.append(",type=" + (Object)((Object)this.type));
        result.append(",count=" + this.minCount + ".." + this.maxCount);
        result.append("}");
        return result.toString();
    }

    public String getKey() {
        return this.key;
    }

    public Type getType() {
        return this.type;
    }

    public Class getImplementationType() {
        return this.implType;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOptional() {
        return this.minCount < 1;
    }

    public boolean isRequired() {
        return this.minCount > 0;
    }

    public boolean isSingular() {
        return this.maxCount == 1;
    }

    public boolean isPlural() {
        return this.maxCount > 1;
    }

    public boolean isValid(Object val) {
        if (this.isValidScalar(val)) {
            return 1 >= this.minCount;
        }
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.size() < this.minCount) {
                return false;
            }
            return this.isValidNoMinCount(col);
        }
        return false;
    }

    public boolean isValidNoMinCount(Collection col) {
        if (col.size() > this.maxCount) {
            return false;
        }
        for (Object o : col) {
            if (this.isValidScalar(o)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidScalar(Object val) {
        if (val == null) {
            return false;
        }
        if (!this.implType.isAssignableFrom(val.getClass())) {
            return false;
        }
        return this.validator == null || this.validator.isValid(val);
    }

    public static enum Type {
        INVALID,
        PARTICIPANT,
        ROOM,
        FILE,
        STRING,
        BOOLEAN;

    }

    public static interface Validator {
        public boolean isValid(Object var1);
    }
}

