/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.StartQuizCommand;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.module.QuizBean;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;

public class StartQuizCmd
extends AbstractCommand
implements StartQuizCommand {
    private String quizName = null;
    private int timeLimit = 0;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<QuizBean> beanProvider;

    @Inject
    public void initQuizBeanProvider(Provider<QuizBean> bp) {
        this.beanProvider = bp;
    }

    public void setQuizName(String quizName) {
        this.quizName = quizName;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        QuizBean bean = (QuizBean)this.beanProvider.get();
        if (bean.isTesting()) {
            throw new CommandContextException("A quiz is already running", this.i18n.getString((PropertiesEnum)StringsProperties.STARTQUIZCMD_BADCONTEXTQUIZALREADYQUIZZING));
        }
        if (this.quizName == null || this.quizName.length() == 0) {
            throw new CommandParameterException("Quiz name must be set", this.i18n.getString((PropertiesEnum)StringsProperties.STARTQUIZCMD_BADPARAMQUIZNAMENOTSET));
        }
        Quiz q = null;
        ArrayList quizzes = bean.getQuizLib().getQuizzes();
        for (Quiz nextQuiz : quizzes) {
            if (!nextQuiz.getText().equalsIgnoreCase(this.quizName)) continue;
            q = nextQuiz;
            break;
        }
        if (q == null) {
            throw new CommandParameterException("No quiz named " + this.quizName + " exists", this.i18n.getString((PropertiesEnum)StringsProperties.STARTQUIZCMD_BADPARAMQUIZNOTFOUND, new Object[]{this.quizName}));
        }
        bean.start(q, new Long(this.timeLimit * 1000));
    }
}

