/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.Response;
import com.elluminate.groupware.quiz.module.AnswerLine;
import com.elluminate.groupware.quiz.module.QuestionPanel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;

class ShortAnswerLine
extends AnswerLine {
    boolean recursive = false;

    public ShortAnswerLine(QuestionPanel panel, int row, int mode) {
        super(panel, row);
        this.icon = new JLabel(QuestionPanel.blankIcon);
        this.icon.setOpaque(false);
        this.box = new JCheckBox();
        this.box.setOpaque(false);
        this.box.setVisible(false);
        this.setTextColors(LTYELLOW, LTYELLOW);
        this.addTextComponent(mode != 1 && mode != 3);
        this.addTextComponent(mode == 1 || mode == 3);
        this.createAnswerEditor();
        this.createStatsComponents();
        this.addComponents(0);
        this.setMode(mode);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.answer.removeQuizListener((QuizListener)this);
        this.disposeAnswerEditor();
        this.removeComponents();
    }

    @Override
    public void setAnswer(Answer a) {
        super.setAnswer(a);
        this.setMode(this.mode);
    }

    private String getCorrect() {
        if (this.answer == null) {
            return "";
        }
        Question question = (Question)this.answer.getParent();
        Response response = question.getCorrectResponse();
        if (response == null) {
            return "";
        }
        String resp = response.getText();
        if (resp == null) {
            return "";
        }
        return resp;
    }

    private String getResponse() {
        if (this.answer == null) {
            return "";
        }
        String resp = this.answer.getText();
        if (resp == null) {
            return "";
        }
        return resp;
    }

    @Override
    public void setMode(int newMode) {
        this.mode = newMode;
        if (this.answer == null) {
            this.hideAll();
            return;
        }
        switch (newMode) {
            case 1: {
                this.icon.setVisible(false);
                this.setTextEditable(true, true);
                this.bar.setVisible(false);
                this.counts.setVisible(false);
                this.editor.setVisible(true);
                break;
            }
            case 2: {
                this.icon.setVisible(false);
                this.setTextEditable(false, true);
                this.bar.setVisible(true);
                this.counts.setVisible(true);
                this.editor.setVisible(false);
                break;
            }
            case 3: {
                this.icon.setVisible(false);
                this.setTextEditable(true, true);
                this.bar.setVisible(false);
                this.counts.setVisible(false);
                this.editor.setVisible(false);
                break;
            }
            case 4: {
                this.icon.setVisible(false);
                this.setTextEditable(false, true);
                this.bar.setVisible(false);
                this.counts.setVisible(false);
                this.editor.setVisible(false);
                break;
            }
            case 5: {
                this.icon.setVisible(true);
                this.setTextEditable(false, true);
                this.box.setVisible(false);
                this.bar.setVisible(true);
                this.counts.setVisible(true);
                this.editor.setVisible(false);
            }
        }
        this.readData();
    }

    private boolean needsUpdate(String prev, String curr) {
        if (prev == null) {
            prev = "";
        }
        if (curr == null) {
            curr = "";
        }
        return !prev.equals(curr);
    }

    @Override
    public void readData() {
        if (this.answer == null) {
            return;
        }
        switch (this.mode) {
            case 1: 
            case 2: {
                this.updateText(this.getCorrect(), null);
                break;
            }
            case 3: 
            case 4: {
                this.updateText(this.getResponse(), null);
                break;
            }
            case 5: {
                String response = this.getResponse();
                String correct = this.getCorrect();
                this.updateText(response, correct);
                if (response.equals("")) {
                    this.icon.setIcon(QuestionPanel.blankIcon);
                    break;
                }
                if (correct.equals(response)) {
                    this.icon.setIcon(QuestionPanel.rightIcon);
                    break;
                }
                this.icon.setIcon(QuestionPanel.unknownIcon);
            }
        }
        if (this.mode == 2 || this.mode == 5) {
            this.updateStats(this.answer.getStatsCount(), this.answer.getStatsTotal());
        }
    }

    @Override
    public void writeData() {
    }

    @Override
    public void textChanged(DocumentEvent e) {
        if (this.answer == null) {
            return;
        }
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        String txt = this.getText();
        String prev = this.mode == 3 ? this.answer.getText() : this.getCorrect();
        if (txt != null && txt.equals(prev)) {
            this.recursive = false;
            return;
        }
        if (this.mode == 3) {
            if (txt == null || txt.equals("")) {
                this.answer.setText(null);
            } else {
                this.answer.setText(txt);
            }
        } else if (this.mode == 1) {
            Question q = (Question)this.answer.getParent();
            if (txt == null || txt.equals("")) {
                q.setCorrectResponse(null);
            } else {
                q.setCorrectResponse(new Response(txt));
            }
        }
        this.recursive = false;
    }

    @Override
    public void onQuizChange(QuizEvent e) {
        if (this.answer == null) {
            return;
        }
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        super.onQuizChange(e);
        if (e.getAction() == 2) {
            this.updateStats(this.answer.getStatsCount(), this.answer.getStatsTotal());
        } else {
            this.readData();
        }
        this.recursive = false;
    }
}

