/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.module.AnsweredIconSelector;
import com.elluminate.groupware.quiz.module.CorrectIconSelector;
import com.elluminate.groupware.quiz.module.QuestionListCellRenderer;
import com.elluminate.groupware.quiz.module.QuestionPanel;
import com.elluminate.groupware.quiz.module.QuizPanel_firstBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizPanel_lastBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizPanel_nextBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizPanel_prevBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.gui.component.RollOverButton;
import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class QuizPanel
extends JPanel
implements QuizListener,
ItemListener {
    private static I18n i18n = I18n.create(QuizPanel.class);
    private ImageIcon firstIcon = i18n.getIcon("QuizPanel.firstIcon");
    private ImageIcon prevIcon = i18n.getIcon("QuizPanel.prevIcon");
    private ImageIcon nextIcon = i18n.getIcon("QuizPanel.nextIcon");
    private ImageIcon lastIcon = i18n.getIcon("QuizPanel.lastIcon");
    public static final String QUESTION_PROPERTY = "question";
    BorderLayout quizLayout = new BorderLayout();
    JPanel navPanel = new JPanel();
    JComboBox selector = new JComboBox();
    JButton firstBtn = new RollOverButton();
    JButton prevBtn = new RollOverButton();
    JButton lastBtn = new RollOverButton();
    JButton nextBtn = new RollOverButton();
    GridBagLayout navLayout = new GridBagLayout();
    QuestionPanel view = new QuestionPanel();
    JScrollPane viewScroller = new JScrollPane(this.view);
    QuestionListCellRenderer renderer = new QuestionListCellRenderer(this.selector.getRenderer());
    private CPropertyChangeSupport cSupport;
    private Quiz quiz = null;
    private int mode = 0;
    private short index = 0;

    public QuizPanel() {
        this(0);
    }

    public QuizPanel(int mode) {
        this.getPropertyChangeSupport();
        this.setMode(mode);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"QuizPanel", (Throwable)e, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.quizLayout);
        this.firstBtn.setIcon(this.firstIcon);
        this.firstBtn.setMargin(new Insets(0, 0, 0, 0));
        this.firstBtn.setEnabled(false);
        this.firstBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZPANEL_FIRSTTIP));
        this.firstBtn.addActionListener(new QuizPanel_firstBtn_actionAdapter(this));
        this.firstBtn.setPreferredSize(new Dimension(20, 20));
        this.prevBtn.setIcon(this.prevIcon);
        this.prevBtn.setMargin(new Insets(0, 0, 0, 0));
        this.prevBtn.setEnabled(false);
        this.prevBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZPANEL_PREVTIP));
        this.prevBtn.addActionListener(new QuizPanel_prevBtn_actionAdapter(this));
        this.prevBtn.setPreferredSize(new Dimension(20, 20));
        this.nextBtn.setIcon(this.nextIcon);
        this.nextBtn.setMargin(new Insets(0, 0, 0, 0));
        this.nextBtn.setEnabled(false);
        this.nextBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZPANEL_NEXTTIP));
        this.nextBtn.addActionListener(new QuizPanel_nextBtn_actionAdapter(this));
        this.nextBtn.setPreferredSize(new Dimension(20, 20));
        this.lastBtn.setIcon(this.lastIcon);
        this.lastBtn.setMargin(new Insets(0, 0, 0, 0));
        this.lastBtn.setEnabled(false);
        this.lastBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZPANEL_LASTTIP));
        this.lastBtn.addActionListener(new QuizPanel_lastBtn_actionAdapter(this));
        this.lastBtn.setPreferredSize(new Dimension(20, 20));
        this.navPanel.setLayout(this.navLayout);
        this.navPanel.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.selector.addItemListener(this);
        this.selector.setRenderer(this.renderer);
        this.selector.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZPANEL_SELECTTIP));
        this.add((Component)this.navPanel, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.navPanel.add((Component)this.firstBtn, gbc);
        gbc.gridx = 1;
        this.navPanel.add((Component)this.prevBtn, gbc);
        gbc.gridx = 2;
        this.navPanel.add((Component)this.nextBtn, gbc);
        gbc.gridx = 3;
        this.navPanel.add((Component)this.lastBtn, gbc);
        gbc.gridx = 4;
        gbc.weightx = 100.0;
        gbc.insets.left = 6;
        this.navPanel.add((Component)this.selector, gbc);
        this.add((Component)this.viewScroller, "Center");
        this.viewScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        this.viewScroller.setVerticalScrollBarPolicy(22);
        this.viewScroller.setHorizontalScrollBarPolicy(30);
        this.viewScroller.getViewport().setBackground(Color.white);
    }

    public Quiz getQuiz() {
        return this.quiz;
    }

    public void setQuiz(Quiz q) {
        if (this.quiz != null) {
            this.quiz.removeQuizListener((QuizListener)this);
        }
        this.quiz = null;
        this.rebuildSelector();
        this.selector.setSelectedItem(null);
        this.quiz = q;
        if (this.quiz != null) {
            this.quiz.addQuizListener((QuizListener)this);
        }
        this.rebuildSelector();
        if (this.quiz != null && this.quiz.getQuestionCount() > 0) {
            this.selector.setSelectedIndex(0);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int m) {
        this.mode = m;
        this.view.setMode(m);
        switch (this.mode) {
            case 5: {
                this.renderer.setIconSelector(new CorrectIconSelector());
                this.selector.repaint();
                break;
            }
            case 3: {
                this.renderer.setIconSelector(new AnsweredIconSelector());
                this.selector.repaint();
                break;
            }
            default: {
                this.renderer.setIconSelector(null);
                this.selector.repaint();
            }
        }
        this.rebuildSelector();
    }

    public Question getSelectedQuestion() {
        return this.view.getQuestion();
    }

    public short getSelectedIndex() {
        return this.index;
    }

    public void setSelectedIndex(short idx) {
        if (this.quiz == null) {
            return;
        }
        if (idx >= 0 && idx < this.quiz.getQuestionCount()) {
            this.selector.setSelectedIndex(idx);
        }
    }

    private CPropertyChangeSupport getPropertyChangeSupport() {
        if (this.cSupport == null) {
            this.cSupport = new CPropertyChangeSupport((Object)this);
        }
        return this.cSupport;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.getPropertyChangeSupport().addPropertyChangeListener(prop, lst);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.getPropertyChangeSupport().removePropertyChangeListener(prop, lst);
    }

    private void rebuildSelector() {
        if (this.quiz == null || this.quiz.getQuestionCount() == 0) {
            this.selector.removeAllItems();
            this.index = (short)-1;
            this.changeQuestion(null);
            return;
        }
        short count = this.quiz.getQuestionCount();
        this.selector.removeItemListener(this);
        for (short i = 0; i < count; i = (short)(i + 1)) {
            Question item = null;
            Question q = this.quiz.getQuestion(i);
            if (i < this.selector.getItemCount()) {
                item = (Question)this.selector.getItemAt(i);
                if (item == q) continue;
                this.selector.removeItemAt(i);
                this.selector.insertItemAt(q, i);
                continue;
            }
            this.selector.insertItemAt(q, i);
        }
        while (this.selector.getItemCount() > count) {
            this.selector.removeItemAt(count);
        }
        this.selector.addItemListener(this);
        while (this.index >= count) {
            this.index = (short)(this.index - 1);
        }
        this.selector.setSelectedIndex(this.index);
        this.enableNavigators();
    }

    private void changeQuestion(Question to) {
        Question from = this.view.getQuestion();
        this.view.setQuestion(to);
        this.getPropertyChangeSupport().firePropertyChange(QUESTION_PROPERTY, (Object)from, (Object)to);
    }

    private void enableNavigators() {
        short count = 0;
        if (this.quiz != null) {
            count = this.quiz.getQuestionCount();
        }
        boolean prev = this.index > 0;
        boolean next = this.index < count - 1;
        this.firstBtn.setEnabled(prev);
        this.prevBtn.setEnabled(prev);
        this.nextBtn.setEnabled(next);
        this.lastBtn.setEnabled(next);
    }

    public void onQuizChange(QuizEvent e) {
        if (e.getAction() == 3 || e.getAction() == 4) {
            if (this.index < 0 && this.quiz.getQuestionCount() > 0) {
                this.index = 0;
            } else if (this.index >= this.quiz.getQuestionCount()) {
                this.index = (short)(this.quiz.getQuestionCount() - 1);
            }
            Question q = null;
            if (this.index >= 0) {
                q = this.quiz.getQuestion(this.index);
                this.changeQuestion(q);
            }
            this.rebuildSelector();
            this.selector.repaint();
            switch (e.getDetail()) {
                case 1: {
                    if (q == null) break;
                    this.view.setFocus(-1);
                    break;
                }
                case 3: {
                    this.view.setFocus(e.getAnswerIndex());
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.index = (short)this.selector.getSelectedIndex();
        if (this.index >= 0) {
            this.changeQuestion(this.quiz.getQuestion(this.index));
        }
        this.enableNavigators();
    }

    void firstBtn_actionPerformed(ActionEvent e) {
        if (this.selector.getSelectedIndex() < 0) {
            return;
        }
        this.selector.setSelectedIndex(0);
    }

    void prevBtn_actionPerformed(ActionEvent e) {
        if (this.selector.getSelectedIndex() < 0) {
            return;
        }
        this.selector.setSelectedIndex(this.selector.getSelectedIndex() - 1);
    }

    void nextBtn_actionPerformed(ActionEvent e) {
        if (this.selector.getSelectedIndex() < 0) {
            return;
        }
        this.selector.setSelectedIndex(this.selector.getSelectedIndex() + 1);
    }

    void lastBtn_actionPerformed(ActionEvent e) {
        if (this.selector.getSelectedIndex() < 0) {
            return;
        }
        this.selector.setSelectedIndex(this.selector.getItemCount() - 1);
    }
}

