/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.module.QuizDesigner_cancelBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizDesigner_delQuestionBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizDesigner_doneBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizDesigner_downQuestionBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizDesigner_newChoiceBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizDesigner_newQuestionBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizDesigner_newShortBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizDesigner_upQuestionBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizManager;
import com.elluminate.groupware.quiz.module.QuizPanel;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class QuizDesigner
extends JPanel
implements QuizListener,
PropertyChangeListener {
    private static I18n i18n = I18n.create(QuizDesigner.class);
    private ImageIcon newQuestionIcon = i18n.getIcon("QuizDesigner.newIcon");
    private ImageIcon delQuestionIcon = i18n.getIcon("QuizDesigner.deleteIcon");
    private ImageIcon upQuestionIcon = i18n.getIcon("QuizDesigner.upIcon");
    private ImageIcon downQuestionIcon = i18n.getIcon("QuizDesigner.downIcon");
    private ImageIcon newChoiceIcon = i18n.getIcon("QuizDesigner.newMCIcon");
    private ImageIcon newShortAnswerIcon = i18n.getIcon("QuizDesigner.newSAIcon");
    private ImageIcon doneIcon = i18n.getIcon("QuizDesigner.doneIcon");
    private ImageIcon cancelIcon = i18n.getIcon("QuizDesigner.cancelIcon");
    JPanel toolPanel = new JPanel();
    GridBagLayout toolLayout = new GridBagLayout();
    JToolBar toolbar = new AccessibleToolBar();
    BorderLayout designerLayout = new BorderLayout();
    CToolBarButton newQuestionBtn = new CToolBarButton();
    CToolBarButton doneBtn = new CToolBarButton();
    CToolBarButton cancelBtn = new CToolBarButton();
    JTextField title = new JTextField();
    QuizPanel editor = new QuizPanel(1);
    private QuizManager mgr = null;
    private Quiz quiz = null;
    private boolean modified = false;
    CToolBarButton newShortBtn = new CToolBarButton();
    CToolBarButton newChoiceBtn = new CToolBarButton();
    CToolBarButton delQuestionBtn = new CToolBarButton();
    CToolBarButton upQuestionBtn = new CToolBarButton();
    CToolBarButton downQuestionBtn = new CToolBarButton();

    public QuizDesigner() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"QuizDesigner", (Throwable)e, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.editor.addPropertyChangeListener("question", this);
        this.setLayout(this.designerLayout);
        this.doneBtn.setIcon((Icon)this.doneIcon);
        this.doneBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_DONETIP));
        this.doneBtn.setText("");
        this.doneBtn.addActionListener((ActionListener)new QuizDesigner_doneBtn_actionAdapter(this));
        this.cancelBtn.setHorizontalTextPosition(11);
        this.cancelBtn.setIcon((Icon)this.cancelIcon);
        this.cancelBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_CANCELTIP));
        this.cancelBtn.setText("");
        this.cancelBtn.addActionListener((ActionListener)new QuizDesigner_cancelBtn_actionAdapter(this));
        this.newQuestionBtn.setIcon((Icon)this.newQuestionIcon);
        this.newQuestionBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_NEWTIP));
        this.newQuestionBtn.addActionListener((ActionListener)new QuizDesigner_newQuestionBtn_actionAdapter(this));
        this.delQuestionBtn.setIcon((Icon)this.delQuestionIcon);
        this.delQuestionBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_DELETETIP));
        this.delQuestionBtn.setText("");
        this.delQuestionBtn.addActionListener((ActionListener)new QuizDesigner_delQuestionBtn_actionAdapter(this));
        this.newChoiceBtn.setIcon((Icon)this.newChoiceIcon);
        this.newChoiceBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_NEWMCTIP));
        this.newChoiceBtn.setText("");
        this.newChoiceBtn.addActionListener((ActionListener)new QuizDesigner_newChoiceBtn_actionAdapter(this));
        this.newShortBtn.setIcon((Icon)this.newShortAnswerIcon);
        this.newShortBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_NEWSATIP));
        this.newShortBtn.setText("");
        this.newShortBtn.addActionListener((ActionListener)new QuizDesigner_newShortBtn_actionAdapter(this));
        this.upQuestionBtn.setIcon((Icon)this.upQuestionIcon);
        this.upQuestionBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_UPTIP));
        this.upQuestionBtn.setText("");
        this.upQuestionBtn.addActionListener((ActionListener)new QuizDesigner_upQuestionBtn_actionAdapter(this));
        this.downQuestionBtn.setIcon((Icon)this.downQuestionIcon);
        this.downQuestionBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_DOWNTIP));
        this.downQuestionBtn.setText("");
        this.downQuestionBtn.addActionListener((ActionListener)new QuizDesigner_downQuestionBtn_actionAdapter(this));
        this.title.setText("");
        this.title.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_TITLETIP));
        this.toolPanel.setLayout(this.toolLayout);
        this.toolPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.add((Component)this.toolPanel, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets.left = 6;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 100.0;
        this.toolPanel.add((Component)this.title, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.toolPanel.add((Component)this.toolbar, gbc);
        this.toolbar.setFloatable(false);
        this.toolbar.add((Component)this.doneBtn);
        this.toolbar.add((Component)this.cancelBtn);
        this.toolbar.add((Component)this.newQuestionBtn);
        this.toolbar.add((Component)this.delQuestionBtn);
        this.toolbar.add((Component)this.upQuestionBtn);
        this.toolbar.add((Component)this.downQuestionBtn);
        this.toolbar.add((Component)this.newChoiceBtn);
        this.toolbar.add((Component)this.newShortBtn);
        this.add((Component)this.editor, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                QuizDesigner.this.title.requestFocus();
                QuizDesigner.this.title.selectAll();
            }
        });
    }

    public void setManager(QuizManager manager) {
        this.mgr = manager;
    }

    public void setQuiz(Quiz q) {
        if (this.quiz != null) {
            this.quiz.removeQuizListener((QuizListener)this);
        }
        this.quiz = q;
        if (this.quiz != null) {
            this.quiz.addQuizListener((QuizListener)this);
            this.title.setText(this.quiz.getText());
        }
        this.modified = false;
        this.editor.setQuiz(q);
        this.enableButtons();
    }

    public Quiz getQuiz() {
        return this.quiz;
    }

    private void enableButtons() {
        Question q = this.editor.getSelectedQuestion();
        boolean add = false;
        boolean del = false;
        boolean addMC = false;
        boolean addSA = false;
        boolean up = false;
        boolean down = false;
        if (this.quiz != null) {
            if (q != null) {
                if (!q.isShortAnswer()) {
                    addMC = true;
                }
                if (!q.isMultipleChoice() && !q.isShortAnswer()) {
                    addSA = true;
                }
                del = true;
                up = q.getIndex() > 0;
                down = q.getIndex() < this.quiz.getQuestionCount() - 1;
            }
            add = true;
        }
        this.newQuestionBtn.setEnabled(add);
        this.delQuestionBtn.setEnabled(del);
        this.newChoiceBtn.setEnabled(addMC);
        this.newShortBtn.setEnabled(addSA);
        this.upQuestionBtn.setEnabled(up);
        this.downQuestionBtn.setEnabled(down);
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean finish(boolean confirm) {
        if (this.modified) {
            if (confirm) {
                int result = ModalDialog.showConfirmDialog((Component)this.mgr.getAppFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_MODIFIEDEXIT), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_CONFIRMEXIT), (int)1, (int)3);
                switch (result) {
                    case 2: {
                        return false;
                    }
                    case 0: {
                        return this.save();
                    }
                }
            } else {
                return this.save();
            }
        }
        this.mgr.release(this.quiz);
        return true;
    }

    public boolean save() {
        this.quiz.setText(this.title.getText());
        try {
            this.quiz.validate();
            this.mgr.update(this.quiz);
            return true;
        }
        catch (QuizException ex) {
            ModalDialog.showMessageDialog((Component)this, (Object)ex.toString(), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_INVALID), (int)0);
            return false;
        }
    }

    void title_actionPerformed(ActionEvent e) {
        this.quiz.setText(this.title.getText());
    }

    void cancelBtn_actionPerformed(ActionEvent e) {
        this.finish(true);
    }

    void doneBtn_actionPerformed(ActionEvent e) {
        this.save();
    }

    void newQuestionBtn_actionPerformed(ActionEvent e) {
        this.quiz.add(new Question(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_NEWQUESTIONTEXT)));
        this.editor.setSelectedIndex((short)(this.quiz.getQuestionCount() - 1));
    }

    void delQuestionBtn_actionPerformed(ActionEvent e) {
        this.quiz.remove(this.editor.getSelectedQuestion());
    }

    void newChoiceBtn_actionPerformed(ActionEvent e) {
        Question q = this.editor.getSelectedQuestion();
        q.addAnswer(new Answer(i18n.getString((PropertiesEnum)StringsProperties.QUIZDESIGNER_NEWANSWERTEXT)));
    }

    void newShortBtn_actionPerformed(ActionEvent e) {
        Question q = this.editor.getSelectedQuestion();
        q.addAnswer(new Answer());
    }

    public void onQuizChange(QuizEvent e) {
        this.modified = true;
        if (e.getAction() == 3) {
            this.enableButtons();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.enableButtons();
    }

    void upQuestionBtn_actionPerformed(ActionEvent e) {
        Question q = this.editor.getSelectedQuestion();
        short from = q.getIndex();
        short to = (short)(from - 1);
        this.quiz.moveQuestion(from, to);
        if (to >= 0 && to < this.quiz.getQuestionCount()) {
            this.editor.setSelectedIndex(to);
        }
    }

    void downQuestionBtn_actionPerformed(ActionEvent e) {
        Question q = this.editor.getSelectedQuestion();
        short from = q.getIndex();
        short to = (short)(from + 1);
        this.quiz.moveQuestion(from, to);
        if (to >= 0 && to < this.quiz.getQuestionCount()) {
            this.editor.setSelectedIndex(to);
        }
    }
}

