/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.QuizPart;
import com.elluminate.groupware.quiz.module.QuestionPanel;
import com.elluminate.groupware.quiz.module.QuizLine;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;

class QuestionLine
extends QuizLine {
    static final String PRE = "<b>";
    static final String POST = "</b>";
    Question question = null;

    public QuestionLine(QuestionPanel panel, int row, int mode) {
        super(panel, row, null);
        super.setHtmlFormatting(PRE, POST);
        this.icon = new JLabel(QuestionPanel.questionIcon);
        this.icon.setOpaque(false);
        this.addTextComponent(mode == 1);
        this.addComponents(10);
        this.setMode(mode);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.question.removeQuizListener((QuizListener)this);
        this.removeComponents();
    }

    public void setQuestion(Question q) {
        if (this.question != null) {
            this.question.removeQuizListener((QuizListener)this);
        }
        this.question = q;
        super.setPart((QuizPart)q);
        if (this.question != null) {
            this.question.addQuizListener((QuizListener)this);
        }
        this.setMode(this.mode);
    }

    @Override
    public void setMode(int newMode) {
        boolean inDesigner = newMode == 1;
        boolean visible = this.question != null;
        this.mode = newMode;
        this.icon.setVisible(visible);
        this.setTextEditable(inDesigner, visible);
        this.readData();
    }

    @Override
    public void readData() {
        if (this.question == null) {
            return;
        }
        this.updateText(this.question.getText(), null);
    }

    @Override
    public void writeData() {
        if (this.mode == 1 && this.isDifferent(this.question.getText())) {
            this.question.setText(this.getText());
        }
    }

    @Override
    public void onQuizChange(QuizEvent e) {
        if (e.getAction() == 4) {
            this.readData();
        }
    }

    @Override
    public void textChanged(DocumentEvent e) {
        this.writeData();
    }
}

