/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.Response;
import com.elluminate.groupware.quiz.module.IconSelector;
import com.elluminate.util.I18n;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class CorrectIconSelector
implements IconSelector {
    private static I18n i18n = I18n.create(CorrectIconSelector.class);
    private ImageIcon unknownIcon = i18n.getIcon("CorrectIconSelector.unknown");
    private ImageIcon correctIcon = i18n.getIcon("CorrectIconSelector.correct");
    private ImageIcon incorrectIcon = i18n.getIcon("CorrectIconSelector.incorrect");

    @Override
    public Icon getIcon(JList list, int idx, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Question) {
            Question q = (Question)value;
            Response right = q.getCorrectResponse();
            Response user = q.getResponse();
            if (right == null) {
                return this.unknownIcon;
            }
            if (user == null) {
                return this.incorrectIcon;
            }
            if (q.isMultipleChoice()) {
                if (right.getSelection() == user.getSelection()) {
                    return this.correctIcon;
                }
                return this.incorrectIcon;
            }
            if (right.getText().equals(user.getText())) {
                return this.correctIcon;
            }
            return this.unknownIcon;
        }
        return null;
    }
}

