/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.QuizPart;
import com.elluminate.groupware.quiz.module.QuestionPanel;
import com.elluminate.groupware.quiz.module.QuizLine;
import com.elluminate.gui.component.RollOverButton;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

abstract class AnswerLine
extends QuizLine {
    protected Answer answer;
    protected JButton up;
    protected JButton down;
    protected JButton delete;

    public AnswerLine(QuestionPanel panel, int row) {
        super(panel, row, null);
    }

    public void setAnswer(Answer a) {
        if (this.answer != null) {
            this.answer.removeQuizListener((QuizListener)this);
        }
        this.answer = a;
        this.setPart((QuizPart)a);
        if (this.answer != null) {
            this.answer.addQuizListener((QuizListener)this);
        }
        this.updated();
    }

    protected void createAnswerEditor() {
        this.editor = new JPanel(new GridLayout(1, 3));
        this.editor.setOpaque(false);
        this.up = new RollOverButton((Icon)QuestionPanel.upIcon);
        this.up.setToolTipText(QuestionPanel.upTip);
        this.down = new RollOverButton((Icon)QuestionPanel.downIcon);
        this.down.setToolTipText(QuestionPanel.downTip);
        this.delete = new RollOverButton((Icon)QuestionPanel.deleteIcon);
        this.delete.setToolTipText(QuestionPanel.deleteTip);
        JButton[] eBtn = new JButton[]{this.delete, this.up, this.down};
        for (int i = 0; i < eBtn.length; ++i) {
            eBtn[i].setPreferredSize(new Dimension(20, 20));
            eBtn[i].addActionListener(this);
            this.editor.add(eBtn[i]);
        }
    }

    protected void disposeAnswerEditor() {
        JButton[] eBtn = new JButton[]{this.up, this.down, this.delete};
        for (int i = 0; i < eBtn.length; ++i) {
            eBtn[i].removeActionListener(this);
        }
    }

    @Override
    public void updated() {
        if (this.up != null && this.answer != null) {
            Question question = (Question)this.answer.getParent();
            short nAnswers = question.getAnswerCount();
            short idx = this.answer.getIndex();
            this.up.setVisible(idx > 0);
            this.down.setVisible(idx < nAnswers - 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton src = (JButton)e.getSource();
        Answer a = (Answer)this.getPart();
        Question q = (Question)a.getParent();
        short idx = a.getIndex();
        if (src == this.delete) {
            q.remove(a);
        } else if (src == this.up) {
            q.moveAnswer(idx, (short)(idx - 1));
        } else if (src == this.down) {
            q.moveAnswer(idx, (short)(idx + 1));
        }
    }

    @Override
    public void onQuizChange(QuizEvent e) {
        if (e.getAction() == 3) {
            this.updated();
        }
    }
}

