/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.caption.module.captioner;

import com.elluminate.groupware.caption.CaptionDebug;
import com.elluminate.groupware.caption.module.CaptionBuffer;
import com.elluminate.groupware.caption.module.Captioner;
import com.elluminate.groupware.caption.module.captioner.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class KeyboardCaptioner
implements Captioner {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_SIG = new Class[0];
    private I18n i18n = I18n.create((Object)this);
    private Object savedState = null;
    private Keymap inputKeymap;
    private CaptionBuffer buffer;

    @Override
    public String getName() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.KEYBOARDCAPTIONER_NAME);
    }

    @Override
    public boolean isDefaultCaptioner() {
        return true;
    }

    @Override
    public void setup(Component parent, JTextPane text) {
        this.buildKeymaps(text);
    }

    @Override
    public void start(JTextPane text, CaptionBuffer buf) {
        this.buffer = buf;
        text.setKeymap(this.inputKeymap);
        text.setEditable(true);
    }

    @Override
    public void stop(JTextPane text) {
        this.restoreKeyState(text);
        text.setEditable(false);
        this.buffer = null;
    }

    private void buildKeymaps(JTextPane c) {
        if (this.inputKeymap != null) {
            return;
        }
        this.inputKeymap = JTextComponent.addKeymap(null, c.getKeymap());
        HashMap bindings = this.getKeyStrokes(c);
        EditorKit kit = c.getEditorKit();
        Action[] actions = kit.getActions();
        HashMap<Object, Action> actionMap = new HashMap<Object, Action>();
        for (int i = 0; i < actions.length; ++i) {
            actionMap.put(actions[i].getValue("Name"), actions[i]);
        }
        for (KeyStroke k : bindings.keySet()) {
            String a = (String)bindings.get(k);
            Action action = null;
            if (CaptionDebug.BINDINGS.show()) {
                LogSupport.message((Object)this, (String)"setKeyMap", (String)("Rebinding " + k + " (" + a + ")"));
            }
            action = a.equals("insert-break") ? new ActionWrapper((Action)actionMap.get(a)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    if (KeyboardCaptioner.this.buffer != null) {
                        KeyboardCaptioner.this.buffer.append('\n');
                    }
                }
            } : (a.equals("insert-tab") ? new ActionWrapper((Action)actionMap.get(a)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    if (KeyboardCaptioner.this.buffer != null) {
                        KeyboardCaptioner.this.buffer.append('\t');
                    }
                }
            } : (a.equals("delete-previous") ? new ActionWrapper((Action)actionMap.get(a)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    if (KeyboardCaptioner.this.buffer != null) {
                        KeyboardCaptioner.this.buffer.backspace();
                    }
                }
            } : (Action)actionMap.get("beep")));
            this.inputKeymap.addActionForKeyStroke(k, action);
        }
        this.inputKeymap.setDefaultAction(new ActionWrapper((Action)actionMap.get("default-typed")){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                JTextComponent target = null;
                try {
                    target = (JTextComponent)e.getSource();
                }
                catch (Throwable t) {
                    return;
                }
                if (target != null && e != null) {
                    char c;
                    if (!target.isEditable() || !target.isEnabled()) {
                        return;
                    }
                    String content = e.getActionCommand();
                    int mod = e.getModifiers();
                    if (content != null && content.length() > 0 && (mod & 8) == (mod & 2) && (c = content.charAt(0)) >= ' ' && c != '\u007f') {
                        KeyboardCaptioner.this.buffer.append(c);
                    }
                }
            }
        });
    }

    private void restoreKeyState(JTextComponent c) {
        if (this.savedState == null) {
            return;
        }
        if (this.savedState instanceof Keymap) {
            c.setKeymap((Keymap)this.savedState);
            return;
        }
        try {
            Class<?> inputMapCls = Class.forName("javax.swing.InputMap");
            Class[] sig = new Class[]{Integer.TYPE, inputMapCls};
            Object[] args = new Object[]{new Integer(0), this.savedState};
            Method setInputMap = c.getClass().getMethod("setInputMap", sig);
            setInputMap.invoke((Object)c, args);
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"restoreKeyState", (Throwable)t, (boolean)true);
        }
    }

    private HashMap getKeyStrokes(JTextComponent c) {
        HashMap<KeyStroke, Object> map = new HashMap<KeyStroke, Object>();
        try {
            Class[] getSig = new Class[]{KeyStroke.class};
            Object[] getArgs = new Object[1];
            Method getInputMap = c.getClass().getMethod("getInputMap", EMPTY_SIG);
            Object inputMap = getInputMap.invoke((Object)c, EMPTY_ARGS);
            Method allKeys = inputMap.getClass().getMethod("allKeys", EMPTY_SIG);
            KeyStroke[] ks = (KeyStroke[])allKeys.invoke(inputMap, EMPTY_ARGS);
            Method get = inputMap.getClass().getMethod("get", getSig);
            for (int i = 0; i < ks.length; ++i) {
                getArgs[0] = ks[i];
                Object a = get.invoke(inputMap, getArgs);
                if (a instanceof String) {
                    map.put(ks[i], a);
                    continue;
                }
                if (!(a instanceof Action)) continue;
                map.put(ks[i], ((Action)a).getValue("Name"));
            }
            this.savedState = inputMap;
        }
        catch (Throwable t) {
            Keymap keymap;
            for (Keymap m = keymap = JTextComponent.addKeymap(null, c.getKeymap()); m != null; m = m.getResolveParent()) {
                KeyStroke[] keystrokes = m.getBoundKeyStrokes();
                for (int i = 0; i < keystrokes.length; ++i) {
                    KeyStroke k = keystrokes[i];
                    Action a = keymap.getAction(k);
                    if (map.containsKey(k)) continue;
                    map.put(k, a.getValue("Name"));
                }
            }
            this.savedState = keymap;
        }
        return map;
    }

    class ActionWrapper
    implements Action {
        protected Action actual;

        public ActionWrapper(Action real) {
            this.actual = real;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.actual.actionPerformed(e);
        }

        @Override
        public Object getValue(String nm) {
            return this.actual.getValue(nm);
        }

        @Override
        public void putValue(String nm, Object value) {
            this.actual.putValue(nm, value);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener lst) {
            this.actual.addPropertyChangeListener(lst);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener lst) {
            this.actual.removePropertyChangeListener(lst);
        }

        @Override
        public boolean isEnabled() {
            return this.actual.isEnabled();
        }

        @Override
        public void setEnabled(boolean on) {
            this.actual.setEnabled(on);
        }
    }
}

