/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.caption.module;

import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRParticipantEventType;
import com.elluminate.groupware.caption.module.CaptionModel;
import com.elluminate.groupware.caption.module.CaptionTerminal;
import com.elluminate.groupware.caption.module.StringsProperties;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CaptionSources {
    private static I18n i18n = I18n.create(CaptionSources.class);
    private static final String SOURCE_FEATURE_PATH = "/caption/captionSource";
    private static final Short NO_SOURCE_SELECTED = -32767;
    private Map<Short, Set<Short>> sources = new HashMap<Short, Set<Short>>();
    private CaptionTerminal terminal;
    private CaptionModel model;
    private FeatureBroker broker;
    private EnumeratedFeature<Short> sourceFeature;
    private CRSession session;

    @Inject
    public void initCaptionTerminal(CaptionTerminal ct) {
        this.terminal = ct;
    }

    @Inject
    public void initSession(CRSession s) {
        this.session = s;
        this.session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onParticipantJoinedRoom(CRParticipantEvent event) {
                CaptionSources.this.handleRoomChange(event);
            }

            public void onParticipantLeftRoom(CRParticipantEvent event) {
                CaptionSources.this.handleRoomChange(event);
            }
        });
    }

    @Inject
    public void initCaptionModel(CaptionModel cm) {
        this.model = cm;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker fb) {
        this.broker = fb;
    }

    public void setupSources() {
        this.terminal.setupCaptionTerminal();
        this.terminal.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CaptionSources.this.handlePropertyChange(evt);
            }
        });
        this.model.addPropertyChangeListener("mode.change", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CaptionSources.this.updateSourceFeature();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRoomChange(CRParticipantEvent event) {
        Map<Short, Set<Short>> map = this.sources;
        synchronized (map) {
            CRParticipant participant = event.getParticipant();
            short grp = event.getRoom().getID();
            if (this.isJoiningRoom(event) && this.isCaptioner(participant)) {
                this.addToSources(grp, participant.getID());
            } else {
                this.removeFromSources(grp, participant.getID());
            }
            this.updateSourceFeature();
        }
    }

    private boolean isJoiningRoom(CRParticipantEvent event) {
        return event.getEventType() == CRParticipantEventType.JOINED;
    }

    private boolean isCaptioner(CRParticipant participant) {
        return participant.getPropertyStore().getProperty("caption.sending", false);
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("caption.sending")) {
            short srcId = -32767;
            if (evt.getSource() instanceof ClientInfo) {
                srcId = ((ClientInfo)evt.getSource()).getAddress();
            }
            CRParticipant participant = this.session.getParticipantById(srcId);
            Boolean captioner = evt.getNewValue() == null ? false : (Boolean)evt.getNewValue();
            if (participant == null || participant.getRoom() == null) {
                return;
            }
            this.changeSourceAvail(participant.getRoom().getID(), participant.getID(), captioner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSourceAvail(short grp, short addr, boolean add) {
        Map<Short, Set<Short>> map = this.sources;
        synchronized (map) {
            if (add) {
                this.addToSources(grp, addr);
            } else {
                this.removeFromSources(grp, addr);
            }
            this.updateSourceFeature();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromSources(short groupId, short participantId) {
        Map<Short, Set<Short>> map = this.sources;
        synchronized (map) {
            if (this.sources.get(ShortList.get((short)groupId)) != null) {
                this.sources.get(ShortList.get((short)groupId)).remove(ShortList.get((short)participantId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSources(short groupId, short participantId) {
        Map<Short, Set<Short>> map = this.sources;
        synchronized (map) {
            Short gid = this.getGroupContainingParticipant(participantId);
            if (gid != null && gid != ShortList.get((short)groupId)) {
                this.removeFromSources(gid, participantId);
            }
            this.getSourcesForGroup(groupId).add(ShortList.get((short)participantId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Short getGroupContainingParticipant(short participantId) {
        Map<Short, Set<Short>> map = this.sources;
        synchronized (map) {
            for (Short groupId : this.sources.keySet()) {
                if (!this.getSourcesForGroup(groupId).contains(ShortList.get((short)participantId))) continue;
                return groupId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Short> getSourcesForGroup(short groupId) {
        Short gid = ShortList.get((short)groupId);
        Map<Short, Set<Short>> map = this.sources;
        synchronized (map) {
            if (this.sources.get(gid) == null) {
                this.sources.put(gid, new HashSet());
            }
            return this.sources.get(gid);
        }
    }

    private void updateSourceFeature() {
        boolean enabled;
        boolean bl = enabled = this.model.getMode() == 1;
        if (!enabled) {
            if (this.sourceFeature != null) {
                this.sourceFeature.setEnabled(false);
                this.broker.removeFeature(this.sourceFeature);
            }
            return;
        }
        if (this.sourceFeature != null && this.sourceFeature.isPublished()) {
            this.sourceFeature.setEnabled(false);
            this.broker.removeFeature(this.sourceFeature);
        }
        Object[] allowedValues = this.generateAllowedValues();
        Short initialSelection = this.determineInitialSelection((Short[])allowedValues, NO_SOURCE_SELECTED);
        this.sourceFeature = this.broker.createEnumeratedFeature((Object)this, SOURCE_FEATURE_PATH, Short.class, true, (Object)initialSelection, allowedValues, i18n.getString((PropertiesEnum)StringsProperties.CAPTIONBEAN_SOURCE), null);
        for (Object allowedValue : allowedValues) {
            String displayName = allowedValue == NO_SOURCE_SELECTED ? i18n.getString((PropertiesEnum)StringsProperties.CAPTION_SOURCES_NONE) : this.session.getParticipantById(((Short)allowedValue).shortValue()).getDisplayName();
            this.sourceFeature.setValueText(allowedValue, displayName);
        }
        this.sourceFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                Short val = (Short)ev.getNewValue();
                CaptionSources.this.model.setSource(CaptionSources.this.session.getParticipantById(val.shortValue()));
                CaptionSources.this.model.setPreferredSource(CaptionSources.this.session.getParticipantById(val.shortValue()));
            }
        });
        if (this.sourceFeature != null && !this.sourceFeature.isPublished()) {
            this.broker.setFeaturePublished(this.sourceFeature, true);
        }
        this.model.setSource(this.session.getParticipantById(initialSelection.shortValue()));
    }

    private Short determineInitialSelection(Short[] allowedValues, Short initialSelection) {
        if (this.model.getPreferredSource() != null && Arrays.asList(allowedValues).contains(this.model.getPreferredSource().getID())) {
            initialSelection = this.model.getPreferredSource().getID();
        } else if (this.model.getSource() != null && Arrays.asList(allowedValues).contains(this.model.getSource().getID())) {
            initialSelection = this.model.getSource().getID();
        } else if (this.model.getSource() == null && allowedValues.length > 1 || allowedValues.length > 1) {
            initialSelection = allowedValues[1];
        }
        return initialSelection;
    }

    private Short[] generateAllowedValues() {
        short myGid;
        Set<Short> captioners;
        ArrayList<Short> values = new ArrayList<Short>();
        values.add(NO_SOURCE_SELECTED);
        if (this.session.getMe() != null && this.session.getMe().getRoom() != null && (captioners = this.sources.get(myGid = this.session.getMe().getRoom().getID())) != null) {
            for (Short uid : captioners) {
                values.add(uid);
            }
        }
        return values.toArray(new Short[0]);
    }
}

