/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.caption.module;

public class CaptionBuffer {
    private char[] buffer;
    private int start;
    private int end;
    private int avail;
    private int printable;

    public CaptionBuffer(int size) {
        this.buffer = new char[size];
        this.avail = 0;
        this.printable = 0;
        this.start = 0;
        this.end = 0;
    }

    public void append(char c) {
        if (this.avail == this.buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ++this.avail;
        ++this.printable;
        this.buffer[this.end++] = c;
        if (this.end == this.buffer.length) {
            this.end = 0;
        }
    }

    public void append(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.append(s.charAt(i));
        }
    }

    public char backspace() {
        if (this.printable == 0) {
            ++this.avail;
            this.buffer[this.end++] = 8;
            if (this.end == this.buffer.length) {
                this.end = 0;
            }
            return '\b';
        }
        --this.printable;
        --this.avail;
        if (this.end == 0) {
            this.end = this.buffer.length;
        }
        return this.buffer[--this.end];
    }

    public int read(char[] into) {
        int nBytes = Math.min(into.length, this.avail);
        int blk = Math.min(nBytes, this.buffer.length - this.start);
        int nRead = 0;
        System.arraycopy(this.buffer, this.start, into, nRead, blk);
        this.avail -= blk;
        if (this.avail < this.printable) {
            this.printable = this.avail;
        }
        this.start += blk;
        if (this.start == this.buffer.length) {
            this.start = 0;
        }
        nRead += blk;
        if ((nBytes -= blk) == 0) {
            return nRead;
        }
        blk = Math.min(nBytes, this.end);
        System.arraycopy(this.buffer, 0, into, nRead, blk);
        this.avail -= blk;
        if (this.avail < this.printable) {
            this.printable = this.avail;
        }
        this.start += blk;
        if (this.start == this.buffer.length) {
            this.start = 0;
        }
        nBytes -= blk;
        return nRead += blk;
    }

    public boolean isEmpty() {
        return this.avail == 0;
    }

    public int size() {
        return this.avail;
    }
}

