/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.moduleloading;

import com.elluminate.classroom.moduleloading.LoadingStatusListener;
import com.elluminate.util.log.LogSupport;
import java.util.HashMap;
import java.util.LinkedList;

public class LoadingStatus {
    private static final String GLOBAL_STATE = "_global";
    private HashMap<String, ReadyState> entities = new HashMap();
    private ReadyState globalState = new ReadyState("_global");

    public LoadingStatus() {
        this.entities.put(GLOBAL_STATE, this.globalState);
    }

    public boolean addListener(LoadingStatusListener l) {
        return this.addListener(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(String entityName, LoadingStatusListener l) {
        ReadyState readyState;
        HashMap<String, ReadyState> hashMap = this.entities;
        synchronized (hashMap) {
            if (entityName == null || entityName.length() == 0) {
                readyState = this.globalState;
            } else {
                readyState = this.entities.get(entityName);
                if (readyState == null) {
                    readyState = new ReadyState(entityName);
                    this.entities.put(entityName, readyState);
                }
            }
        }
        if (l != null) {
            readyState.addListener(l);
        }
        return readyState.isReady();
    }

    public boolean decrement() {
        return this.globalState.decrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrement(String entityName) {
        ReadyState readyState;
        HashMap<String, ReadyState> hashMap = this.entities;
        synchronized (hashMap) {
            readyState = this.entities.get(entityName);
        }
        if (readyState == null) {
            return true;
        }
        if (readyState == this.globalState) {
            return this.globalState.decrement();
        }
        this.globalState.decrement();
        return readyState.decrement();
    }

    public boolean increment() {
        return this.globalState.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean increment(String entityName) {
        ReadyState readyState;
        HashMap<String, ReadyState> hashMap = this.entities;
        synchronized (hashMap) {
            readyState = this.entities.get(entityName);
        }
        if (readyState == null) {
            return false;
        }
        if (readyState == this.globalState) {
            return this.globalState.increment();
        }
        this.globalState.increment();
        return readyState.increment();
    }

    public boolean isReady() {
        return this.isReady(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady(String entityName) {
        if (entityName == null || entityName.length() == 0) {
            return this.globalState.isReady();
        }
        HashMap<String, ReadyState> hashMap = this.entities;
        synchronized (hashMap) {
            ReadyState readyState = this.entities.get(entityName);
            if (readyState == null) {
                return false;
            }
            return readyState.isReady();
        }
    }

    public boolean removeListener(LoadingStatusListener l) {
        return this.removeListener(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(String entityName, LoadingStatusListener l) {
        ReadyState readyState;
        HashMap<String, ReadyState> hashMap = this.entities;
        synchronized (hashMap) {
            if (entityName == null || entityName.length() == 0) {
                readyState = this.globalState;
            } else {
                readyState = this.entities.get(entityName);
                if (readyState == null) {
                    readyState = new ReadyState(entityName);
                    this.entities.put(entityName, readyState);
                }
            }
        }
        if (l != null) {
            readyState.removeListener(l);
        }
        return readyState.isReady();
    }

    class ReadyState {
        private String entityName;
        private int refCount = 0;
        private LinkedList<LoadingStatusListener> listeners = new LinkedList();

        ReadyState(String entityName) {
            this.entityName = entityName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(LoadingStatusListener l) {
            LinkedList<LoadingStatusListener> linkedList = this.listeners;
            synchronized (linkedList) {
                if (!this.listeners.contains(l)) {
                    this.listeners.add(l);
                }
            }
        }

        public boolean decrement() {
            --this.refCount;
            if (this.refCount <= 0) {
                this.refCount = 0;
                this.fireListeners();
            }
            return this.refCount <= 0;
        }

        public String getName() {
            return this.entityName;
        }

        public boolean increment() {
            ++this.refCount;
            return false;
        }

        public boolean isReady() {
            return this.refCount == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(LoadingStatusListener l) {
            LinkedList<LoadingStatusListener> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireListeners() {
            LoadingStatusListener[] listenerArray;
            LinkedList<LoadingStatusListener> linkedList = this.listeners;
            synchronized (linkedList) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                listenerArray = new LoadingStatusListener[this.listeners.size()];
                listenerArray = this.listeners.toArray(listenerArray);
            }
            for (int i = 0; i < listenerArray.length; ++i) {
                try {
                    listenerArray[i].onStatusChange(LoadingStatus.this, this.entityName);
                    continue;
                }
                catch (Throwable t) {
                    LogSupport.error((String)("ReadyState.fire - " + this.entityName + ", error: " + t.getMessage()));
                }
            }
        }
    }
}

