/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream.imageprocessing;

public class CoeffsBuf {
    private static final int DEFAULT_MAX_FREE_COEFFS_BUFS = 10800;
    private static int coeffsBufCreateCnt = 0;
    private static int coeffsBufDiscardCnt = 0;
    private static int coeffsBufFreeCnt = 0;
    private static CoeffsBuf[] coeffsBufStack = null;
    private static Object coeffsBufStackLock = new Object();
    private static int maxFreeCoeffsBufs = 10800;
    public byte[] buffer = new byte[64];
    private int refCnt = 1;

    private CoeffsBuf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoeffsBuf get() {
        CoeffsBuf buf;
        Object object = coeffsBufStackLock;
        synchronized (object) {
            if (coeffsBufFreeCnt < 1) {
                buf = new CoeffsBuf();
                ++coeffsBufCreateCnt;
            } else {
                buf = coeffsBufStack[--coeffsBufFreeCnt];
                CoeffsBuf.coeffsBufStack[CoeffsBuf.coeffsBufFreeCnt] = null;
                buf.refCnt = 1;
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (this.refCnt < 1) {
            throw new IllegalArgumentException("Invalid refCnt: " + this.refCnt);
        }
        if (--this.refCnt < 1) {
            Object object = coeffsBufStackLock;
            synchronized (object) {
                if (coeffsBufFreeCnt >= maxFreeCoeffsBufs) {
                    this.buffer = null;
                    ++coeffsBufDiscardCnt;
                } else {
                    if (coeffsBufStack == null) {
                        coeffsBufStack = new CoeffsBuf[maxFreeCoeffsBufs];
                    }
                    CoeffsBuf.coeffsBufStack[CoeffsBuf.coeffsBufFreeCnt++] = this;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxFreeCoeffsBufs(int count) {
        Object object = coeffsBufStackLock;
        synchronized (object) {
            if (coeffsBufStack != null && coeffsBufStack.length != count) {
                CoeffsBuf[] newStack = new CoeffsBuf[count];
                int oldStackLen = coeffsBufStack.length;
                if (coeffsBufFreeCnt <= count) {
                    System.arraycopy(coeffsBufStack, 0, newStack, 0, coeffsBufFreeCnt);
                } else {
                    System.arraycopy(coeffsBufStack, 0, newStack, 0, count);
                    for (int i = count; i < coeffsBufFreeCnt; ++i) {
                        CoeffsBuf.coeffsBufStack[i].buffer = null;
                        CoeffsBuf.coeffsBufStack[i] = null;
                    }
                    coeffsBufFreeCnt = count;
                }
                coeffsBufStack = newStack;
            }
            maxFreeCoeffsBufs = count;
        }
    }

    public synchronized CoeffsBuf share() {
        ++this.refCnt;
        return this;
    }

    public synchronized CoeffsBuf unshare() {
        if (this.refCnt < 2) {
            return this;
        }
        CoeffsBuf copy = CoeffsBuf.get();
        System.arraycopy(this.buffer, 0, copy.buffer, 0, this.buffer.length);
        --this.refCnt;
        return copy;
    }
}

