/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFClient;
import com.elluminate.mediastream.MRFFeed;
import com.elluminate.mediastream.MRFGroup;
import com.elluminate.mediastream.MRFHeader;
import com.elluminate.mediastream.MRFModule;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.MRFSessionName;
import com.elluminate.mediastream.MRFShow;
import com.elluminate.mediastream.PacketListener;
import com.elluminate.mediastream.TimedPacket;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class MRFile {
    public static final byte[] FOURCC = new byte[]{77, 82, 70, 32};
    public static final boolean DEBUG = false;
    public static final String SUFFIX = ".mrf";
    public static final String DEFAULT_SESSION_NAME = "Disconnected Session";
    private static final long FLUSH_TIME = 1000L;
    private HashMap<Short, MRFClient> clientByAddress = new HashMap();
    private HashMap<String, MRFClient> clientByName = new HashMap();
    private HashMap<Short, MRFFeed> feedByIndex = new HashMap();
    private HashMap<String, MRFFeed> feedByName = new HashMap();
    private long fileOffset = 0L;
    private boolean firstWrite = true;
    private Dimension forcedOutputSize = new Dimension(0, 0);
    private HashMap<Short, MRFGroup> groupById = new HashMap();
    private HashMap<String, MRFGroup> groupByName = new HashMap();
    private MRFHeader header = new MRFHeader("Disconnected Session", System.currentTimeMillis(), 0, 0);
    private long lastPacketTime = 0L;
    private long lastFlushTime = 0L;
    private File mediaFile;
    private DataInputStream mediaInputStream = null;
    private long mediaFileLength = 0L;
    private DataOutputStream mediaOutputStream = null;
    private HashMap<Short, MRFModule> moduleByIndex = new HashMap();
    private HashMap<String, MRFModule> moduleByName = new HashMap();
    private ArrayList<PacketListener> packetListeners = new ArrayList();
    private int width = 0;

    public MRFile(File mediaFile) {
        this.setMediaFile(mediaFile);
    }

    public MRFile(InputStream is) throws IOException {
        byte[] buf = new byte[32768];
        this.mediaFile = File.createTempFile("Buffered.", SUFFIX);
        this.mediaFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(this.mediaFile);
        int read = 0;
        while (read >= 0) {
            if (read > 0) {
                fos.write(buf, 0, read);
            }
            read = is.read(buf);
        }
        fos.close();
        this.setMediaFile(this.mediaFile);
    }

    public MRFile(String mediaFile) {
        if (!mediaFile.toLowerCase(Locale.ENGLISH).endsWith(SUFFIX)) {
            this.setMediaFile(new File(mediaFile + SUFFIX));
        } else {
            this.setMediaFile(new File(mediaFile));
        }
    }

    public MRFile(File mediaFile, String sessionName, long date, int width, int height) {
        this(mediaFile);
        this.forcedOutputSize.setSize(width, height);
        this.header = new MRFHeader(sessionName, date, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketListener l) {
        ArrayList<PacketListener> arrayList = this.packetListeners;
        synchronized (arrayList) {
            if (!this.packetListeners.contains(l)) {
                this.packetListeners.add(l);
            }
        }
    }

    public Iterator<MRFClient> clientIterator() {
        return this.clientByName.values().iterator();
    }

    public void close() {
        if (this.mediaInputStream != null) {
            try {
                this.mediaInputStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mediaInputStream = null;
        }
        if (this.mediaOutputStream != null) {
            try {
                this.mediaOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mediaOutputStream = null;
        }
        this.feedByIndex.clear();
        this.feedByName.clear();
        this.moduleByIndex.clear();
        this.moduleByName.clear();
        this.firstWrite = true;
    }

    public Iterator feedIterator() {
        return this.feedByName.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePacketListeners(MRFPacket packet) {
        ArrayList<PacketListener> arrayList = this.packetListeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.packetListeners.size(); ++i) {
                try {
                    this.packetListeners.get(i).onMRFPacket(packet);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public MRFClient getClientByAddress(short clientAddress) {
        return this.clientByAddress.get(new Short(clientAddress));
    }

    public MRFClient getClientByAddress(String clientName) {
        return this.clientByName.get(clientName);
    }

    public MRFFeed getFeedByIndex(short feedIndex) {
        return this.feedByIndex.get(new Short(feedIndex));
    }

    public MRFFeed getFeedByName(String feedName) {
        return this.feedByName.get(feedName);
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public MRFGroup getGroupByAddress(short groupAddress) {
        return this.groupById.get(new Short(groupAddress));
    }

    public MRFGroup getGroupByAddress(String groupName) {
        return this.groupByName.get(groupName);
    }

    public MRFHeader getHeader() {
        return this.header;
    }

    public Dimension getForcedSize() {
        return this.forcedOutputSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataInputStream getInputStream() throws FileNotFoundException {
        MRFile mRFile = this;
        synchronized (mRFile) {
            if (this.mediaInputStream == null && this.mediaFile != null) {
                this.mediaInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.mediaFile)));
                try {
                    byte[] fourCC = new byte[4];
                    this.mediaInputStream.read(fourCC);
                    this.fileOffset = 4L;
                    if (fourCC[0] == FOURCC[0] && fourCC[1] == FOURCC[1] && fourCC[2] == FOURCC[2] && fourCC[3] == FOURCC[3]) {
                        return this.mediaInputStream;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new FileNotFoundException(this.mediaFile.getPath() + " is not an MRF file.");
            }
            if (this.mediaOutputStream != null) {
                throw new RuntimeException("Read on write-only MRF file.");
            }
        }
        return this.mediaInputStream;
    }

    public long getLastPacketTime() {
        return this.lastPacketTime;
    }

    public long getMediaFileLength() {
        return this.mediaFileLength;
    }

    public MRFModule getModuleByIndex(short moduleIndex) {
        return this.moduleByIndex.get(new Short(moduleIndex));
    }

    public MRFModule getModuleByName(String moduleName) {
        return this.moduleByName.get(moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataOutputStream getOutputStream() throws FileNotFoundException {
        MRFile mRFile = this;
        synchronized (mRFile) {
            if (this.mediaOutputStream == null && this.mediaFile != null) {
                if (this.mediaFile.isDirectory()) {
                    this.mediaFile.delete();
                }
                this.mediaFile.getParentFile().mkdirs();
                this.mediaOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.mediaFile)));
                try {
                    this.mediaOutputStream.write(FOURCC);
                    this.firstWrite = true;
                }
                catch (IOException ex) {
                    throw new FileNotFoundException(this.mediaFile.getPath() + ex.getMessage());
                }
            } else if (this.mediaInputStream != null) {
                throw new RuntimeException("Write to read-only MRF file.");
            }
        }
        return this.mediaOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRFPacket getPacket() throws IOException {
        MRFPacket packet;
        MRFile mRFile = this;
        synchronized (mRFile) {
            packet = MRFPacket.readPacket(this);
            if (packet instanceof TimedPacket) {
                long time = ((TimedPacket)((Object)packet)).getTime();
                if (time < 0L) {
                    this.lastPacketTime = 0L;
                    ((TimedPacket)((Object)packet)).setTime(this.lastPacketTime);
                } else {
                    this.lastPacketTime = time;
                }
            }
            if (packet instanceof MRFHeader) {
                this.header = (MRFHeader)packet;
            } else if (packet instanceof MRFModule) {
                this.receiveModule((MRFModule)packet);
            } else if (packet instanceof MRFFeed) {
                this.receiveFeed((MRFFeed)packet);
            } else if (packet instanceof MRFShow) {
                this.receiveShow((MRFShow)packet);
            } else if (packet instanceof MRFClient) {
                this.receiveClient((MRFClient)packet);
            } else if (packet instanceof MRFGroup) {
                this.receiveGroup((MRFGroup)packet);
            } else if (packet instanceof MRFSessionName) {
                MRFSessionName pkt = (MRFSessionName)packet;
                if (this.header == null) {
                    this.header = new MRFHeader(pkt.getSessionName(), pkt.getTime(), this.forcedOutputSize.width, this.forcedOutputSize.height);
                } else {
                    this.header.setRecordingName(pkt.getSessionName());
                    this.header.setTime(pkt.getTime());
                }
            }
        }
        return packet;
    }

    public String getPath() {
        return this.mediaFile.getPath();
    }

    public Iterator groupIterator() {
        return this.groupByName.values().iterator();
    }

    public void incrementFileOffset(int bytesRead) {
        this.fileOffset += (long)bytesRead;
    }

    public boolean isClosed() {
        return this.mediaFile == null;
    }

    public boolean isReadable() {
        return this.mediaOutputStream == null;
    }

    public boolean isWriteable() {
        return this.mediaInputStream == null;
    }

    public Iterator moduleIterator() {
        return this.moduleByName.values().iterator();
    }

    public void receiveClient(MRFClient client) {
        Short clientAddress = new Short(client.getClientAddress());
        if (!this.clientByAddress.containsKey(clientAddress)) {
            this.clientByAddress.put(clientAddress, client);
            this.clientByName.put(client.getClientName(), client);
        } else {
            MRFClient c = this.clientByAddress.get(clientAddress);
            c.setOnline(client.isOnline());
            c.setTime(client.getTime());
        }
    }

    public void receiveGroup(MRFGroup group) {
        Short groupId = new Short(group.getGroupId());
        if (!this.groupById.containsKey(groupId)) {
            this.groupById.put(groupId, group);
            this.groupByName.put(group.getGroupName(), group);
        } else {
            MRFGroup g = this.groupById.get(groupId);
            g.setGroupId(group.getGroupId());
            g.setGroupName(group.getGroupName());
            g.setPrevGroupId(group.getPrevGroupId());
            g.setPrevGroupName(group.getPrevGroupName());
            g.setTime(group.getTime());
        }
    }

    public void processFile() throws IOException {
        MRFPacket packet;
        while ((packet = this.processPacket()) != null) {
        }
    }

    public MRFPacket processPacket() throws IOException {
        MRFPacket packet = this.getPacket();
        if (packet != null) {
            this.firePacketListeners(packet);
        }
        return packet;
    }

    private void receiveFeed(MRFFeed packet) {
        String feedName = packet.getFeedName();
        if (!this.feedByName.containsKey(feedName)) {
            this.feedByName.put(feedName, packet);
            this.feedByIndex.put(new Short(packet.getFeedIdx()), packet);
        }
    }

    private void receiveModule(MRFModule packet) {
        String moduleName = packet.getModuleName();
        if (!this.moduleByName.containsKey(moduleName)) {
            this.moduleByName.put(moduleName, packet);
            this.moduleByIndex.put(new Short(packet.getModuleIdx()), packet);
        }
    }

    private void receiveShow(MRFShow packet) {
        Short feedIdx = new Short(packet.getFeedIdx());
        MRFFeed feed = this.feedByIndex.get(feedIdx);
        feed.setVisible(packet.isVisible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketListener l) {
        ArrayList<PacketListener> arrayList = this.packetListeners;
        synchronized (arrayList) {
            this.packetListeners.remove(l);
        }
    }

    public void resetOffset() {
        this.fileOffset = 0L;
    }

    public void setHeader(MRFHeader header) {
        this.header = header;
    }

    private void setMediaFile(File mediaFile) {
        this.mediaFile = mediaFile;
        this.mediaFileLength = mediaFile.length();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MRFile: ");
        if (this.mediaFile != null) {
            buf.append(this.mediaFile.getPath());
        }
        buf.append("\n  ");
        buf.append(this.header.toString());
        buf.append("\n  in: " + (this.mediaInputStream != null) + ", out: " + (this.mediaOutputStream != null) + "\n");
        buf.append("\n  Modules (" + this.moduleByName.size() + "):\n");
        Iterator<String> iter = this.moduleByName.keySet().iterator();
        while (iter.hasNext()) {
            buf.append("  " + iter.next() + "\n");
        }
        buf.append("\n  Feeds (" + this.feedByName.size() + "):\n");
        iter = this.feedByName.keySet().iterator();
        while (iter.hasNext()) {
            buf.append("  " + iter.next() + "\n");
        }
        return buf.toString();
    }

    public void writePacket(MRFPacket packet) throws IOException {
        long time;
        if (packet instanceof MRFFeed) {
            this.receiveFeed((MRFFeed)packet);
        } else if (packet instanceof MRFModule) {
            this.receiveModule((MRFModule)packet);
        }
        if (this.firstWrite) {
            this.firstWrite = false;
            this.writePacket(this.header);
        }
        if (packet instanceof MRFHeader) {
            this.header = (MRFHeader)packet;
            this.header.writePacket(this);
        }
        packet.writePacket(this);
        if (packet instanceof TimedPacket && (time = ((TimedPacket)((Object)packet)).getTime()) > this.lastFlushTime + 1000L) {
            this.mediaOutputStream.flush();
            this.lastFlushTime = time;
        }
    }
}

