/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFSessionName
extends MRFPacket {
    private String name;
    private long time;

    public MRFSessionName(long time, String name) {
        super((byte)13);
        this.time = time;
        this.name = name;
    }

    public MRFSessionName(byte[] packetData) throws IOException {
        super((byte)13);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.time = istr.readLong();
        this.name = istr.readUTF();
    }

    public String getSessionName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeLong(this.time);
        if (this.name == null) {
            ostr.writeUTF("");
        } else {
            ostr.writeUTF(this.name);
        }
        return bostr.toByteArray();
    }

    @Override
    public String toString() {
        return "MRFSessionName: " + this.name + ", time: " + MRFSessionName.decodeTime(this.time);
    }
}

