/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFModule
extends MRFPacket {
    private static short MODULE_SEQUENCE = 0;
    private short moduleIdx;
    private String moduleName;

    public MRFModule(String moduleName) {
        super((byte)2);
        this.moduleName = moduleName;
        short s = MODULE_SEQUENCE;
        MODULE_SEQUENCE = (short)(s + 1);
        this.moduleIdx = s;
    }

    public MRFModule(byte[] packetData) throws IOException {
        super((byte)2);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.moduleIdx = istr.readShort();
        this.moduleName = istr.readUTF();
    }

    public short getModuleIdx() {
        return this.moduleIdx;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public static void reset() {
        MODULE_SEQUENCE = 0;
    }

    public void setModuleIdx(short moduleIdx) {
        this.moduleIdx = moduleIdx;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.moduleIdx);
        ostr.writeUTF(this.moduleName);
        return bostr.toByteArray();
    }

    @Override
    public String toString() {
        return "MRFModule: " + this.moduleName + ", idx: " + this.moduleIdx;
    }
}

