/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFIndexMark
extends MRFPacket
implements TimedPacket {
    private String detail;
    private String kind;
    private String modName;
    private long time;

    public MRFIndexMark(String modName, String kind, String detail, long time) {
        super((byte)14);
        this.modName = modName;
        this.kind = kind;
        this.detail = detail;
        this.time = time;
    }

    public MRFIndexMark(byte[] packetData) throws IOException {
        super((byte)14);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.time = istr.readLong();
        this.modName = istr.readUTF();
        this.kind = istr.readUTF();
        this.detail = istr.readUTF();
    }

    public String getDetail() {
        return this.detail;
    }

    public String getKind() {
        return this.kind;
    }

    public String getModName() {
        return this.modName;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setModName(String modName) {
        this.modName = modName;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeLong(this.time);
        ostr.writeUTF(this.modName);
        ostr.writeUTF(this.kind);
        if (this.detail == null) {
            ostr.writeUTF("");
        } else {
            ostr.writeUTF(this.detail);
        }
        return bostr.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MRFIndexMark: \"" + this.modName + "\", \"" + this.kind + "\", \"" + this.detail + "\", time: " + MRFIndexMark.decodeTime(this.time));
        return buf.toString();
    }
}

