/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.classroom.client.app.Application;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.classroom.moduleloading.LoadingStatus;
import com.elluminate.classroom.moduleloading.LoadingStatusListener;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.StartupFailedException;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.QuitQueryAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.player.PlayerDebug;
import com.elluminate.groupware.player.module.ChooseVCR;
import com.elluminate.groupware.player.module.DownloadErrorDialog;
import com.elluminate.groupware.player.module.FilteredIndexProvider;
import com.elluminate.groupware.player.module.IndexDialog;
import com.elluminate.groupware.player.module.PausePlaybackCmd;
import com.elluminate.groupware.player.module.PlaybackSliderModel;
import com.elluminate.groupware.player.module.PlayerIndexUtils;
import com.elluminate.groupware.player.module.PlayerModel;
import com.elluminate.groupware.player.module.PlayerStateChangeListener;
import com.elluminate.groupware.player.module.SliderView;
import com.elluminate.groupware.player.module.StartPlaybackCmd;
import com.elluminate.groupware.player.module.StopPlaybackCmd;
import com.elluminate.groupware.player.module.StringsProperties;
import com.elluminate.groupware.player.module.WaitingStatus;
import com.elluminate.groupware.player.module.WaitingStatusListenerImpl;
import com.elluminate.groupware.player.module.WaitingStatusModel;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ConferenceName;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.VCRFile;
import com.elluminate.jinx.client.PlaybackClient;
import com.elluminate.jinx.client.PlaybackEvent;
import com.elluminate.jinx.client.PlaybackListener;
import com.elluminate.jinx.provider.ConnectionProviderImpl;
import com.elluminate.util.ApplicationProperties;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.event.DataChangeEvent;
import com.elluminate.util.event.DataChangeListener;
import com.elluminate.util.event.URLFillErrorEvent;
import com.elluminate.util.event.URLFillErrorListener;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlayerModule
extends AbstractClientModule
implements URLFillErrorListener,
ModulePublisherInfo {
    private static final String PREF_CONFIRM_LEAVING = "com.elluminate.groupware.online.module.OnlineModule.confirmLeaving";
    public static final boolean SIMPLE_OBFUSCATE = true;
    private static final String CONTROLS_FEATURE_PATH = "/player/controls";
    private static final String SKIP_NEXT_FEATURE_PATH = "/player/skipNext";
    private static final String SKIP_PREV_FEATURE_PATH = "/player/skipPrev";
    private static final String SHOW_INDEX_FEATURE_PATH = "/player/showIndex";
    private static final String SLIDER_FEATURE_PATH = "/player/slider";
    private static final String NONLINEAR_FEATURE_PATH = "/player/nonlinear";
    private static final String PLAY_FEATURE_PATH = "/player/play";
    private static final String PAUSE_FEATURE_PATH = "/player/pause";
    private I18n i18n = null;
    private Imps imps = null;
    private PlayerModel model = null;
    private Logger log = null;
    private ConnectionProviderImpl connectionProvider = null;
    private FeatureBroker broker = null;
    private ConferencingEngine confEngine = null;
    private Provider<PausePlaybackCmd> pausePlaybackProvider = null;
    private Provider<StartPlaybackCmd> startPlaybackProvider = null;
    private Provider<StopPlaybackCmd> stopPlaybackProvider = null;
    private WaitingStatusModel waitingModel = null;
    private ApplicationProperties args = null;
    private Frame parent = null;
    private EnumeratedFeature<PlayerModel.STATE> controlsFeature = null;
    private ActionFeature skipNextFeature = null;
    private ActionFeature skipPreviousFeature = null;
    private ActionFeature showIndexFeature = null;
    private ComponentFeature sliderFeature = null;
    private BooleanFeature nonlinearFeature = null;
    private ActionFeature playFeature = null;
    private ActionFeature pauseFeature = null;
    private ActionFeatureListener skipPreviousListener = null;
    private ActionFeatureListener skipNextListener = null;
    private ActionFeatureListener showIndexListener = null;
    private MetaDataListener controlsChangeListener = null;
    private PlaybackSliderModel sliderModel;
    private URL url = null;
    private TimeAPI timeApi = new TimeAPI();
    private long lastSkipTime = 0L;
    private int lastSkipIndex = Integer.MIN_VALUE;
    private PlaybackClient client = null;
    private boolean playerArgSupplied = false;
    private boolean playOnce = false;
    private Provider<ChooseVCR> chooseVCRProvider = null;
    private PlayerIndexUtils indexUtils = null;
    private Provider<DownloadErrorDialog> errDialogProvider = null;
    private Provider<SliderView> sliderViewProvider = null;
    private SliderView slider = null;
    private volatile boolean suppressListener = false;
    private ConnectionListener connectionListener = null;
    private PlayerStateChangeListener stopListener = null;
    private PlayerStateChangeListener playingListener = null;
    private PlayerStateChangeListener pauseListener = null;
    private PlayerStateChangeListener ffwdListener = null;
    private PlayerStateChangeListener seekListener = null;
    private PlayerStateChangeListener skipEnableListener = null;
    private WaitingStatus waitingStatus = null;
    private Provider<IndexDialog> indexDialogProvider = null;
    private SwingRunner runner = null;
    private ContentCaptureProvider contentCaptureProvider;
    private Application application;
    private ListFeature<VCRFile.IndexEntry> listIndexFeature;
    private ActionFeature gotoIndexFeature;
    private ValueFeature<VCRFile.IndexEntry> selectedIndexFeature;
    private int lastIdx;
    private FilteredIndexProvider indexProvider = null;
    private boolean dontAskStatus = false;
    private Preferences preferences;
    private LoadingStatus loadingStatus;
    private PropertyChangeListener prefsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            PlayerModule.this.preferenceChange(e);
        }
    };
    LoadingStatusListener readyStateListener = new LoadingStatusListener(){

        public void onStatusChange(LoadingStatus statusSource, String entityName) {
            PlayerModule.this.startSession();
        }
    };

    @Inject
    public PlayerModule(ComponentRegistrar registrar) {
        registrar.registerComponent((Object)this);
    }

    @Inject
    public void initI18n(I18n loc) {
        this.i18n = loc;
    }

    @Inject
    public void initSwingRunner(SwingRunner r) {
        this.runner = r;
    }

    @Inject
    public void initPlayerModel(PlayerModel m) {
        this.model = m;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker fb) {
        this.broker = fb;
    }

    @Inject
    public void initDialogParentProvider(DialogParentProvider p) {
        this.parent = p.getDialogParent();
    }

    @Inject
    public void initApplicationProperties(ApplicationProperties args) {
        this.args = args;
    }

    @Inject
    public void initConnectionProvider(ConnectionProviderImpl cpi) {
        this.connectionProvider = cpi;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initConferenceEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initLogger(Logger log) {
        this.log = log;
    }

    @Inject
    public void initLoadingStatus(LoadingStatus loadingStatus) {
        this.loadingStatus = loadingStatus;
    }

    @Inject
    public void initWaitingStatusModel(WaitingStatusModel m) {
        this.waitingModel = m;
    }

    @Inject
    public void initIndexDialogProvider(Provider<IndexDialog> idp) {
        this.indexDialogProvider = idp;
    }

    @Inject
    public void initChooseVCRProvider(Provider<ChooseVCR> p) {
        this.chooseVCRProvider = p;
    }

    @Inject
    public void initPlayerIndexUtils(PlayerIndexUtils u) {
        this.indexUtils = u;
    }

    @Inject
    public void initDownloadErrorDialogProvider(Provider<DownloadErrorDialog> p) {
        this.errDialogProvider = p;
    }

    @Inject
    public void initSliderViewProvider(Provider<SliderView> p) {
        this.sliderViewProvider = p;
    }

    @Inject
    public void initSliderModel(PlaybackSliderModel m) {
        this.sliderModel = m;
    }

    @Inject
    public void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCaptureProvider = contentCaptureProvider;
    }

    @Inject
    public void initPlayerCommandProviders(Provider<PausePlaybackCmd> pausePlayback, Provider<StartPlaybackCmd> startPlayback, Provider<StopPlaybackCmd> stopPlayback) {
        this.pausePlaybackProvider = pausePlayback;
        this.startPlaybackProvider = startPlayback;
        this.stopPlaybackProvider = stopPlayback;
    }

    @Inject
    public void initApplication(Application application) {
        this.application = application;
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    public void start() {
        if (!this.checkArguments(this.args) && PlayerDebug.PLAYER.show()) {
            this.log.message("Not all information for the player was provided.  We will need to request this information.");
        }
        this.client = new PlaybackClient();
        this.connectionProvider.initConnection((Connection)this.client);
        this.imps.provideAPI(PlaybackTimeAPI.class, (ImpsAPI)this.timeApi);
        this.preferences.addSettingChangeListener(PREF_CONFIRM_LEAVING, this.prefsListener);
        boolean confirmLeavingPreference = this.preferences.getBooleanSetting(PREF_CONFIRM_LEAVING, Boolean.TRUE.booleanValue());
        this.dontAskStatus = !confirmLeavingPreference;
        this.setQuitQueryAPI();
    }

    public void attach() {
        this.registerCommands();
        this.registerConnectionListener();
    }

    private void registerConnectionListener() {
        this.connectionListener = new ConnectionListener(){

            public void connectionStatusChanged(ConnectionEvent event) throws JinxConnectionException {
                PlayerModule.this.handleConnectionStatusChanged(event);
            }
        };
        this.client.addConnectionListener(this.connectionListener);
    }

    private void registerCommands() {
        this.confEngine.registerCommand(this.pausePlaybackProvider);
        this.confEngine.registerCommand(this.startPlaybackProvider);
        this.confEngine.registerCommand(this.stopPlaybackProvider);
    }

    public void setupUI() {
        if (PlayerDebug.PLAYER.show()) {
            this.log.message("setupUI - player");
        }
        this.setupFeatures();
        this.initializeUIComponents();
        this.registerStopListener();
        this.registerPlayingListener();
        this.registerPauseListener();
        this.registerFfwdListener();
        this.registerSeekListener();
        this.registerSkipEnabledListener();
    }

    private void setupFeatures() {
        this.setupPlayFeature();
        this.setupPauseFeature();
        this.setupPlayControlsFeature();
        this.setupSkipPreviousFeature();
        this.setupSkipNextFeature();
        this.setupShowIndexFeature();
        this.setupSliderFeature();
        this.setupNonlinearFeature();
        this.setupScreenNavigation();
    }

    private void setupScreenNavigation() {
        ArrayList screens = new ArrayList();
        this.listIndexFeature = this.broker.createListFeature((Object)this, "/player/listIndexes", VCRFile.IndexEntry.class, screens, "listIndexes", null);
        this.gotoIndexFeature = this.broker.createActionFeature((Object)this, "/player/gotoIndex", "gotoIndex", "used by the screen list combo box");
        this.gotoIndexFeature.addActionFeatureListener(this.createGotoListener());
        this.selectedIndexFeature = this.broker.createValueFeature((Object)this, "/player/selectedIndex", false, (Object)new VCRFile.IndexEntry(), "selectedIndex", "used by screen list combo box");
        this.sliderModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean playing;
                boolean bl = playing = !PlayerModule.this.model.inState(PlayerModel.STATE.STOPPED);
                if (playing) {
                    VCRFile.IndexEntry[] index = PlayerModule.this.indexUtils.getFilteredIndex();
                    long curTime = PlayerModule.this.sliderModel.getPlayingTime();
                    int curIdx = PlayerModule.this.indexUtils.findClosest(index, curTime, PlayerModule.this.sliderModel.getDuration());
                    if (curIdx >= 0 && curIdx < index.length && curIdx != PlayerModule.this.lastIdx) {
                        long dt = (Math.abs(curTime - index[curIdx].getTime()) + 500L) / 1000L;
                        if (PlayerModule.this.contentCaptureProvider != null && PlayerModule.this.contentCaptureProvider.get().isEchoingData() && dt < 60L) {
                            PlayerModule.this.suppressListener = true;
                            PlayerModule.this.selectedIndexFeature.setValue((Object)index[curIdx]);
                            PlayerModule.this.suppressListener = false;
                        }
                        PlayerModule.this.lastIdx = curIdx;
                    }
                }
            }
        });
    }

    private ActionFeatureListener createGotoListener() {
        return new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (PlayerModule.this.suppressListener) {
                    return;
                }
                VCRFile.IndexEntry entry = (VCRFile.IndexEntry)event.getUserData();
                PlayerModule.this.sliderModel.setDesiredTime(entry.getTime());
                PlayerModule.this.suppressListener = true;
                PlayerModule.this.selectedIndexFeature.setValue((Object)entry);
                PlayerModule.this.suppressListener = false;
            }
        };
    }

    private void setupSliderFeature() {
        this.slider = (SliderView)this.sliderViewProvider.get();
        this.slider.setupSlider();
        this.sliderFeature = this.broker.createComponentFeature((Object)this, SLIDER_FEATURE_PATH, (ComponentProvider)this.slider, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SLIDERTIP), this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SLIDERTIP));
        this.sliderFeature.setEnabled(true);
    }

    private void setupSkipPreviousFeature() {
        this.skipPreviousFeature = this.broker.createActionFeature((Object)this, SKIP_PREV_FEATURE_PATH, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPPREVMENU), this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPPREVMENU));
        this.skipPreviousFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPPREVTIP));
        this.skipPreviousFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPPREVICON));
        this.skipPreviousFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPPREVMENU));
        this.skipPreviousFeature.setEnabled(true);
        this.setupSkipPreviousListener();
        this.skipPreviousFeature.addActionFeatureListener(this.skipPreviousListener);
        this.broker.addFeature((Feature)this.skipPreviousFeature);
    }

    private void setupSkipPreviousListener() {
        this.skipPreviousListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PlayerModule.this.skipBack();
            }
        };
    }

    private void setupPauseFeature() {
        this.pauseFeature = this.broker.createActionFeature((Object)this, PAUSE_FEATURE_PATH, "", this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSETIP));
        this.pauseFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSETIP));
        this.pauseFeature.setEnabled(false);
        this.pauseFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSEICON));
        this.pauseFeature.setRolloverIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSEICON_ROLLOVER));
        this.pauseFeature.setPressedIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSEICON_PRESSED));
        this.pauseFeature.setDisabledIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSEICON_DISABLED));
        this.pauseFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PlayerModule.this.setPaused();
            }
        });
    }

    private void setupPlayFeature() {
        this.playFeature = this.broker.createActionFeature((Object)this, PLAY_FEATURE_PATH, "", this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYTIP));
        this.playFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYTIP));
        this.playFeature.setEnabled(false);
        this.playFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYICON));
        this.playFeature.setRolloverIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYICON_ROLLOVER));
        this.playFeature.setPressedIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYICON_PRESSED));
        this.playFeature.setDisabledIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYICON_DISABLED));
        this.playFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PlayerModule.this.setPlaying();
            }
        });
    }

    private void setupShowIndexFeature() {
        this.showIndexFeature = this.broker.createActionFeature((Object)this, SHOW_INDEX_FEATURE_PATH, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SHOWINDEXMENU), this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SHOWINDEXMENU));
        this.showIndexFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SHOWINDEXMENU));
        this.showIndexFeature.setEnabled(true);
        this.setupShowIndexListener();
        this.showIndexFeature.addActionFeatureListener(this.showIndexListener);
        this.broker.addFeature((Feature)this.showIndexFeature);
    }

    private void setupNonlinearFeature() {
        this.nonlinearFeature = this.broker.createBooleanFeature((Object)this, NONLINEAR_FEATURE_PATH, false, false, "nonlinear", null);
        this.broker.addFeature((Feature)this.nonlinearFeature);
    }

    private void setupShowIndexListener() {
        this.showIndexListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PlayerModule.this.handleShowIndexAction();
            }
        };
    }

    private void handleShowIndexAction() {
        this.runner.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PlayerModule.this.indexDialogProvider != null) {
                    IndexDialog indexDialog = (IndexDialog)PlayerModule.this.indexDialogProvider.get();
                    indexDialog.pack();
                    indexDialog.show();
                }
            }
        });
    }

    private void setupSkipNextFeature() {
        this.skipNextFeature = this.broker.createActionFeature((Object)this, SKIP_NEXT_FEATURE_PATH, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPNEXTMENU), this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPNEXTMENU));
        this.skipNextFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPNEXTTIP));
        this.skipNextFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPNEXTICON));
        this.skipNextFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_SKIPNEXTMENU));
        this.skipNextFeature.setEnabled(true);
        this.setupSkipNextListener();
        this.skipNextFeature.addActionFeatureListener(this.skipNextListener);
        this.broker.addFeature((Feature)this.skipNextFeature);
    }

    private void setupSkipNextListener() {
        this.skipNextListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PlayerModule.this.skipAhead();
            }
        };
    }

    private void setupPlayControlsFeature() {
        PlayerModel.STATE[] displayedStates = new PlayerModel.STATE[]{PlayerModel.STATE.STOPPED, PlayerModel.STATE.PAUSED, PlayerModel.STATE.PLAYING, PlayerModel.STATE.FAST_FWD};
        this.controlsFeature = this.broker.createEnumeratedFeature((Object)this, CONTROLS_FEATURE_PATH, PlayerModel.STATE.class, true, (Object)PlayerModel.STATE.STOPPED, (Object[])displayedStates, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_TITLE));
        this.controlsFeature.setValueText((Object)PlayerModel.STATE.STOPPED, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_STOPMENU));
        this.controlsFeature.setValueIconImage((Object)PlayerModel.STATE.STOPPED, this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_STOPICON));
        this.controlsFeature.setValueText((Object)PlayerModel.STATE.PLAYING, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYMENU));
        this.controlsFeature.setValueIconImage((Object)PlayerModel.STATE.PLAYING, this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYICON));
        this.controlsFeature.setValueText((Object)PlayerModel.STATE.FAST_FWD, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_FASTMENU));
        this.controlsFeature.setValueIconImage((Object)PlayerModel.STATE.FAST_FWD, this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_FASTICON));
        this.controlsFeature.setValueText((Object)PlayerModel.STATE.PAUSED, this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSEMENU));
        this.controlsFeature.setValueIconImage((Object)PlayerModel.STATE.PAUSED, this.i18n.getImage((PropertiesEnum)StringsProperties.PLAYERMODULE_PAUSEICON));
        this.setupControlsChangeListener();
        this.controlsFeature.addValueChangeListener(this.controlsChangeListener);
        this.broker.addFeature(this.controlsFeature);
        this.controlsFeature.setEnabled(true);
        this.broker.setFeaturePublished(this.controlsFeature, true);
    }

    private void setupControlsChangeListener() {
        this.controlsChangeListener = new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                PlayerModule.this.handleControlsChange(ev);
            }
        };
    }

    protected void handleControlsChange(MetaDataEvent ev) {
        this.model.setState((PlayerModel.STATE)((Object)ev.getNewValue()));
    }

    public void sessionStart() {
        if (PlayerDebug.PLAYER.show()) {
            this.log.message("sessionStart - player");
        }
        this.startSession();
    }

    private void registerSkipEnabledListener() {
        this.skipEnableListener = new PlayerStateChangeListener(){

            @Override
            public void playerStateChanged(PlayerModel.STATE oldState, PlayerModel.STATE newState) {
                PlayerModule.this.enableSkipAheadUI(newState != PlayerModel.STATE.STOPPED);
                PlayerModule.this.enableSkipBackUI(newState != PlayerModel.STATE.STOPPED);
            }
        };
        this.model.addPlayerStateChangeListener(this.skipEnableListener);
    }

    private void registerSeekListener() {
        this.seekListener = new PlayerStateChangeListener(){

            @Override
            public void playerStateChanged(PlayerModel.STATE oldState, PlayerModel.STATE newState) {
                if (newState == PlayerModel.STATE.SEEKING) {
                    PlayerModule.this.enablePauseUI(false);
                    PlayerModule.this.enablePlayUI(false);
                    PlayerModule.this.runSeekActions();
                }
            }
        };
        this.model.addPlayerStateChangeListener(this.seekListener);
    }

    private void runSeekActions() {
        if (this.client != null) {
            if (PlayerDebug.PLAYER.show()) {
                this.log.message("player - play");
            }
            this.client.play();
            this.setRate(10000.0f);
        }
    }

    private void registerFfwdListener() {
        this.ffwdListener = new PlayerStateChangeListener(){

            @Override
            public void playerStateChanged(PlayerModel.STATE oldState, PlayerModel.STATE newState) {
                if (newState == PlayerModel.STATE.FAST_FWD) {
                    PlayerModule.this.enablePauseUI(false);
                    PlayerModule.this.enablePlayUI(false);
                    PlayerModule.this.updateControlsUI(newState);
                    PlayerModule.this.runFfwdActions();
                }
            }
        };
        this.model.addPlayerStateChangeListener(this.ffwdListener);
    }

    private void runFfwdActions() {
        if (this.client != null) {
            if (PlayerDebug.PLAYER.show()) {
                this.log.message("player - FFW");
            }
            this.client.play();
            this.setRate(8.0f);
        }
    }

    private void registerPauseListener() {
        this.pauseListener = new PlayerStateChangeListener(){

            @Override
            public void playerStateChanged(PlayerModel.STATE oldState, PlayerModel.STATE newState) {
                if (newState == PlayerModel.STATE.PAUSED) {
                    PlayerModule.this.publishPlayable();
                    PlayerModule.this.runPauseActions();
                    PlayerModule.this.updateControlsUI(newState);
                }
            }
        };
        this.model.addPlayerStateChangeListener(this.pauseListener);
    }

    private void runPauseActions() {
        if (this.client != null) {
            if (PlayerDebug.PLAYER.show()) {
                this.log.message("player - Pause");
            }
            this.client.pause();
            this.setRate(1.0f);
        }
    }

    private void registerPlayingListener() {
        this.playingListener = new PlayerStateChangeListener(){

            @Override
            public void playerStateChanged(PlayerModel.STATE oldState, PlayerModel.STATE newState) {
                if (newState == PlayerModel.STATE.PLAYING) {
                    PlayerModule.this.publishPausable();
                    PlayerModule.this.runPlayingActions();
                    PlayerModule.this.updateControlsUI(newState);
                }
            }
        };
        this.model.addPlayerStateChangeListener(this.playingListener);
    }

    private void runPlayingActions() {
        if (this.client != null) {
            if (this.model.getPreviousState() == PlayerModel.STATE.SEEKING) {
                if (PlayerDebug.PLAYER.show()) {
                    this.log.message("player - play - was seeking");
                }
                this.client.pause();
            }
            this.setRate(1.0f);
            this.client.play();
        }
    }

    private void registerStopListener() {
        this.stopListener = new PlayerStateChangeListener(){

            @Override
            public void playerStateChanged(PlayerModel.STATE oldState, PlayerModel.STATE newState) {
                if (newState == PlayerModel.STATE.STOPPED) {
                    PlayerModule.this.publishPlayable();
                    PlayerModule.this.runStopActions();
                    PlayerModule.this.updateControlsUI(newState);
                    PlayerModule.this.broker.setFeaturePublished((Feature)PlayerModule.this.pauseFeature, false);
                    PlayerModule.this.broker.setFeaturePublished((Feature)PlayerModule.this.playFeature, true);
                    PlayerModule.this.loadingStatus.decrement("playerstopped");
                }
            }
        };
        this.model.addPlayerStateChangeListener(this.stopListener);
    }

    private void runStopActions() {
        this.timeApi.reset();
        if (this.client != null) {
            if (PlayerDebug.PLAYER.show()) {
                this.log.message("player - stop");
            }
            this.client.stop();
            this.setRate(1.0f);
        }
        this.sliderModel.setDesiredTime(0L);
    }

    private void setRate(float rate) {
        boolean nonlinear = rate > 1.0f;
        this.nonlinearFeature.setValue((Object)nonlinear);
        this.client.setRate(rate);
        this.timeApi.setRate(rate);
    }

    public void updateControlsUI(PlayerModel.STATE newState) {
        this.controlsFeature.setValue((Object)newState);
    }

    private void enableSkipAheadUI(boolean b) {
        this.skipNextFeature.setEnabled(b);
        this.broker.setFeaturePublished((Feature)this.skipNextFeature, b);
    }

    private void enableSkipBackUI(boolean b) {
        this.skipPreviousFeature.setEnabled(b);
        this.broker.setFeaturePublished((Feature)this.skipPreviousFeature, b);
    }

    private void enableIndexUI(boolean b) {
        this.showIndexFeature.setEnabled(b);
        this.broker.setFeaturePublished((Feature)this.showIndexFeature, b);
    }

    private void enablePlayUI(boolean b) {
        this.playFeature.setEnabled(b);
    }

    private void enablePauseUI(boolean b) {
        this.pauseFeature.setEnabled(b);
    }

    public void sessionStop() {
        if (this.client == null) {
            return;
        }
        this.model.setState(PlayerModel.STATE.STOPPED, "stopSession");
    }

    public void cleanupUI() {
    }

    public void detach() {
        if (this.client != null) {
            if (PlayerDebug.PLAYER.show()) {
                this.log.message("player - removeConnectionListener");
            }
            this.client.removeConnectionListener(this.connectionListener);
        }
    }

    public void stop() {
        this.imps.revokeAPI(PlaybackTimeAPI.class, (ImpsAPI)this.timeApi);
        if (this.client != null) {
            WorkerThread t = new WorkerThread("Playback Disposal"){

                public void run() {
                    if (PlayerModule.this.client != null) {
                        if (PlayerDebug.PLAYER.show()) {
                            PlayerModule.this.log.message("player - dispose");
                        }
                        PlayerModule.this.client.dispose();
                    }
                    PlayerModule.this.client = null;
                }
            };
            t.start();
        }
        this.client = null;
    }

    private void initializeUIComponents() {
        this.setControlsEnabled(false);
        PlayerDebug.OBFUSCATE_NAMES.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (PlayerDebug.OBFUSCATE_NAMES.show() && PlayerModule.this.client != null) {
                    PlayerModule.this.client.setObfuscatingNames();
                    ClientInfo.setObfuscator((ClientInfo.Obfuscator)new NameToRole());
                }
            }
        });
    }

    private void setControlsEnabled(boolean enable) {
        this.enableSkipBackUI(enable);
        this.enableSkipAheadUI(enable);
        this.enableIndexUI(enable);
        this.enablePlayUI(enable);
        this.enablePauseUI(enable);
    }

    public boolean isConfigured() {
        return this.client != null;
    }

    public Object getCurrentState() {
        StringBuilder result = new StringBuilder();
        result.append("state=" + this.model.getCurrentState().name());
        if (this.sliderModel != null) {
            result.append(" duration=" + this.sliderModel.getDuration());
            result.append(" buffered=" + this.sliderModel.getBufferedTime());
            result.append(" playing=" + this.sliderModel.getPlayingTime());
            result.append(" target=" + this.sliderModel.getDesiredTime());
            if (this.sliderModel.isAdjusting()) {
                result.append(" adjusting");
            }
            if (this.sliderModel.isSynchronized()) {
                result.append(" synchronized");
            }
        }
        return result.toString();
    }

    private boolean checkArguments(ApplicationProperties args) {
        List values = null;
        String urlString = null;
        if (args.containsKey(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYARG))) {
            this.playOnce = false;
            values = args.get(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYARG));
        } else if (args.containsKey(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYONCEARG))) {
            this.playOnce = true;
            values = args.get(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PLAYONCEARG));
        } else {
            return false;
        }
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_PARTIALPLAYARG));
        }
        try {
            urlString = (String)values.get(0);
            File file = new File(urlString);
            this.url = file.isFile() ? file.toURI().toURL() : new URL(urlString);
            return true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_BADPLAYARG, new Object[]{urlString, e.getMessage()}));
        }
    }

    public void startSession() {
        if (!this.loadingStatus.addListener(this.readyStateListener)) {
            return;
        }
        this.loadingStatus.removeListener(this.readyStateListener);
        while (this.url == null) {
            this.getVCRUrlToLoad();
        }
        if (PlayerDebug.PLAYER.show()) {
            this.log.message("[player] url is: " + this.url);
        }
        this.waitingStatus = new WaitingStatus(this.parent, this.url.getHost());
        this.waitingStatus.init();
        this.waitingModel.addWaitingStatusListener(new WaitingStatusListenerImpl(this.waitingStatus, this.contentCaptureProvider));
        this.client.addPlaybackListener((PlaybackListener)this.waitingModel);
        this.waitingModel.setWaiting(true);
        this.timeApi.setClient(this.client);
        WorkerThread t = new WorkerThread("Playback Startup Thread", 4){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ConferenceName nm;
                if (PlayerDebug.START_DELAY.show()) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException intx) {
                        // empty catch block
                    }
                }
                try {
                    if (PlayerDebug.PLAYER.show()) {
                        PlayerModule.this.log.message("player - playback startup thread - play URL");
                    }
                    PlayerModule.this.client.play(PlayerModule.this.url, (URLFillErrorListener)PlayerModule.this);
                }
                catch (Throwable t) {
                    PlayerModule.this.waitingModel.setWaiting(false);
                    ModalDialog.showMessageDialog((Component)PlayerModule.this.parent, (Object)PlayerModule.this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_CANTPLAYURL, new Object[]{PlayerModule.this.url, t.getMessage()}), (String)PlayerModule.this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_CANTPLAYTITLE), (int)0);
                    return;
                }
                if (PlayerDebug.OBFUSCATE_NAMES.show()) {
                    PlayerModule.this.client.setObfuscatingNames();
                }
                if (PlayerModule.this.client.isObfuscatingNames()) {
                    ClientInfo.setObfuscator((ClientInfo.Obfuscator)new NameToRole());
                }
                if ((nm = PlayerModule.this.client.getConferenceName()) != null) {
                    // empty if block
                }
                PlayerModule playerModule = PlayerModule.this;
                synchronized (playerModule) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    PlayerModule.this.model.setState(PlayerModel.STATE.PLAYING, "startSession");
                }
                PlayerModule.this.setControlsEnabled(true);
                PlayerModule.this.indexProvider = PlayerModule.this.indexUtils.getFilterer();
                while (PlayerModule.this.indexProvider == null) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    PlayerModule.this.indexProvider = PlayerModule.this.indexUtils.getFilterer();
                }
                PlayerModule.this.indexProvider.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent ev) {
                        PlayerModule.this.updateIndex((ValueFeature<VCRFile.IndexEntry>)null);
                    }
                });
                PlayerModule.this.updateIndex((ValueFeature<VCRFile.IndexEntry>)PlayerModule.this.selectedIndexFeature);
                PlayerModule.this.slider.setIndexProvider(PlayerModule.this.indexProvider);
                PlayerModule.this.broker.setFeaturePublished((Feature)PlayerModule.this.gotoIndexFeature, true);
                PlayerModule.this.broker.setFeaturePublished((Feature)PlayerModule.this.listIndexFeature, true);
                PlayerModule.this.broker.setFeaturePublished((Feature)PlayerModule.this.selectedIndexFeature, true);
                PlayerModule.this.broker.setFeaturePublished((Feature)PlayerModule.this.sliderFeature, true);
            }
        };
        t.start();
    }

    private void updateIndex(ValueFeature<VCRFile.IndexEntry> selected) {
        VCRFile.IndexEntry[] entry = this.indexUtils.getFilteredIndex();
        while (entry == null) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            entry = this.indexUtils.getFilteredIndex();
        }
        ArrayList<VCRFile.IndexEntry> screens = new ArrayList<VCRFile.IndexEntry>();
        for (VCRFile.IndexEntry e : entry) {
            screens.add(e);
        }
        if (selected != null) {
            selected.setValue((Object)((VCRFile.IndexEntry)screens.get(0)));
        }
        this.listIndexFeature.assign(screens);
    }

    private void getVCRUrlToLoad() {
        String urlString = null;
        if (!this.playerArgSupplied) {
            ChooseVCR dialog = (ChooseVCR)((Object)this.chooseVCRProvider.get());
            dialog.show();
            urlString = dialog.getURL();
            if (urlString != null && new File(urlString).isFile()) {
                urlString = "file:///" + urlString;
            }
        }
        if (urlString == null) {
            throw new StartupFailedException(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_NOURL), this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_CANTPLAYTITLE));
        }
        String msg = this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_NOURL);
        if (urlString.length() > 0) {
            try {
                this.url = new URL(urlString);
            }
            catch (Exception ex) {
                urlString = "";
                msg = ex.getMessage();
            }
        }
        if (urlString.length() == 0) {
            ModalDialog.showMessageDialog((Component)this.parent, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_INVALIDURL, new Object[]{urlString, msg}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_CANTPLAYTITLE), (int)0);
            this.url = null;
        }
    }

    public void fillError(URLFillErrorEvent ev) {
        boolean paused = false;
        if (this.model.inState(PlayerModel.STATE.PLAYING)) {
            paused = true;
            this.model.setState(PlayerModel.STATE.PAUSED, "fillError");
        }
        DownloadErrorDialog diag = (DownloadErrorDialog)this.errDialogProvider.get();
        diag.launch(ev);
        diag.displayAndWait();
        if (paused) {
            this.model.setState(PlayerModel.STATE.PLAYING, "fillError");
        }
    }

    private void skipAhead() {
        int ix;
        long now = System.currentTimeMillis();
        VCRFile.IndexEntry[] index = this.indexUtils.getFilteredIndex();
        if (now - this.lastSkipTime < 1000L) {
            ix = this.lastSkipIndex + 1;
            if (ix > index.length) {
                ix = index.length;
            }
        } else {
            ix = this.indexUtils.findSuccessor(index, this.sliderModel.getDesiredTime());
        }
        long target = ix < 0 ? 1L : (ix >= index.length ? this.sliderModel.getDuration() - 1L : index[ix].getTime() - 1L);
        this.sliderModel.setDesiredTime(target);
        this.lastSkipTime = now;
        this.lastSkipIndex = ix;
    }

    private void skipBack() {
        int ix;
        long now = System.currentTimeMillis();
        VCRFile.IndexEntry[] index = this.indexUtils.getFilteredIndex();
        if (now - this.lastSkipTime < 1000L) {
            ix = this.lastSkipIndex - 1;
            if (ix < -1) {
                ix = -1;
            }
        } else {
            ix = this.indexUtils.findPredecessor(index, this.sliderModel.getDesiredTime());
        }
        long target = ix < 0 ? 1L : (ix >= index.length ? this.sliderModel.getDuration() - 1L : index[ix].getTime() - 1L);
        this.sliderModel.setDesiredTime(target);
        this.lastSkipTime = now;
        this.lastSkipIndex = ix;
    }

    void publishPlayable() {
        this.broker.setFeaturePublished((Feature)this.pauseFeature, false);
        this.broker.setFeaturePublished((Feature)this.playFeature, true);
        this.enablePauseUI(true);
        this.enablePlayUI(true);
    }

    void publishPausable() {
        this.broker.setFeaturePublished((Feature)this.pauseFeature, true);
        this.broker.setFeaturePublished((Feature)this.playFeature, false);
        this.enablePauseUI(true);
        this.enablePlayUI(true);
    }

    void setPlaying() {
        this.model.setState(PlayerModel.STATE.PLAYING, "setPlaying");
    }

    public boolean isPlaying() {
        return this.model.inState(PlayerModel.STATE.PLAYING);
    }

    void setStopped() {
        this.model.setState(PlayerModel.STATE.STOPPED, "setStopped");
    }

    public boolean isStopped() {
        return this.model.inState(PlayerModel.STATE.STOPPED);
    }

    void setPaused() {
        this.model.setState(PlayerModel.STATE.PAUSED, "setPaused");
    }

    public boolean isPaused() {
        return this.model.inState(PlayerModel.STATE.PAUSED);
    }

    private void handleConnectionStatusChanged(ConnectionEvent event) {
        if (event.getAction() == 4) {
            this.loadingStatus.increment("playerstopped");
            this.model.setState(PlayerModel.STATE.STOPPED, "handleConnectionsStatusChanged");
            if (this.playOnce) {
                if (this.loadingStatus.isReady()) {
                    this.application.doShutdown();
                } else {
                    this.loadingStatus.addListener(new LoadingStatusListener(){

                        public void onStatusChange(LoadingStatus statusSource, String entityName) {
                            PlayerModule.this.loadingStatus.removeListener((LoadingStatusListener)this);
                            PlayerModule.this.application.doShutdown();
                        }
                    });
                }
            }
        }
    }

    public String getNameOfModule() {
        return "Player";
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return null;
    }

    private void preferenceChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals(PREF_CONFIRM_LEAVING)) {
            boolean confirmLeavingPreference = Preferences.booleanValue((Object)e.getNewValue(), (boolean)Boolean.TRUE);
            this.dontAskStatus = !confirmLeavingPreference;
        }
    }

    private boolean userOkaysLeavingConnection() {
        if (this.dontAskStatus) {
            return true;
        }
        BorderLayout layout = new BorderLayout();
        JPanel panel = new JPanel(layout);
        JCheckBox dontAskAgainCheckBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_DONTASKMETHISAGAIN));
        dontAskAgainCheckBox.setSelected(this.dontAskStatus);
        panel.add((Component)dontAskAgainCheckBox, "South");
        dontAskAgainCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlayerModule.this.dontAskStatus = true;
                PlayerModule.this.preferences.setSetting(PlayerModule.PREF_CONFIRM_LEAVING, false);
            }
        });
        JLabel content = new JLabel();
        content.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_LEAVECONFIRMQUERY));
        content.setBackground(UIManager.getColor("Label.background"));
        content.setFocusable(false);
        content.setBorder(BorderFactory.createEmptyBorder(12, 6, 12, 64));
        panel.add((Component)content, "Center");
        int answer = ModalDialog.showConfirmDialog((Component)this.parent, (Object)panel, (String)this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_LEAVECONFIRMTITLE), (int)2, (int)3);
        return answer == 0;
    }

    private void setQuitQueryAPI() {
        QuitQueryAPI quitQueryAPI = new QuitQueryAPI(){

            public String getProvider() {
                return PlayerModule.this.getNameOfModule();
            }

            public byte getTier() {
                return 32;
            }

            public boolean canQuit() {
                return PlayerModule.this.userOkaysLeavingConnection();
            }
        };
        this.imps.provideAPI(QuitQueryAPI.class, (ImpsAPI)quitQueryAPI);
    }

    private class NameToRole
    implements ClientInfo.Obfuscator {
        private Map<ClientInfo, String> nameCache = new HashMap<ClientInfo, String>();
        private Map<String, Integer> counters = new HashMap<String, Integer>();

        private NameToRole() {
        }

        public String obfuscate(ClientInfo info, String displayName) {
            String base = this.lookup(info);
            return base + "#" + info.getAddress();
        }

        private String lookup(ClientInfo info) {
            boolean isChair = false;
            ClientList clients = null;
            if (PlayerModule.this.client != null) {
                clients = PlayerModule.this.client.getClientList();
                ClientInfo ci = clients.get(info.getAddress());
                boolean bl = isChair = ci == null ? false : ci.getProperty("chair.role", false);
            }
            if (isChair) {
                // empty if block
            }
            return LabelProps.get((PropertyAccessAPI)clients, (String)"Label.Participant");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetObfuscator() {
            Map<ClientInfo, String> map = this.nameCache;
            synchronized (map) {
                this.counters.clear();
                this.nameCache.clear();
            }
        }
    }

    class TimeAPI
    implements PlaybackTimeAPI {
        private HashSet<Object> requestors = new HashSet();
        private Set<PlaybackTimeListener> listeners = new HashSet<PlaybackTimeListener>();
        private Object lock = new Object();

        TimeAPI() {
        }

        public boolean addDataChangeListener(DataChangeListener l) {
            if (PlayerModule.this.client != null && PlayerModule.this.client.getRecordingIndexProvider() != null) {
                PlayerModule.this.client.getRecordingIndexProvider().addDataChangeListener(l);
                return true;
            }
            return false;
        }

        public void removeDataChangeListener(DataChangeListener l) {
            if (PlayerModule.this.client != null && PlayerModule.this.client.getRecordingIndexProvider() != null) {
                PlayerModule.this.client.getRecordingIndexProvider().removeDataChangeListener(l);
            }
        }

        public byte getTier() {
            return 32;
        }

        public String getProvider() {
            return PlayerModule.this.i18n.getString((PropertiesEnum)StringsProperties.PLAYERMODULE_TIMEAPI_PROVIDERPLAYER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendTimeCompression(Object obj) {
            PlaybackClient pbc;
            boolean susp = false;
            TimeAPI timeAPI = this;
            synchronized (timeAPI) {
                susp = this.requestors.isEmpty();
                if (!this.requestors.contains(obj)) {
                    this.requestors.add(obj);
                }
            }
            if (susp && (pbc = PlayerModule.this.client) != null) {
                pbc.setCompressionEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeTimeCompression(Object obj) {
            PlaybackClient pbc;
            boolean res = false;
            TimeAPI timeAPI = this;
            synchronized (timeAPI) {
                res = this.requestors.remove(obj);
                res = res && this.requestors.isEmpty();
            }
            if (res && (pbc = PlayerModule.this.client) != null) {
                pbc.setCompressionEnabled(true);
            }
        }

        public long getPlayingTime() {
            return PlayerModule.this.sliderModel.getPlayingTime();
        }

        public long getDuration() {
            return PlayerModule.this.sliderModel.getDuration();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPlaybackTimeListener(PlaybackTimeListener lst) {
            Object object = this.lock;
            synchronized (object) {
                HashSet<PlaybackTimeListener> copy = new HashSet<PlaybackTimeListener>(this.listeners);
                if (copy.add(lst)) {
                    this.listeners = copy;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePlaybackTimeListener(PlaybackTimeListener lst) {
            Object object = this.lock;
            synchronized (object) {
                HashSet<PlaybackTimeListener> copy = new HashSet<PlaybackTimeListener>(this.listeners);
                if (copy.remove(lst)) {
                    this.listeners = copy;
                }
            }
        }

        void setClient(PlaybackClient client) {
            client.addPlaybackListener(new PlaybackListener(){

                public void playbackStatus(PlaybackEvent e) {
                    if (e.isResetting()) {
                        for (PlaybackTimeListener lst : TimeAPI.this.listeners) {
                            try {
                                lst.resetSession();
                            }
                            catch (Throwable t) {
                                LogSupport.exception((Object)this, (String)"playbackStatus", (Throwable)t, (boolean)true);
                            }
                        }
                    }
                }
            });
        }

        void setRate(float speed) {
            PlaybackTimeListener.Linearity linearity = speed > 9.0f ? PlaybackTimeListener.Linearity.SEEKING : (speed > 1.1f ? PlaybackTimeListener.Linearity.FAST_FORWARD : PlaybackTimeListener.Linearity.REALTIME);
            for (PlaybackTimeListener lst : this.listeners) {
                try {
                    lst.setLinearity(linearity);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"SetNonLinear", (Throwable)t, (boolean)true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            TimeAPI timeAPI = this;
            synchronized (timeAPI) {
                this.requestors.clear();
            }
            PlaybackClient pbc = PlayerModule.this.client;
            if (pbc != null) {
                pbc.setCompressionEnabled(true);
            }
        }
    }
}

