/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.module.IndexFilter;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.event.DataChangeEvent;
import com.elluminate.util.event.DataChangeListener;
import com.elluminate.util.event.DataProvider;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.Iterator;

public class FilteredIndexProvider
implements DataProvider,
DataChangeListener {
    public static final int MATCH_ALL = 0;
    public static final int MATCH_ANY = 1;
    public static final int MATCH_OFF = 2;
    private DataProvider provider;
    private int matchMode = 0;
    private boolean dataInvalid = true;
    private ArrayList<VCRFile.IndexEntry> data = new ArrayList();
    private ArrayList<IndexFilter> filters = new ArrayList(16);
    private ArrayList<DataChangeListener> listeners = null;

    public FilteredIndexProvider(DataProvider baseProvider) {
        this.provider = baseProvider;
        this.provider.addDataChangeListener((DataChangeListener)this);
    }

    public DataProvider getProvider() {
        return this.provider;
    }

    public int getMatchMode() {
        return this.matchMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatchMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Invalid match mode: " + mode);
        }
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            if (this.matchMode == mode) {
                return;
            }
            this.matchMode = mode;
            this.dataInvalid = true;
        }
        this.fireDataChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilterCount() {
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            return this.filters.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(IndexFilter f) {
        if (f == null) {
            return;
        }
        boolean changed = false;
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            if (!this.filters.contains(f)) {
                this.filters.add(f);
                this.dataInvalid = true;
                changed = true;
            }
        }
        if (changed) {
            this.fireDataChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFilter(int idx, IndexFilter f) {
        if (f == null) {
            return;
        }
        boolean changed = false;
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            if (!this.filters.contains(f)) {
                this.filters.add(idx, f);
                this.dataInvalid = true;
                changed = true;
            } else if (!this.filters.get(idx).equals(f)) {
                this.filters.remove(f);
                this.filters.add(idx, f);
                this.dataInvalid = true;
                changed = true;
            }
        }
        if (changed) {
            this.fireDataChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(IndexFilter f) {
        if (f == null) {
            return;
        }
        boolean changed = false;
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            changed = this.filters.remove(f);
            this.dataInvalid |= changed;
        }
        if (changed) {
            this.fireDataChangeListeners();
        }
    }

    private void doFilter() {
        if (!this.dataInvalid) {
            return;
        }
        this.dataInvalid = false;
        this.data.clear();
        VCRFile.IndexEntry[] raw = (VCRFile.IndexEntry[])this.provider.getData();
        if (raw == null) {
            return;
        }
        this.data.ensureCapacity(raw.length);
        for (int ix = 0; ix < raw.length; ++ix) {
            boolean accepted = this.acceptIndexEntry(raw, ix);
            if (!accepted) continue;
            this.data.add(raw[ix]);
        }
    }

    private boolean acceptIndexEntry(VCRFile.IndexEntry[] entryList, int idx) {
        if (this.matchMode == 2) {
            return true;
        }
        if (this.filters.size() == 0) {
            return true;
        }
        Iterator<IndexFilter> it = this.filters.iterator();
        while (it.hasNext()) {
            boolean accepted = false;
            IndexFilter f = null;
            try {
                f = it.next();
                accepted = f.accept(entryList, idx);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"acceptIndexEntry", (Throwable)t, (boolean)true, (String)("Processing " + entryList[idx] + " with filter " + f));
                accepted = false;
            }
            if (this.matchMode == 1 && accepted) {
                return true;
            }
            if (this.matchMode != 0 || accepted) continue;
            return false;
        }
        return this.matchMode == 0;
    }

    public void dataChanged(DataChangeEvent ev) {
        this.invalidateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateData() {
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            this.dataInvalid = true;
        }
        this.fireDataChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData() {
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            if (this.dataInvalid) {
                this.doFilter();
            }
            return this.data.toArray(new VCRFile.IndexEntry[this.data.size()]);
        }
    }

    public Class<?> getType() {
        return this.provider.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataChangeListener(DataChangeListener l) {
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            if (this.listeners == null) {
                this.listeners = new ArrayList(1);
                this.listeners.add(l);
            } else if (!this.listeners.contains(l)) {
                ArrayList<DataChangeListener> doppleganger = new ArrayList<DataChangeListener>(this.listeners.size() + 1);
                doppleganger.addAll(this.listeners);
                doppleganger.add(l);
                this.listeners = doppleganger;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataChangeListener(DataChangeListener l) {
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            if (this.listeners != null && this.listeners.contains(l)) {
                ArrayList<DataChangeListener> doppleganger = new ArrayList<DataChangeListener>(this.listeners);
                doppleganger.remove(l);
                this.listeners = doppleganger;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataChangeListeners() {
        DataChangeEvent ev = null;
        Iterator<DataChangeListener> it = null;
        FilteredIndexProvider filteredIndexProvider = this;
        synchronized (filteredIndexProvider) {
            if (this.listeners != null) {
                it = this.listeners.iterator();
            }
        }
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            DataChangeListener l = null;
            try {
                l = it.next();
                if (l == null) continue;
                if (ev == null) {
                    ev = new DataChangeEvent((DataProvider)this);
                }
                l.dataChanged(ev);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireDataChangeListeners", (Throwable)t, (boolean)true, (String)("\n  listener=" + l + "\n  event=" + ev + "\n"));
            }
        }
    }
}

