/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.ParticipantGestureListener;
import com.elluminate.classroom.swing.location.GlobalPermissionsSupport;
import com.elluminate.classroom.swing.participant.ParticipantHeaderTransferHandler;
import com.elluminate.classroom.swing.participant.ParticipantList;
import com.elluminate.classroom.swing.participant.ParticipantListModel;
import com.elluminate.classroom.swing.participant.ParticipantListTransferHandler;
import com.elluminate.classroom.swing.participant.ProfilePopupClerk;
import com.elluminate.classroom.swing.participant.StringsProperties;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRAnnotationChangeListener;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.CRRoomListener;
import com.elluminate.framework.session.listener.event.CRAnnotationChangeEvent;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEventType;
import com.elluminate.framework.session.listener.event.CRRoomEvent;
import com.elluminate.groupware.imps.ParticipantSelectionAPI;
import com.elluminate.groupware.imps.ProfileDataAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ParticipantListPanel
extends JPanel {
    private JPanel header;
    private GlobalPermissionsSupport globalPermissionsSupport;
    private JLabel roomNameLabel;
    private JLabel participantCountLabel;
    private ParticipantList list;
    private CRSession session;
    private I18n i18n;
    private ParticipantHeaderTransferHandler headerTransferHandler;
    private ParticipantListTransferHandler listTransferHandler;
    private ParticipantSelectionAPI participantSelectionAPI;
    private int participantCount;
    private Imps imps = null;

    public ParticipantListPanel() {
        super(new BorderLayout());
        this.setBorder(UIManager.getBorder("SideBar.contentBorder"));
        this.setOpaque(false);
        this.header = new JPanel(new BorderLayout(4, 0));
        this.header.setBorder(BorderFactory.createEmptyBorder(4, 4, 1, 4));
        this.header.setOpaque(false);
        this.add((Component)this.header, "North");
        this.roomNameLabel = new JLabel();
        Font f = this.roomNameLabel.getFont();
        f = new Font(f.getFamily(), f.getStyle(), f.getSize() * 11 / 12);
        this.roomNameLabel.setFont(f);
        this.roomNameLabel.setForeground(UIManager.getColor("Participant.roomNameForeground"));
        this.header.add((Component)this.roomNameLabel, "West");
        this.participantCountLabel = new JLabel();
        this.participantCountLabel.setFont(f);
        this.participantCountLabel.setForeground(UIManager.getColor("Participant.participantCountForeground"));
        this.header.add((Component)this.participantCountLabel, "Center");
        this.list = new ParticipantList();
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && ParticipantListPanel.this.participantSelectionAPI != null) {
                    if (ParticipantListPanel.this.session == null) {
                        return;
                    }
                    CRParticipant me = ParticipantListPanel.this.session.getMe();
                    if (me == null) {
                        return;
                    }
                    ArrayList<CRParticipant> ps = new ArrayList<CRParticipant>();
                    ArrayList<CRRoom> rs = new ArrayList<CRRoom>();
                    for (Object obj : ParticipantListPanel.this.list.getSelectedValues()) {
                        if (obj instanceof CRParticipant) {
                            ps.add((CRParticipant)obj);
                            continue;
                        }
                        if (!(obj instanceof CRRoom)) continue;
                        rs.add((CRRoom)obj);
                    }
                    ParticipantListPanel.this.participantSelectionAPI.setSelectedParticipants(ps);
                    ParticipantListPanel.this.participantSelectionAPI.setSelectedRooms(rs);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.list, 20, 30);
        sp.setMinimumSize(new Dimension(72, 32));
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.setViewportBorder(BorderFactory.createEmptyBorder());
        this.add((Component)sp, "Center");
    }

    public void touchUp() {
        if (this.imps.findBest(ProfileDataAPI.class) != null) {
            this.list.touchUp();
        }
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initSession(CRSession session) {
        this.session = session;
        this.headerTransferHandler = new ParticipantHeaderTransferHandler(session);
        this.header.setTransferHandler(this.headerTransferHandler);
        this.listTransferHandler = new ParticipantListTransferHandler(session);
        this.list.setTransferHandler(this.listTransferHandler);
        this.list.setDragEnabled(true);
        session.addRoomListener(new CRRoomListener(){

            public void onRoomCreated(CRRoomEvent e) {
                final CRRoom r = e.getRoom();
                if (!r.isMain()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            boolean expanded = false;
                            CRParticipant me = ParticipantListPanel.this.session.getMe();
                            if (me != null && me.isChair()) {
                                expanded = true;
                            }
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.add(r, expanded);
                        }
                    });
                }
            }

            public void onRoomDeleted(CRRoomEvent e) {
                final CRRoom r = e.getRoom();
                if (!r.isMain()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.remove(r);
                        }
                    });
                }
            }

            public void onRoomRenamed(CRRoomEvent e) {
                final CRRoom r = e.getRoom();
                if (!r.isMain()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.update(r, true);
                        }
                    });
                }
            }
        });
        session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onParticipantAdded(CRParticipantEvent e) {
                final CRParticipant p = e.getParticipant();
                if (p.isVisible()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListPanel.this.updateParticipantCount(1);
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.add(p);
                        }
                    });
                }
            }

            public void onParticipantRemoved(CRParticipantEvent e) {
                final CRParticipant p = e.getParticipant();
                if (p.isVisible()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListPanel.this.updateParticipantCount(-1);
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.remove(p);
                        }
                    });
                }
            }

            public void onParticipantRenamed(CRParticipantEvent e) {
                final CRParticipant p = e.getParticipant();
                if (p.isVisible()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.update(p, true);
                        }
                    });
                }
            }

            public void onParticipantJoinedRoom(CRParticipantEvent e) {
                final CRParticipant p = e.getParticipant();
                if (p.isVisible()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.update(p, true);
                        }
                    });
                }
            }
        });
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
        this.roomNameLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTLIST_MAIN_ROOM));
    }

    @Inject
    public void initParticipantSelectionAPI(ParticipantSelectionAPI participantSelectionAPI) {
        this.participantSelectionAPI = participantSelectionAPI;
    }

    @Inject
    public void initProfilePopupClerk(ProfilePopupClerk profilePopupClerk) {
        profilePopupClerk.setParticipantList(this.list);
    }

    @Inject
    public void initGlobalPermissionsSupport(GlobalPermissionsSupport globalPermissionsSupport) {
        this.globalPermissionsSupport = globalPermissionsSupport;
    }

    public JPopupMenu getParticipantMenu() {
        return this.list.getParticipantMenu();
    }

    public JPopupMenu getRoomMenu() {
        return this.list.getRoomMenu();
    }

    private void updateParticipantCount(int delta) {
        this.participantCount += delta;
        this.participantCountLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTLIST_PARTICIPANT_COUNT, new Object[]{String.valueOf(this.participantCount)}));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Object pl = new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT) {
                    final CRParticipant p = ParticipantListPanel.this.session.getParticipantById(perm.getID());
                    if (p != null && p.isVisible()) {
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                                m.update(p, true);
                            }
                        });
                    }
                    if (p.isMe()) {
                        if (perm.getValue()) {
                            ParticipantListPanel.this.header.add((Component)ParticipantListPanel.this.globalPermissionsSupport.getPanel(), "East");
                        } else {
                            ParticipantListPanel.this.header.remove(ParticipantListPanel.this.globalPermissionsSupport.getPanel());
                        }
                    }
                }
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
            }
        };
        this.session.addPermissionChangeListener("ChairPermission", pl);
        pl = new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                CRParticipant p;
                CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT && (p = ParticipantListPanel.this.session.getParticipantById(perm.getID())) != null && p.isVisible()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.update(p, false);
                        }
                    });
                    if (perm.getName() == "ChatPermission" && p.isMe()) {
                        ParticipantListPanel.this.list.setCanSendPrivate(perm.getValue());
                    }
                }
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
                CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT) {
                    boolean permValue = false;
                    if (e.getValueChange().equals((Object)CRPermissionChangeEventType.FALSE_TO_TRUE)) {
                        permValue = true;
                    }
                    GlobalPermissionsSupport.setIcons(perm.getGroup(), permValue);
                    ParticipantListPanel.this.list.repaint();
                }
            }
        };
        this.session.addPermissionChangeListener("AudioPermission", pl);
        this.session.addPermissionChangeListener("VideoPermission", pl);
        this.session.addPermissionChangeListener("ChatPermission", pl);
        this.session.addPermissionChangeListener("AppSharePermission", pl);
        this.session.addPermissionChangeListener("WhiteBoardPermission", pl);
        this.session.addPermissionChangeListener("WebTourPermission", pl);
        this.session.addPermissionChangeListener("CaptionPermission", pl);
        Object al = new CRAnnotationChangeListener(){

            public void onAnnotationValueChange(CRAnnotationChangeEvent e) {
                CRAnnotation a = e.getNewAnnotation();
                final CRParticipant p = ParticipantListPanel.this.session.getParticipantById(a.getID());
                if (p != null && p.isVisible()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.update(p, true);
                        }
                    });
                }
            }
        };
        this.session.addAnnotationChangeListener("HandRaiseAnnotation", al);
        al = new CRAnnotationChangeListener(){

            public void onAnnotationValueChange(CRAnnotationChangeEvent e) {
                CRAnnotation a = e.getNewAnnotation();
                final CRParticipant p = ParticipantListPanel.this.session.getParticipantById(a.getID());
                if (p != null && p.isVisible()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantListModel m = (ParticipantListModel)ParticipantListPanel.this.list.getModel();
                            m.update(p, false);
                            CRRoom r = p.getRoom();
                            if (r != null && !r.isMain()) {
                                m.update(r, false);
                            }
                        }
                    });
                }
            }
        };
        this.session.addAnnotationChangeListener("AudioActivityAnnotation", al);
        this.session.addAnnotationChangeListener("AudioLagAnnotation", al);
        this.session.addAnnotationChangeListener("VideoActivityAnnotation", al);
        this.session.addAnnotationChangeListener("VideoLagAnnotation", al);
        this.session.addAnnotationChangeListener("ChatActivityAnnotation", al);
        this.session.addAnnotationChangeListener("ChatLagAnnotation", al);
        this.session.addAnnotationChangeListener("AppShareActivityAnnotation", al);
        this.session.addAnnotationChangeListener("AppShareLagAnnotation", al);
        this.session.addAnnotationChangeListener("WhiteboardActivityAnnotation", al);
        this.session.addAnnotationChangeListener("WhiteboardLagAnnotation", al);
        this.session.addAnnotationChangeListener("WebTourActivityAnnotation", al);
        this.session.addAnnotationChangeListener("WebTourLagAnnotation", al);
        this.session.addAnnotationChangeListener("CaptionActivityAnnotation", al);
        this.session.addAnnotationChangeListener("CaptionLagAnnotation", al);
        this.session.addAnnotationChangeListener("TelephonyActivityAnnotation", al);
        this.session.addAnnotationChangeListener("AudioSetupAnnotation", al);
        this.session.addAnnotationChangeListener("PollingAnnotation", al);
        this.session.addAnnotationChangeListener("AwayAnnotation", al);
        this.session.addAnnotationChangeListener("EmoticonAnnotation", al);
        this.session.addAnnotationChangeListener("ProfilePictureAnnotation", al);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.list.getBackground());
        g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
    }

    public void addParticipantGestureListener(ParticipantGestureListener l) {
        this.headerTransferHandler.addParticipantGestureListener(l);
        this.listTransferHandler.addParticipantGestureListener(l);
        this.list.addParticipantGestureListener(l);
    }

    public void removeParticipantGestureListener(ParticipantGestureListener l) {
        this.headerTransferHandler.removeParticipantGestureListener(l);
        this.listTransferHandler.removeParticipantGestureListener(l);
        this.list.removeParticipantGestureListener(l);
    }

    public boolean requestFirstFocus() {
        if (this.list.isFocusable() && this.list.isEnabled()) {
            this.list.requestFocus();
            return true;
        }
        return false;
    }
}

