/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.ParticipantGestureListener;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;

abstract class AbstractParticipantTransferHandler
extends TransferHandler {
    protected static final DataFlavor participantListFlavor = new DataFlavor(CRParticipant[].class, "Participant List");
    protected static final int PARTICIPANTS_MOVED = 1;
    protected static final int PARTICIPANTS_PROMOTED = 2;
    protected static final int PARTICIPANTS_DEMOTED = 3;
    private static final int LINK = 0x40000000;
    private static SwingDragGestureRecognizer recognizer = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected CRSession session;

    public AbstractParticipantTransferHandler(CRSession session) {
        this.session = session;
    }

    @Override
    public void exportAsDrag(JComponent component, InputEvent e, int action) {
        int srcActions = this.getSourceActions(component);
        if (!(e instanceof MouseEvent) || action != 1 && action != 2 && action != 0x40000000 || (srcActions & action) == 0) {
            action = 0;
        }
        if (action != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new SwingDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(component, (MouseEvent)e, srcActions, action);
        } else {
            this.exportDone(component, null, 0);
        }
    }

    public Image getVisualRepresentation(JComponent component, Transferable transferable) {
        return null;
    }

    public Point getVisualRepresentationOffset(JComponent component, Transferable transferable, Point dragOrigin) {
        return null;
    }

    @Override
    public boolean canImport(JComponent component, DataFlavor[] flavors) {
        for (DataFlavor flv : flavors) {
            if (!flv.equals(participantListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract boolean importData(JComponent var1, Transferable var2);

    protected boolean allDroppeesAreInMainRoom(List<CRParticipant> droppees) {
        for (CRParticipant p : droppees) {
            CRRoom r = p.getRoom();
            if (r == null || r.isMain()) continue;
            return false;
        }
        return true;
    }

    public void addParticipantGestureListener(ParticipantGestureListener l) {
        this.listenerList.add(ParticipantGestureListener.class, l);
    }

    public void removeParticipantGestureListener(ParticipantGestureListener l) {
        this.listenerList.remove(ParticipantGestureListener.class, l);
    }

    protected boolean fireParticipantGesture(int id, CRParticipant[] participants, CRRoom room) {
        boolean success = true;
        Object[] ls = this.listenerList.getListenerList();
        block5: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != ParticipantGestureListener.class) continue;
            ParticipantGestureListener al = (ParticipantGestureListener)ls[i + 1];
            switch (id) {
                case 1: {
                    if (al.moveParticipants(participants, room)) continue block5;
                    success = false;
                    continue block5;
                }
                case 2: {
                    if (al.promoteParticipants(participants)) continue block5;
                    success = false;
                    continue block5;
                }
                case 3: {
                    if (al.demoteParticipants(participants)) continue block5;
                    success = false;
                }
            }
        }
        return success;
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            JComponent c = (JComponent)e.getComponent();
            AbstractParticipantTransferHandler th = (AbstractParticipantTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    Image im = th.getVisualRepresentation(c, t);
                    if (im != null) {
                        Point pt = th.getVisualRepresentationOffset(c, t, e.getDragOrigin());
                        if (pt == null) {
                            pt = new Point(-im.getWidth(null) / 2, -im.getHeight(null) / 2);
                        }
                        e.startDrag(null, im, pt, t, this);
                    } else {
                        e.startDrag(null, t, this);
                    }
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, t, 0);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            DragSourceContext dsc = e.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            AbstractParticipantTransferHandler th = (AbstractParticipantTransferHandler)c.getTransferHandler();
            if (e.getDropSuccess()) {
                th.exportDone(c, dsc.getTransferable(), e.getDropAction());
            } else {
                th.exportDone(c, dsc.getTransferable(), 0);
            }
            c.setAutoscrolls(this.scrolls);
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }
}

