/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.TopBar;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.location.MenuSectionSupport;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.FeaturePair;
import com.elluminate.framework.location.PairedFeatureAdapter;
import com.elluminate.framework.location.PairedFeatureAdapterProvider;
import com.elluminate.framework.location.StringFeatureAdapter;
import com.elluminate.framework.location.StringFeatureAdapterProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;

public class TopBarLocationHandler
extends AbstractSwingLocationHandler {
    private static final String LOCATION = "topBar";
    private static final String AREA = "topBarArea";
    private static final String DISPLAY_PANEL_AREA = "displayPanel";
    private static final String OPTIONS_MENU_AREA = "optionsMenu";
    private static final String SESSION_ACTIONS_AREA = "sessionActions";
    private static final String MENU_SECTION = "topBarMenuSection";
    private static final String ACTION_SECTION = "actionSection";
    private static final String INFORMATION_SECTION = "informationSection";
    private static final String ORDER = "order";
    private static final String INVERSE_HINT = "topBar.inverse";
    private I18n i18n;
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private MenuSectionSupport menuSupport = new MenuSectionSupport();
    private TopBar topBar;
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private BooleanFeatureAdapterProvider booleanAdapterProvider;
    private PairedFeatureAdapterProvider pairedAdapterProvider;
    private StringFeatureAdapterProvider stringAdapterProvider;
    private Map<String, FeaturePair> pending = new HashMap<String, FeaturePair>();

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider, BooleanFeatureAdapterProvider booleanAdapterProvider, PairedFeatureAdapterProvider pairedAdapterProvider, StringFeatureAdapterProvider stringAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
        this.booleanAdapterProvider = booleanAdapterProvider;
        this.pairedAdapterProvider = pairedAdapterProvider;
        this.stringAdapterProvider = stringAdapterProvider;
    }

    public void setTopBar(TopBar topBar) {
        this.topBar = topBar;
        this.menuSupport.setMenu(topBar.getOptionsMenu());
        this.menuSupport.addSection(ACTION_SECTION);
        this.menuSupport.addSection(INFORMATION_SECTION);
    }

    protected void addFeatureSwing(Feature feature) {
        Object area = feature.getHintValue(AREA);
        if (area.equals(DISPLAY_PANEL_AREA)) {
            this.addDisplay(feature);
        } else if (area.equals(OPTIONS_MENU_AREA)) {
            this.addOption(feature);
        } else if (area.equals(SESSION_ACTIONS_AREA)) {
            this.addSessionAction(feature);
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        Object area = feature.getHintValue(AREA);
        if (area.equals(DISPLAY_PANEL_AREA)) {
            this.removeDisplay(feature);
        } else if (area.equals(OPTIONS_MENU_AREA)) {
            this.removeOption(feature);
        } else if (area.equals(SESSION_ACTIONS_AREA)) {
            this.removeSessionAction(feature);
        }
    }

    private void addDisplay(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Component c = cf.getComponent();
            this.topBar.addDisplayComponent(c);
        }
    }

    private void removeDisplay(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            this.topBar.removeDisplayComponent(cf.getComponent());
        }
    }

    private void addOption(Feature feature) {
        JMenuItem mi;
        JMenuItem c = null;
        BooleanFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            mi = new JMenuItem();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)mi, null);
            aa.setInteractiveSubstitution(this.i18n.getString((PropertiesEnum)StringsProperties.MENUHANDLER_INTERACTIVEITEM));
            aa.setHasText(true);
            c = mi;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            mi = new JCheckBoxMenuItem();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)mi, null);
            ba.setHasText(true);
            c = mi;
            a = ba;
        } else if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            mi = new JMenuItem();
            StringFeatureAdapter sa = this.stringAdapterProvider.get(LOCATION, sf, mi, null);
            sa.setHasText(true);
            c = mi;
            a = sa;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            Object section = feature.getHintValue(MENU_SECTION);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            this.menuSupport.add(c, String.valueOf(section), order);
        }
    }

    private void removeOption(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.menuSupport.remove((JComponent)a.getComponent());
            a.dispose();
        }
    }

    private void addSessionAction(Feature feature) {
        JComponent c = null;
        BooleanFeatureAdapter a = null;
        if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            if (bf.isMutable()) {
                SButton b = new SButton();
                b.setHorizontalTextPosition(10);
                BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)b, null);
                ba.setHasText(true);
                ba.setHasIcon(true);
                ba.setHasToolTip(true);
                c = b;
                a = ba;
            }
        } else if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            if (af.hasHint(INVERSE_HINT)) {
                FeaturePair pair = this.pending.remove(af.getPath());
                if (pair == null) {
                    pair = new FeaturePair(af);
                    String inverse = (String)af.getHintValue(INVERSE_HINT, String.class);
                    this.pending.put(inverse, pair);
                } else {
                    pair.finish(af);
                    SButton b = new SButton();
                    PairedFeatureAdapter pa = this.pairedAdapterProvider.get(LOCATION, pair, (AbstractButton)b, null);
                    pa.setHasText(true);
                    pa.setHasIcon(true);
                    pa.setHasToolTip(true);
                    c = b;
                    a = pa;
                }
            } else {
                SButton b = new SButton();
                ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)b, null);
                aa.setHasText(true);
                aa.setHasIcon(true);
                aa.setHasToolTip(true);
                c = b;
                a = aa;
            }
        } else if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            JLabel l = new JLabel();
            l.setHorizontalTextPosition(10);
            StringFeatureAdapter sa = this.stringAdapterProvider.get(LOCATION, sf, l, null);
            sa.setHasText(true);
            sa.setHasIcon(true);
            sa.setHasToolTip(true);
            c = l;
            a = sa;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            this.topBar.addSessionAction(c);
        }
    }

    private void removeSessionAction(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.topBar.removeSessionAction(a.getComponent());
            a.dispose();
        }
    }
}

