/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ListElementChangeEvent;
import com.elluminate.framework.feature.ListElementChangeListener;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.framework.feature.whiteboard.ScreenInfo;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.util.SwingRunner;
import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ScreenListFeatureAdapter
extends FeatureAdapter {
    private JComboBox combo;
    private JLabel alternateLabel;
    private ListFeature<ScreenInfo> listFeature;
    private ActionFeature gotoAction;
    private ValueFeature<ScreenInfo> selectedScreenFeature;
    private ListElementChangeListener listListener;
    private MetaDataListener listEnabledListener;
    private MetaDataListener valueChangeListener;
    private ActionListener comboActionListener;
    private SwingRunner swinger;

    @Inject
    public void initSwingRunner(SwingRunner swinger) {
        this.swinger = swinger;
    }

    public void init(JComboBox combo, ListFeature<ScreenInfo> lf) {
        this.combo = combo;
        this.listFeature = lf;
        this.wireFeaturesUp();
    }

    public void initGotoAction(ActionFeature gotoAction) {
        this.gotoAction = gotoAction;
        this.wireFeaturesUp();
    }

    public void initSelectedFeature(JLabel label, ValueFeature<ScreenInfo> feature) {
        this.alternateLabel = label;
        this.selectedScreenFeature = feature;
        this.wireFeaturesUp();
    }

    public void removeListFeature() {
        if (this.listFeature != null) {
            this.listFeature.removeListElementListener(this.listListener);
            this.listFeature.removeMetaDataListener("Feature.enabled", this.listEnabledListener);
            this.combo.setEnabled(false);
            this.listFeature = null;
            this.updateScreenList();
        }
    }

    public void removeGotoAction() {
        this.gotoAction = null;
    }

    public void removeSelectedScreenFeature() {
        if (this.selectedScreenFeature != null) {
            this.selectedScreenFeature.removeValueChangeListener(this.valueChangeListener);
            this.selectedScreenFeature = null;
        }
    }

    boolean isEmpty() {
        return this.listFeature == null && this.gotoAction != null && this.selectedScreenFeature == null;
    }

    ListFeature<ScreenInfo> getListFeature() {
        return this.listFeature;
    }

    ActionFeature getGotoAction() {
        return this.gotoAction;
    }

    ValueFeature<ScreenInfo> getSelectedScreenFeature() {
        return this.selectedScreenFeature;
    }

    boolean isComboActive() {
        return this.listFeature != null;
    }

    JComboBox getCombo() {
        return this.combo;
    }

    JLabel getAlternateLabel() {
        return this.alternateLabel;
    }

    private void wireFeaturesUp() {
        if (this.combo == null && this.alternateLabel == null || this.listFeature == null && this.selectedScreenFeature == null) {
            return;
        }
        if (this.combo != null) {
            this.updateScreenList();
            this.combo.setEnabled(this.listFeature.isEnabled());
            this.combo.addActionListener(this.createComboActionListener());
        }
        if (this.alternateLabel != null) {
            this.alternateLabel.setText("" + this.selectedScreenFeature.getValue());
            this.alternateLabel.revalidate();
        }
        if (this.listFeature != null) {
            this.listFeature.addListElementListener(this.createListListener());
            this.listFeature.addMetaDataListener("Feature.enabled", this.createListEnabledListener());
        }
        if (this.selectedScreenFeature != null) {
            this.selectedScreenFeature.addValueChangeListener(this.createValueChangeListener());
        }
    }

    private MetaDataListener createListEnabledListener() {
        if (this.listEnabledListener == null) {
            this.listEnabledListener = new MetaDataListener(){

                public void metaDataChanged(MetaDataEvent ev) {
                    final Boolean val = (Boolean)ev.getNewValue();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ScreenListFeatureAdapter.this.combo.setEnabled(val);
                        }
                    };
                    ScreenListFeatureAdapter.this.swinger.invokeOnEventThread(r);
                }
            };
        }
        return this.listEnabledListener;
    }

    private ActionListener createComboActionListener() {
        if (this.comboActionListener == null) {
            this.comboActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (ScreenListFeatureAdapter.this.gotoAction != null) {
                        ScreenInfo si = (ScreenInfo)ScreenListFeatureAdapter.this.combo.getSelectedItem();
                        ScreenListFeatureAdapter.this.gotoAction.fireActionFeatureListeners((Object)si);
                    }
                    if (ScreenListFeatureAdapter.this.selectedScreenFeature != null) {
                        ScreenListFeatureAdapter.this.combo.getModel().setSelectedItem(ScreenListFeatureAdapter.this.selectedScreenFeature.getValue());
                    }
                }
            };
        }
        return this.comboActionListener;
    }

    private ListElementChangeListener createListListener() {
        if (this.listListener == null) {
            this.listListener = new ListElementChangeListener(){
                private Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        ScreenListFeatureAdapter.this.updateScreenList();
                    }
                };

                public void elementAdded(ListElementChangeEvent event) {
                    ScreenListFeatureAdapter.this.swinger.invokeLater(this.runner);
                }

                public void elementRemoved(ListElementChangeEvent event) {
                    ScreenListFeatureAdapter.this.swinger.invokeLater(this.runner);
                }

                public void allElementsCleared(ListElementChangeEvent event) {
                    ScreenListFeatureAdapter.this.swinger.invokeLater(this.runner);
                }

                public void elementsBatchUpdated(ListElementChangeEvent event) {
                    ScreenListFeatureAdapter.this.swinger.invokeLater(this.runner);
                }
            };
        }
        return this.listListener;
    }

    private void updateScreenList() {
        if (this.combo == null) {
            return;
        }
        Object oldSelect = this.selectedScreenFeature != null ? this.selectedScreenFeature.getValue() : this.combo.getModel().getSelectedItem();
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>();
        if (this.listFeature != null) {
            for (int i = 0; i < this.listFeature.size(); ++i) {
                Object val = this.listFeature.get(i);
                comboModel.addElement(val);
            }
            comboModel.setSelectedItem(oldSelect);
        }
        this.combo.setModel(comboModel);
    }

    public void dispose() {
        this.removeListFeature();
        this.removeGotoAction();
        this.removeSelectedScreenFeature();
        if (this.combo != null) {
            this.combo.removeActionListener(this.comboActionListener);
        }
        this.combo = null;
        this.alternateLabel = null;
    }

    private MetaDataListener createValueChangeListener() {
        if (this.valueChangeListener == null) {
            this.valueChangeListener = new MetaDataListener(){

                public void metaDataChanged(MetaDataEvent ev) {
                    final Object val = ev.getNewValue();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            if (ScreenListFeatureAdapter.this.combo != null) {
                                Object oldVal = ScreenListFeatureAdapter.this.combo.getModel().getSelectedItem();
                                if (val != null && !val.equals(oldVal) || val == null && oldVal != null) {
                                    ScreenListFeatureAdapter.this.combo.getModel().setSelectedItem(val);
                                }
                            }
                            if (ScreenListFeatureAdapter.this.alternateLabel != null) {
                                ScreenListFeatureAdapter.this.alternateLabel.setText("" + val);
                                ScreenListFeatureAdapter.this.alternateLabel.revalidate();
                            }
                        }
                    };
                    ScreenListFeatureAdapter.this.swinger.invokeOnEventThread(r);
                }
            };
        }
        return this.valueChangeListener;
    }

    public void setHasText(boolean hasText) {
    }

    public void setHasToolTip(boolean hasTip) {
    }
}

