/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.client.GeneralPrefsOwner;
import com.elluminate.classroom.swing.location.HotKeyAction;
import com.elluminate.classroom.swing.location.HotKeyLocationHandler;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.EnumCellRenderer;
import com.elluminate.gui.component.HotKeyPane;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class HotKeyPrefsPanel
extends AbstractPreferencesPanel {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private HotKeyModel keyModel;
    private JTable keyTable;
    private JScrollPane keyScroller;
    private JButton changeBtn;
    private HotKeyLocationHandler hotKeyMgr = null;
    private EnumCellRenderer validRenderer = new EnumCellRenderer();
    private List<HotKeyInfo> hotKeys = new ArrayList<HotKeyInfo>();

    @Inject
    public HotKeyPrefsPanel(GeneralPrefsOwner owner) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_TITLE));
    }

    @Inject
    public void initLocationHandler(HotKeyLocationHandler handler) {
        this.hotKeyMgr = handler;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout(0, 6));
        this.add(p, "North");
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn(0);
        column.setResizable(true);
        column.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_DESCCOLUMN));
        columnModel.addColumn(column);
        column = new TableColumn(1, 100);
        column.setResizable(true);
        column.setMinWidth(50);
        column.setMaxWidth(150);
        column.setPreferredWidth(100);
        column.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_KEYSEQCOLUMN));
        columnModel.addColumn(column);
        this.validRenderer.addMapping((Object)Boolean.TRUE, (Object)UIManager.getIcon("HotKey.validIcon"));
        this.validRenderer.addMapping((Object)Boolean.FALSE, (Object)UIManager.getIcon("HotKey.invalidIcon"));
        column = new TableColumn(2, 32, (TableCellRenderer)this.validRenderer, null);
        column.setResizable(false);
        column.setMinWidth(40);
        column.setMaxWidth(40);
        column.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_VALIDCOLUMN));
        columnModel.addColumn(column);
        this.keyModel = new HotKeyModel();
        this.keyTable = new CTable((TableModel)this.keyModel, (TableColumnModel)columnModel);
        this.keyTable.setSelectionMode(0);
        this.keyTable.setShowGrid(false);
        this.keyTable.setIntercellSpacing(new Dimension(0, 1));
        this.keyTable.setFocusTraversalKeys(0, null);
        this.keyTable.setFocusTraversalKeys(1, null);
        this.keyScroller = new JScrollPane(this.keyTable, 22, 31);
        this.keyScroller.setPreferredSize(new Dimension(300, 200));
        this.keyScroller.getViewport().setBackground(this.keyTable.getBackground());
        this.keyScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HotKeyPrefsPanel.this.keyTable.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                HotKeyPrefsPanel.this.keyTable.clearSelection();
            }
        });
        this.keyTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getClickCount() == 2 && HotKeyPrefsPanel.this.changeBtn.isEnabled()) {
                    HotKeyPrefsPanel.this.changeBtn.doClick();
                }
            }
        });
        this.keyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HotKeyPrefsPanel.this.enableModifyButton();
            }
        });
        this.changeBtn = new JButton(i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_CHANGEBTN));
        this.changeBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_CHANGEBTNTIP));
        this.changeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HotKeyPrefsPanel.this.doModifyButton();
            }
        });
        JPanel bottomPanel = new JPanel(new FlowLayout(2, 0, 0));
        bottomPanel.add(this.changeBtn);
        MultilineLabel exposition = new MultilineLabel(i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_EXPOSITORYTEXT));
        p.add((Component)exposition, "North");
        p.add((Component)this.keyScroller, "Center");
        p.add((Component)bottomPanel, "South");
        this.enableModifyButton();
    }

    private void enableModifyButton() {
        this.changeBtn.setEnabled(this.keyTable.getSelectedRowCount() > 0);
    }

    private void doModifyButton() {
        int answer;
        KeyStroke stroke;
        int row = this.keyTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        HotKeyInfo info = this.hotKeys.get(row);
        KeyStroke prev = info.getKeyStroke();
        if (prev == (stroke = HotKeyPane.getHotKey((Component)((Object)this), (String)i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_EDITDIALOGTITLE), (KeyStroke)prev))) {
            return;
        }
        boolean valid = this.hotKeyMgr.isHotKeyValid(stroke);
        if (!valid && (answer = ModalDialog.showConfirmDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_USEANYWAY, new Object[]{info.getDesc()}), (String)i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_USEANYWAYTITLE), (int)0, (int)3)) != 0) {
            return;
        }
        info.setKeyStroke(stroke);
        this.keyModel.fireTableRowsUpdated(row, row);
        this.setModified(true);
    }

    protected void populate(Preferences preferences) {
        this.hotKeys.clear();
        for (HotKeyAction action : this.hotKeyMgr.getActions()) {
            this.hotKeys.add(new HotKeyInfo(preferences, action));
        }
        this.keyModel.fireTableRowsUpdated(0, this.hotKeys.size() - 1);
    }

    protected void apply(Preferences preferences) {
        for (HotKeyInfo info : this.hotKeys) {
            info.apply(preferences);
        }
    }

    protected void reset(Preferences preferences) {
        for (HotKeyAction action : this.hotKeyMgr.getActions()) {
            action.resetPreference(preferences);
        }
    }

    class HotKeyInfo {
        HotKeyAction action;
        KeyStroke stroke;
        Boolean valid = null;

        public HotKeyInfo(Preferences prefs, HotKeyAction action) {
            this.action = action;
            this.setKeyStroke(action.getPreference(prefs));
        }

        public boolean isModified() {
            return this.stroke != this.action.getKeyStroke();
        }

        public boolean isValid() {
            if (this.valid == null) {
                this.valid = HotKeyPrefsPanel.this.hotKeyMgr.isHotKeyValid(this.stroke);
            }
            return this.valid;
        }

        public KeyStroke getKeyStroke() {
            return this.stroke;
        }

        public void setKeyStroke(KeyStroke stroke) {
            this.stroke = stroke;
            this.valid = stroke == this.action.getKeyStroke() ? Boolean.valueOf(this.action.isValid()) : (stroke == null ? Boolean.valueOf(true) : null);
        }

        public String getDesc() {
            return this.action.getDescription();
        }

        public void apply(Preferences prefs) {
            this.action.setPreference(prefs, this.stroke);
        }

        public void reset(Preferences prefs) {
            this.action.resetPreference(prefs);
        }
    }

    private class HotKeyModel
    extends AbstractTableModel {
        private HotKeyModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return HotKeyPrefsPanel.this.hotKeys.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                HotKeyInfo info = (HotKeyInfo)HotKeyPrefsPanel.this.hotKeys.get(row);
                switch (column) {
                    case 0: {
                        return info.getDesc();
                    }
                    case 1: {
                        KeyStroke stroke = info.getKeyStroke();
                        if (stroke == null) {
                            return i18n.getString((PropertiesEnum)StringsProperties.HOTKEYS_NOKEY);
                        }
                        return GuiUtils.getKeystrokeText((KeyStroke)stroke);
                    }
                    case 2: {
                        return info.isValid() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

