/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.ContentLoader;
import com.elluminate.classroom.swing.ItemSelectionDialog;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.groupware.LabelProps;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

@Singleton
public class ContentLoaderLocationHandler
extends AbstractSwingLocationHandler {
    private static final String LOCATION = "contentLoader";
    private I18n i18n;
    private DialogParentProvider parentProvider;
    private List<LoadFeature> loadFeatures = new ArrayList<LoadFeature>();
    private ArrayList<ContentLoader> contentLoaders = new ArrayList();

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initParentProvider(DialogParentProvider parentProvider) {
        this.parentProvider = parentProvider;
    }

    public void addContentLoader(ContentLoader contentLoader) {
        this.contentLoaders.add(contentLoader);
    }

    public boolean loadContent(File[] files) {
        List<LoadFeature> lfs;
        List fs;
        HashMap<String, ArrayList<File>> filesByType = new HashMap<String, ArrayList<File>>();
        for (File f : files) {
            String type = this.getFileType(f);
            fs = (ArrayList<File>)filesByType.get(type);
            if (fs == null) {
                fs = new ArrayList<File>();
                filesByType.put(type, (ArrayList<File>)fs);
            }
            fs.add(f);
        }
        HashMap featuresByType = new HashMap();
        for (String type : filesByType.keySet()) {
            for (LoadFeature lf : this.loadFeatures) {
                List types = lf.getFileTypes();
                if (types == null) {
                    lfs = (ArrayList<LoadFeature>)featuresByType.get(null);
                    if (lfs == null) {
                        lfs = new ArrayList<LoadFeature>();
                        featuresByType.put(null, lfs);
                    }
                    if (lfs.contains(lf)) continue;
                    lfs.add(lf);
                    continue;
                }
                if (!types.contains(type)) continue;
                lfs = (List)featuresByType.get(type);
                if (lfs == null) {
                    lfs = new ArrayList();
                    featuresByType.put(type, lfs);
                }
                if (lfs.contains(lf)) continue;
                lfs.add(lf);
            }
        }
        boolean handled = false;
        ArrayList<String> typesNotLoaded = new ArrayList<String>();
        for (String type : filesByType.keySet()) {
            fs = (List)filesByType.get(type);
            lfs = (List)featuresByType.get(type);
            if (lfs == null) {
                lfs = (List)featuresByType.get(null);
                if (lfs == null) {
                    typesNotLoaded.add(type);
                    continue;
                }
                int numFilesOfThisType = fs.size();
                String thisThese = numFilesOfThisType == 1 ? this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_UNSUPPORTED_CONTENT_THIS) : this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_UNSUPPORTED_CONTENT_THESE);
                String parts = LabelProps.get(null, (String)"Label.participants");
                if (ModalDialog.showConfirmDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_UNSUPPORTED_CONTENT_PROMPT, new Object[]{type, thisThese, parts}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_UNSUPPORTED_CONTENT_TITLE), (int)0, (int)2) == 1) continue;
            }
            if (lfs.size() == 1) {
                ((LoadFeature)lfs.get(0)).loadContent(fs);
                handled = true;
                continue;
            }
            ItemSelectionDialog d = new ItemSelectionDialog(this.parentProvider.getDialogParent(), this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_LOAD_CONTENT_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_LOAD_CONTENT_BUTTON));
            d.setItemRenderer(new LoadFeatureRenderer());
            for (LoadFeature f : lfs) {
                d.addItem(f);
            }
            d.show();
            if (d.wasCanceled()) {
                return handled;
            }
            ((LoadFeature)d.getSelectedItem()).loadContent(fs);
            handled = true;
        }
        if (!typesNotLoaded.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < typesNotLoaded.size(); ++i) {
                if (i != 0) {
                    if (i == typesNotLoaded.size() - 1) {
                        b.append(' ');
                        b.append(this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_CANNOT_LOAD_AND));
                        b.append(' ');
                    } else {
                        b.append(this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_CANNOT_LOAD_COMMA));
                        b.append(' ');
                    }
                }
                b.append('\'');
                b.append((String)typesNotLoaded.get(i));
                b.append('\'');
            }
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_CANNOT_LOAD_TEXT, new Object[]{b.toString()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CONTENTLOADER_CANNOT_LOAD_TITLE), (int)2);
        }
        return handled;
    }

    private String getFileType(File file) {
        String ext;
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1 && (ext = name.substring(pos + 1)).length() != 0) {
            return ext.toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    protected void addFeatureSwing(Feature feature) {
        if (feature instanceof LoadFeature) {
            this.loadFeatures.add((LoadFeature)feature);
            for (ContentLoader l : this.contentLoaders) {
                l.setContentLoadable(true);
            }
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        if (feature instanceof LoadFeature) {
            this.loadFeatures.remove((LoadFeature)feature);
            for (ContentLoader l : this.contentLoaders) {
                l.setContentLoadable(!this.loadFeatures.isEmpty());
            }
        }
    }

    private static class LoadFeatureRenderer
    extends DefaultListCellRenderer {
        private LoadFeatureRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, focused);
            if (value instanceof LoadFeature) {
                LoadFeature lf = (LoadFeature)value;
                this.setText(lf.getName());
                this.setFont(this.getFont().deriveFont(1));
                this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(6, 10, 6, 10)));
            }
            return this;
        }
    }
}

