/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.module.AudioAPI;
import com.elluminate.groupware.imps.module.AudioAlertAPI;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.Preferences;
import com.elluminate.util.Resource;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class AudioAlert
implements AudioAlertAPI {
    public static final DebugFlag AUDIO_ALERT = DebugFlag.get((String)"audio.audioAlert");
    private Imps imps;
    private String key;
    private String name;
    private String description;
    private boolean defaultEnabled = true;
    private boolean enabled;
    private boolean mandatory;
    private boolean legacy;
    private Resource resource = null;
    private short[] samples = null;

    @Inject
    AudioAlert(Imps imps) {
        this.imps = imps;
    }

    void initialize(String theKey, String theName, String theDescription, Resource theResource) {
        this.key = theKey;
        this.name = theName;
        this.description = theDescription;
        this.enabled = true;
        this.mandatory = false;
        this.resource = theResource;
    }

    public String toString() {
        return "AudioAlert#" + this.hashCode() + " '" + this.name + "' sound=" + this.getCustomSoundName() + " len=" + this.getSampleCount() + " mandatory=" + this.mandatory + " enabled=" + this.enabled;
    }

    public void loadPreferences(Preferences prefs) {
        this.enabled = prefs.getBooleanSetting(this.getEnabledKey(), this.defaultEnabled);
        prefs.addSettingChangeListener(this.getEnabledKey(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AudioAlert.this.setEnabled(e.getNewValue().equals("true"));
            }
        });
    }

    public void setMandatory(boolean b) {
        this.mandatory = b;
        if (this.mandatory) {
            this.enabled = true;
        }
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setDefaultEnabled(boolean b) {
        if (this.mandatory) {
            return;
        }
        this.defaultEnabled = b;
    }

    public boolean isDefaultEnabled() {
        return this.mandatory || this.defaultEnabled;
    }

    public void setEnabled(boolean b) {
        if (this.mandatory) {
            return;
        }
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.mandatory || this.enabled;
    }

    public void setLegacy(boolean b) {
        this.legacy = b;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public void playCustomSound() {
        if (AUDIO_ALERT.show()) {
            LogSupport.message((Object)this, (String)"playCustomSound", (String)this.toString());
        }
        if (this.isEnabled()) {
            this.playSound();
        }
    }

    public void previewCustomSound() {
        this.playSound();
    }

    private void playSound() {
        AudioAPI audioAPI = (AudioAPI)this.imps.findBest(AudioAPI.class);
        if (audioAPI != null) {
            audioAPI.playCustomAlert((AudioAlertAPI)this);
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getEnabledKey() {
        return this.key + ".enabled";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public boolean hasCustomSound() {
        return this.resource != null;
    }

    public void clearCustomSound() {
        this.resource = null;
        this.samples = null;
    }

    public String getCustomSoundName() {
        if (this.resource == null) {
            return "";
        }
        String f = new File(this.resource.getPath()).getName();
        return FileSysUtils.stripExtension((String)f);
    }

    public int getDuration() {
        if (this.samples != null) {
            return (this.samples.length + 4) / 8;
        }
        return 1000;
    }

    public int getSampleCount() {
        return this.samples == null ? 0 : this.samples.length;
    }

    public short[] getSamples() {
        return this.samples;
    }

    public void setSamples(short[] theSamples) {
        this.samples = theSamples;
    }

    public String getLoadedFileName() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getPath();
    }

    public URL getURL() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.find();
    }

    public byte[] getBytes() {
        if (this.resource == null) {
            return null;
        }
        try {
            return this.resource.load();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

