/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.SNavigationPanel;
import com.elluminate.classroom.swing.components.skin.SNavigationPanelUI;
import com.elluminate.classroom.swing.components.skin.shade.Shade;
import com.elluminate.classroom.swing.components.skin.shade.ShadeNavigationPanelBorder;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class ShadeNavigationPanelUI
extends SNavigationPanelUI {
    private SNavigationPanel nb;
    private Border dockedBorder = new ShadeNavigationPanelBorder();
    private Border undockedBorder = BorderFactory.createEmptyBorder();
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("docked")) {
                boolean docked = (Boolean)e.getNewValue();
                ShadeNavigationPanelUI.this.nb.setBorder(docked ? ShadeNavigationPanelUI.this.dockedBorder : ShadeNavigationPanelUI.this.undockedBorder);
                ShadeNavigationPanelUI.this.nb.repaint();
            }
        }
    };
    private Paint gradient;
    private int lastHeight = -1;

    public static ComponentUI createUI(JComponent c) {
        return new ShadeNavigationPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.nb = (SNavigationPanel)c;
        this.nb.setBorder(this.nb.isDocked() ? this.dockedBorder : this.undockedBorder);
        this.nb.addPropertyChangeListener("docked", this.propertyListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.nb.removePropertyChangeListener("docked", this.propertyListener);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Dimension s = this.nb.getSize();
        Insets ins = this.nb.getInsets();
        if (this.gradient == null || s.height != this.lastHeight) {
            this.lastHeight = s.height;
            int h = Math.min(this.lastHeight, 26) - 2;
            this.gradient = new GradientPaint(0.0f, 0.0f, Shade.lightenColor(UIManager.getColor("NavigationPanel.background"), 0.267), 0.0f, h, UIManager.getColor("NavigationPanel.background"));
        }
        int offset = 0;
        if (this.nb.isDocked()) {
            offset = 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.gradient);
        g2.fillRect(offset, 0, s.width - offset, s.height - offset);
    }
}

