/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.classroom.swing.components.skin.delegate.DelegateButtonUI;
import com.elluminate.classroom.swing.components.skin.shade.Shade;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ShadeMenuButtonUI
extends DelegateButtonUI {
    private static final int ARROW_SIZE = 3;
    private SMenuButton b;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("arrowPainted")) {
                ShadeMenuButtonUI.this.b.repaint();
            } else if (prop.equals("JButton.buttonType")) {
                ShadeMenuButtonUI.this.updateMacForeground();
            }
        }
    };
    private ItemListener itemListener;
    private Color normalMacForeground;

    public static ComponentUI createUI(JComponent c) {
        return new ShadeMenuButtonUI();
    }

    public ShadeMenuButtonUI() {
        super("ButtonUI");
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.b = (SMenuButton)c;
        this.b.addPropertyChangeListener("arrowPainted", this.propertyListener);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ShadeMenuButtonUI.this.updateMacForeground();
                }
            };
            this.b.addItemListener(this.itemListener);
            this.b.addPropertyChangeListener("JButton.buttonType", this.propertyListener);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.b.removePropertyChangeListener("arrowPainted", this.propertyListener);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (this.b.isArrowPainted()) {
            String txt;
            int ph = this.getPreferredSize((JComponent)this.b).height;
            int th = 0;
            Icon ic = this.b.getIcon();
            if (ic != null) {
                th = Math.max(th, ic.getIconHeight());
            }
            if ((txt = this.b.getText()) != null && txt.length() == 0) {
                txt = null;
            }
            if (txt != null) {
                FontMetrics fm = this.b.getFontMetrics(this.b.getFont());
                th = Math.max(th, fm.getAscent() + fm.getDescent());
            }
            int inset = (ph - th) / 2;
            int dx = this.b.getWidth() - inset - 3 - 1;
            int dy = this.b.getHeight() - inset - 1;
            Graphics2D g2 = (Graphics2D)g;
            Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.translate(dx, dy);
            int[] xs = new int[]{0, 3, 6};
            int[] ys = new int[]{0, 3, 0};
            Color co = this.b.getForeground();
            ButtonModel m = this.b.getModel();
            if (!(this.b.getRolloverIcon() == null || m.isSelected() || m.isArmed() || m.isPressed() || m.isRollover())) {
                co = Shade.lightenColor(co, 0.5);
            }
            g.setColor(co);
            g.fillPolygon(xs, ys, xs.length);
            g.translate(-dx, -dy);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        }
    }

    private void updateMacForeground() {
        Object buttonType = this.b.getClientProperty("JButton.buttonType");
        if (buttonType != null && buttonType.equals("textured")) {
            if (this.b.isSelected()) {
                if (this.normalMacForeground == null) {
                    this.normalMacForeground = this.b.getForeground();
                }
                this.b.setForeground(Color.WHITE);
            } else {
                this.b.setForeground(this.normalMacForeground);
            }
        }
    }
}

