/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.skin.SBadgeIcon;
import com.elluminate.classroom.swing.components.skin.shade.Shade;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.UIManager;

public class ShadeBadgeIcon
extends SBadgeIcon {
    private static Component component = new Canvas();
    private String text;
    private Font font = UIManager.getFont("Badge.font");
    private Color color = UIManager.getColor("Badge.color");
    private FontMetrics fontMetrics;
    private Dimension size;

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = null;
        this.size = null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    private FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            this.fontMetrics = component.getFontMetrics(this.font);
        }
        return this.fontMetrics;
    }

    private Dimension getSize() {
        if (this.size == null) {
            FontMetrics fm = this.getFontMetrics();
            this.size = new Dimension(fm.stringWidth(this.text) + 6, fm.getAscent() + fm.getDescent() + 1);
            this.size.width = Math.max(this.size.width, this.size.height);
        }
        return this.size;
    }

    @Override
    public int getIconWidth() {
        return this.getSize().width;
    }

    @Override
    public int getIconHeight() {
        return this.getSize().height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension s = new Dimension(this.getIconWidth(), this.getIconHeight());
        int arc = s.height - 1;
        g2.setColor(this.color);
        g2.fillRoundRect(x + 1, y + 1, s.width - 2, s.height - 2, arc - 2, arc - 2);
        g2.setColor(Shade.darkenColor(this.color, 0.2));
        g2.drawRoundRect(x, y, s.width - 1, s.height - 1, arc - 1, arc - 1);
        if (this.text != null) {
            g2.setColor(Shade.contrastColor(this.color));
            g2.setFont(this.font);
            FontMetrics fm = this.getFontMetrics();
            float fx = (float)x + (float)(s.width - fm.stringWidth(this.text)) / 2.0f;
            float fy = (float)y + (float)s.height / 2.0f + (float)(fm.getAscent() + fm.getDescent()) / 2.0f - (float)fm.getDescent();
            for (int i = 0; i < 3; ++i) {
                g2.drawString(this.text, fx, fy);
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }
}

