/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.OverflowLayout;
import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.classroom.swing.components.SSideBarTab;
import com.elluminate.classroom.swing.components.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SSideBarTabBar
extends JComponent
implements FocusListener,
Accessible {
    private static final String uiClassID = "SSideBarTabBarUI";
    static final String NEXT_FAUX_FOCUS_ACTION_KEY = "next.faux.focus.action";
    static final String PREV_FAUX_FOCUS_ACTION_KEY = "prev.faux.focus.action";
    static final String SELECT_FAUX_FOCUS_TAB_ACTION_KEY = "select.faux.focus.tab.action";
    private static final I18n i18n = I18n.create(SSideBarTabBar.class);
    private Map<Object, SSideBarTab> tabs = new LinkedHashMap<Object, SSideBarTab>();
    private MouseListener tabListener;
    private SingleSelectionModel model;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private List<ChangeListener> fauxFocusListeners = new ArrayList<ChangeListener>();
    private int fauxFocusIndex = -1;

    public SSideBarTabBar() {
        this.setVisible(false);
        OverflowButton overflowButton = new OverflowButton();
        this.add(overflowButton);
        OverflowLayout l = new OverflowLayout(overflowButton);
        l.setOverflowPadding(4);
        this.setLayout(l);
        this.setModel(new DefaultSingleSelectionModel());
        this.tabListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SSideBarTab tab = (SSideBarTab)e.getComponent();
                SSideBarTabBar.this.setSelectedTab(tab.getID());
            }
        };
        this.setFocusable(true);
        this.addFocusListener(this);
        this.registerKeyBindings();
        this.updateUI();
    }

    private void registerKeyBindings() {
        InputMap imap = this.getInputMap(0);
        ActionMap amap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(37, 0);
        imap.put(keyStroke, PREV_FAUX_FOCUS_ACTION_KEY);
        amap.put(PREV_FAUX_FOCUS_ACTION_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSideBarTabBar.this.fauxFocusIndex - 1 >= 0) {
                    --SSideBarTabBar.this.fauxFocusIndex;
                    SSideBarTabBar.this.repaint();
                    SSideBarTabBar.this.fireFauxFocusChange();
                }
            }
        });
        keyStroke = KeyStroke.getKeyStroke(39, 0);
        imap.put(keyStroke, NEXT_FAUX_FOCUS_ACTION_KEY);
        amap.put(NEXT_FAUX_FOCUS_ACTION_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSideBarTabBar.this.fauxFocusIndex + 1 < SSideBarTabBar.this.tabs.size()) {
                    ++SSideBarTabBar.this.fauxFocusIndex;
                    SSideBarTabBar.this.repaint();
                    SSideBarTabBar.this.fireFauxFocusChange();
                }
            }
        });
        keyStroke = KeyStroke.getKeyStroke(32, 0);
        imap.put(keyStroke, SELECT_FAUX_FOCUS_TAB_ACTION_KEY);
        amap.put(SELECT_FAUX_FOCUS_TAB_ACTION_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object fauxId = SSideBarTabBar.this.getFauxFocusTab();
                if (fauxId != null) {
                    SSideBarTabBar.this.setSelectedTab(fauxId);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFauxFocusChange() {
        List<ChangeListener> list = this.fauxFocusListeners;
        synchronized (list) {
            for (ChangeListener l : this.fauxFocusListeners) {
                l.stateChanged(new ChangeEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFauxFocusListener(ChangeListener l) {
        if (l == null) {
            return;
        }
        List<ChangeListener> list = this.fauxFocusListeners;
        synchronized (list) {
            this.fauxFocusListeners.remove(l);
            this.fauxFocusListeners.add(l);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel model) {
        SingleSelectionModel old = this.getModel();
        if (old != null) {
            old.removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        this.model = model;
        if (model != null) {
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SSideBarTabBar.this.repaint();
                    SSideBarTabBar.this.fireStateChanged();
                }
            };
            model.addChangeListener(this.changeListener);
        }
        this.firePropertyChange("model", old, model);
        this.repaint();
    }

    public void addTab(Object id, Icon icon, String name, String tooltip) {
        SSideBarTab tab = new SSideBarTab(id, name, icon);
        tab.setToolTipText(tooltip);
        tab.addMouseListener(this.tabListener);
        this.tabs.put(id, tab);
        if (this.model.getSelectedIndex() == -1) {
            this.model.setSelectedIndex(this.tabs.size() - 1);
        }
        this.add(tab);
        this.setVisible(this.tabs.size() > 1);
        this.revalidate();
        this.repaint();
    }

    public void removeTab(Object id) {
        SSideBarTab tab = this.tabs.get(id);
        if (tab == null) {
            return;
        }
        int index = this.getTabIndex(id);
        tab.removeMouseListener(this.tabListener);
        this.tabs.remove(id);
        if (this.model.getSelectedIndex() >= index) {
            if (index >= this.tabs.size()) {
                this.model.setSelectedIndex(this.tabs.size() - 1);
            } else {
                this.model.setSelectedIndex(this.model.getSelectedIndex() - 1);
            }
        }
        this.remove(tab);
        this.setVisible(this.tabs.size() > 1);
        this.revalidate();
        this.repaint();
    }

    public void setSelectedTab(Object id) {
        if (this.tabs.get(id) == null) {
            return;
        }
        int i = 0;
        Iterator<Object> itr = this.tabs.keySet().iterator();
        while (itr.hasNext()) {
            if (itr.next().equals(id)) {
                this.model.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.repaint();
    }

    public Object getSelectedTab() {
        int index = this.model.getSelectedIndex();
        int i = 0;
        for (Object id : this.tabs.keySet()) {
            if (i == index) {
                return id;
            }
            ++i;
        }
        return null;
    }

    public JComponent getTabComponent(Object id) {
        return this.tabs.get(id);
    }

    private int getTabIndex(Object id) {
        int index = 0;
        Iterator<Object> itr = this.tabs.keySet().iterator();
        while (itr.hasNext()) {
            if (itr.next().equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Icon getTabIcon(Object id) {
        SSideBarTab tab = this.tabs.get(id);
        if (tab == null) {
            return null;
        }
        return tab.getIcon();
    }

    public void setTabIcon(Object id, Icon icon) {
        SSideBarTab tab = this.tabs.get(id);
        if (tab == null) {
            return;
        }
        tab.setIcon(icon);
    }

    public String getTabText(Object id) {
        SSideBarTab tab = this.tabs.get(id);
        if (tab == null) {
            return null;
        }
        return tab.getText();
    }

    public void setTabText(Object id, String text) {
        SSideBarTab tab = this.tabs.get(id);
        if (tab == null) {
            return;
        }
        tab.setText(text);
    }

    public boolean isTabCloseable(Object id) {
        SSideBarTab tab = this.tabs.get(id);
        if (tab == null) {
            return false;
        }
        return tab.isCloseable();
    }

    public void setTabCloseable(Object id, boolean closeable) {
        SSideBarTab tab = this.tabs.get(id);
        if (tab == null) {
            return;
        }
        tab.setCloseable(closeable);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] ls = this.listenerList.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)ls[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public Object getFauxFocusTab() {
        Iterator<Object> itr = this.tabs.keySet().iterator();
        int i = 0;
        while (itr.hasNext()) {
            Object id = itr.next();
            if (i == this.fauxFocusIndex) {
                return id;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.fauxFocusIndex = this.model.getSelectedIndex();
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.fauxFocusIndex = -1;
        this.repaint();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSSideBarTabBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSSideBarTabBar
    extends JComponent.AccessibleJComponent
    implements ChangeListener {
        public AccessibleSSideBarTabBar() {
            super(SSideBarTabBar.this);
            SSideBarTabBar.this.addFauxFocusListener(this);
            String fauxTabName = this.getNameFromCurrentFauxTab();
            if (fauxTabName != null) {
                this.updateAccessibleDetails();
            }
        }

        @Override
        public String getAccessibleName() {
            this.updateAccessibleName();
            return super.getAccessibleName();
        }

        @Override
        public String getAccessibleDescription() {
            this.updateAccessibleDescription();
            return super.getAccessibleDescription();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.firePropertyChange("AccessibleSelection", null, null);
            this.updateAccessibleDetails();
        }

        private void updateAccessibleDetails() {
            this.updateAccessibleName();
            this.updateAccessibleDescription();
        }

        private void updateAccessibleName() {
            String name = this.getNameFromCurrentFauxTab();
            if (name != null) {
                if (this.isSelected()) {
                    this.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTABBAR_AX_NAME_SELECTED, new Object[]{name}));
                } else {
                    this.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTABBAR_AX_NAME_NOTSELECTED, new Object[]{name}));
                }
            }
        }

        private void updateAccessibleDescription() {
            String name = this.getNameFromCurrentFauxTab();
            if (name != null) {
                if (this.isSelected()) {
                    this.setAccessibleDescription(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTABBAR_AX_DESC_SELECTED, new Object[]{name}));
                } else {
                    this.setAccessibleDescription(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTABBAR_AX_DESC_NOTSELECTED, new Object[]{name}));
                }
            }
        }

        private String getNameFromCurrentFauxTab() {
            Object fauxFocusTab = SSideBarTabBar.this.getFauxFocusTab();
            if (fauxFocusTab == null) {
                return null;
            }
            return fauxFocusTab.toString();
        }

        private boolean isSelected() {
            int selectedIndex;
            int fauxIndex = SSideBarTabBar.this.fauxFocusIndex;
            return fauxIndex == (selectedIndex = SSideBarTabBar.this.getModel().getSelectedIndex());
        }
    }

    private static class OverflowButton
    extends SMenuButton
    implements ActionListener {
        private Map<JRadioButtonMenuItem, SSideBarTab> tabs = new HashMap<JRadioButtonMenuItem, SSideBarTab>();

        public OverflowButton() {
            super(UIManager.getIcon("SideBar.tabOverflowIcon"));
            this.setArrowPainted(false);
            this.setPreferredSize(new Dimension(16, 16));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setContentAreaFilled(false);
            this.getAccessibleContext().setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTABBAR_OVERFLOW_AX_NAME));
        }

        @Override
        protected void showMenu() {
            for (Component c : this.menu.getComponents()) {
                ((JRadioButtonMenuItem)c).removeActionListener(this);
            }
            this.menu.removeAll();
            this.tabs.clear();
            SSideBarTabBar tb = (SSideBarTabBar)this.getParent();
            JComponent selectedTab = tb.getTabComponent(tb.getSelectedTab());
            ButtonGroup grp = new ButtonGroup();
            for (Component c : tb.getComponents()) {
                if (!(c instanceof SSideBarTab) || c.getWidth() != 0) continue;
                SSideBarTab tab = (SSideBarTab)c;
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(tab.getText(), tab.getIcon(), tab == selectedTab);
                mi.addActionListener(this);
                grp.add(mi);
                this.tabs.put(mi, tab);
                this.menu.add(mi);
            }
            this.menu.show(this, this.getWidth(), 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)e.getSource();
            SSideBarTabBar tb = (SSideBarTabBar)this.getParent();
            tb.setSelectedTab(this.tabs.get(mi).getID());
        }
    }
}

