/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.DockingAdapter;
import com.elluminate.classroom.swing.components.MenuButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SMenuButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class SNavigationPanel
extends JComponent
implements Accessible {
    private static final String uiClassID = "SNavigationPanelUI";
    private String title;
    protected JPanel topBar;
    private JToggleButton expandButton;
    private JPanel barPane;
    protected SMenuButton optionsButton;
    private JPanel contentPane;
    private ComponentListener optionListener;
    private Font optionsFont;
    private boolean expanded = false;
    private DockingAdapter docker;

    public SNavigationPanel() {
        this.setLayout(new BorderLayout());
        this.topBar = new JPanel(new BorderLayout(4, 0));
        this.topBar.setOpaque(false);
        this.topBar.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 4));
        this.add((Component)this.topBar, "North");
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setOpaque(false);
        this.contentPane.setVisible(false);
        this.contentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NavigationPanel.background").brighter()), BorderFactory.createEmptyBorder(2, 5, 20, 5)));
        this.add((Component)this.contentPane, "Center");
        this.docker = new DockingAdapter(this, NavigationWindow.class){

            @Override
            protected void prepareUndockedWindow(Window window) {
                if (SNavigationPanel.this.title != null) {
                    ((NavigationWindow)window).setTitle(SNavigationPanel.this.title);
                }
            }
        };
        this.docker.setUndockedLocation(new Point(800, 100));
        this.docker.setUndockedSize(new Dimension(320, 500));
        this.docker.setResizeOnUndock(true);
        this.docker.addPropertyChangeListener("docked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean old = (Boolean)e.getOldValue();
                boolean docked = (Boolean)e.getNewValue();
                SNavigationPanel.this.setExpanded(!docked);
                SNavigationPanel.this.firePropertyChange("docked", old, docked);
            }
        });
        this.addMouseListener(this.docker);
        this.addMouseMotionListener(this.docker);
        this.expandButton = new JToggleButton();
        this.expandButton.setIcon(UIManager.getIcon("SideBar.collapsedIcon"));
        this.expandButton.setSelectedIcon(UIManager.getIcon("SideBar.expandedIcon"));
        this.expandButton.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.setVisible(false);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SNavigationPanel.this.setExpanded(SNavigationPanel.this.expandButton.isSelected());
            }
        });
        this.topBar.add((Component)this.expandButton, "West");
        this.barPane = new JPanel(new BorderLayout());
        this.barPane.setOpaque(false);
        this.topBar.add((Component)this.barPane, "Center");
        this.optionsButton = new SMenuButton();
        this.optionsButton.setVisible(false);
        this.optionsButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.optionsButton.setIcon(UIManager.getIcon("ActionBar.optionsIcon"));
        this.optionsButton.setSelectedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setPressedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setRolloverIcon(UIManager.getIcon("ActionBar.optionsRolloverIcon"));
        this.optionsButton.setRolloverSelectedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setContentAreaFilled(false);
        this.optionsButton.setArrowPainted(false);
        MenuButtonFocusDisplayer fd = new MenuButtonFocusDisplayer();
        this.optionsButton.addFocusListener(fd);
        this.optionsButton.getMenu().addPopupMenuListener(fd);
        this.optionsButton.getMenu().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                c.setFont(SNavigationPanel.this.optionsFont);
                c.addComponentListener(SNavigationPanel.this.optionListener);
                if (c.isVisible()) {
                    SNavigationPanel.this.optionsButton.setVisible(true);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                c.removeComponentListener(SNavigationPanel.this.optionListener);
                if (!SNavigationPanel.this.hasVisibleOptions()) {
                    SNavigationPanel.this.optionsButton.setVisible(false);
                }
            }
        });
        this.topBar.add((Component)this.optionsButton, "East");
        this.optionListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SNavigationPanel.this.optionsButton.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (!SNavigationPanel.this.hasVisibleOptions()) {
                    SNavigationPanel.this.optionsButton.setVisible(false);
                }
            }
        };
        this.setupOptionsMenuKeyBinding();
        Font f = UIManager.getFont("PopupMenu.font");
        this.optionsFont = f.deriveFont((float)(f.getSize() * 11 / 12));
        this.updateUI();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JPopupMenu getOptionsMenu() {
        return this.optionsButton.getMenu();
    }

    private void setupOptionsMenuKeyBinding() {
        KeyStroke optionsKeystroke = this.getOptionsKeystroke();
        String actionName = "open.options.menu." + this.hashCode();
        this.getInputMap(1).put(optionsKeystroke, actionName);
        this.getActionMap().put(actionName, new AbstractAction(actionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                SNavigationPanel.this.optionsButton.doClick();
            }
        });
    }

    private KeyStroke getOptionsKeystroke() {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(79, mask | 0x40);
    }

    private boolean hasVisibleOptions() {
        for (Component c : this.optionsButton.getMenu().getComponents()) {
            if (!c.isVisible()) continue;
            return true;
        }
        return false;
    }

    private boolean isExpandable() {
        return this.getContentPane().getComponentCount() != 0 && !this.isDocked();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (expanded && !this.isExpandable()) {
            return;
        }
        boolean old = this.expanded;
        this.expanded = expanded;
        this.firePropertyChange("expanded", old, expanded);
        this.setContentVisible(expanded);
        this.revalidate();
    }

    public Container getBarPane() {
        return this.barPane;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    protected void setContentVisible(boolean contentVisible) {
        this.contentPane.setVisible(contentVisible);
    }

    public boolean canUndock() {
        return this.docker.isEnabled();
    }

    public void setCanUndock(boolean canUndock) {
        this.docker.setEnabled(canUndock);
        if (!canUndock && !this.isDocked()) {
            this.setDocked(true);
        }
    }

    public boolean isDocked() {
        return this.docker.isDocked();
    }

    public void setDocked(boolean docked) {
        this.docker.setDocked(docked);
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSSNavigationPanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSSNavigationPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleSSNavigationPanel() {
            super(SNavigationPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static class NavigationWindow
    extends JDialog {
        public NavigationWindow(Frame owner) {
            super(owner);
            this.getRootPane().putClientProperty("Window.style", "small");
        }

        @Override
        public boolean getFocusableWindowState() {
            Object bypass = this.getRootPane().getClientProperty("DockingAdapter.bypassFocusableWindowState");
            if (bypass instanceof Boolean) {
                return (Boolean)bypass;
            }
            return super.getFocusableWindowState();
        }
    }
}

