/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.chat;

import com.elluminate.util.SwingRunnerSupport;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

class AxJEditorPane
extends JEditorPane
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private final Object lock = new Object();
    private int oldCaretPosition = -1;

    public AxJEditorPane() {
        this.addKeyListener(this);
    }

    @Override
    protected void fireCaretUpdate(CaretEvent e) {
        this.updateCaretPosition(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaretPosition(CaretEvent e) {
        Object object = this.lock;
        synchronized (object) {
            int suggestedPosition;
            this.oldCaretPosition = suggestedPosition = e.getDot();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        try {
            Document doc = this.getDocument();
            HTMLDocument htmlDoc = (HTMLDocument)doc;
            String text = doc.getText(0, this.oldCaretPosition);
            int indexOfStartOfCurrString = text.lastIndexOf("\n") + 1;
            Element characterElement = htmlDoc.getCharacterElement(indexOfStartOfCurrString);
            int posInRow = this.oldCaretPosition - indexOfStartOfCurrString;
            switch (keyCode) {
                case 38: {
                    this.moveCaretToAdjecentRowContent(htmlDoc, characterElement, false, posInRow);
                    break;
                }
                case 40: {
                    this.moveCaretToAdjecentRowContent(htmlDoc, characterElement, true, posInRow);
                    break;
                }
                case 37: {
                    break;
                }
            }
        }
        catch (BadLocationException e1) {
            System.out.println("suggested position greater than the size of the document, not to worry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void moveCaretToAdjecentRowContent(HTMLDocument htmlDoc, Element findElement, boolean shiftDown, int posInRow) throws BadLocationException {
        it = new ElementIterator(htmlDoc);
        newCaretPosition = this.oldCaretPosition;
        prevRow = null;
        currRow = null;
        var10_9 = this.lock;
        synchronized (var10_9) lbl-1000:
        // 3 sources

        {
            while ((element = it.next()) != null) {
                block8: {
                    childAttributes = element.getAttributes();
                    if (childAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TR || childAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.DIV) {
                        prevRow = currRow;
                        currRow = element;
                        continue;
                    }
                    if (childAttributes.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT || !element.equals(findElement)) continue;
                    if (!shiftDown) break block8;
                    while ((element = it.next()) != null) {
                        childAttributes = element.getAttributes();
                        if (childAttributes.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.TR && childAttributes.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.DIV) continue;
                        while ((element = it.next()) != null) {
                            childAttributes = element.getAttributes();
                            if (childAttributes.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT) continue;
                            newCaretPosition = element.getStartOffset();
                            newCaretPosition = this.getDocument().getText(newCaretPosition, posInRow).indexOf("\n") == -1 ? (newCaretPosition += posInRow) : (newCaretPosition += this.getDocument().getText(newCaretPosition, posInRow).indexOf("\n"));
                            this.oldCaretPosition = newCaretPosition;
                            this.moveCaret(shiftDown, newCaretPosition);
                            return;
                        }
                    }
                    ** GOTO lbl-1000
                }
                if (prevRow == null) continue;
                currRowIterator = new ElementIterator(prevRow);
                while ((currElement = currRowIterator.next()) != null) {
                    childAttributes = currElement.getAttributes();
                    if (childAttributes.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT) continue;
                    newCaretPosition = currElement.getStartOffset();
                    newCaretPosition = this.getDocument().getText(newCaretPosition, posInRow).indexOf("\n") == -1 ? (newCaretPosition += posInRow) : (newCaretPosition += this.getDocument().getText(newCaretPosition, posInRow).indexOf("\n"));
                    this.oldCaretPosition = newCaretPosition;
                    this.moveCaret(shiftDown, newCaretPosition);
                    return;
                }
                ** GOTO lbl-1000
            }
        }
    }

    private void moveCaret(boolean toTheRight, CaretEvent e) {
        int newPosition = e.getDot();
        this.moveCaret(toTheRight, newPosition);
    }

    private void moveCaret(boolean toTheRight, int newPosition) {
        if (newPosition >= this.getDocument().getLength()) {
            newPosition = this.getDocument().getLength() - 1;
        }
        if (newPosition < 0) {
            newPosition = 0;
        }
        final int finalPosition = newPosition;
        if (this.getDocument() != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AxJEditorPane.this.getCaret().setDot(finalPosition);
                }
            });
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new ModifiedAccessibleJEditorPaneHTML() : super.getAccessibleContext();
        }
        return this.accessibleContext;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Object a;
        JEditorPane source = (JEditorPane)event.getSource();
        Point pt = new Point(event.getX(), event.getY());
        int pos = source.viewToModel(pt);
        Document doc = this.getDocument();
        HTMLDocument htmlDoc = (HTMLDocument)doc;
        Element characterElement = htmlDoc.getCharacterElement(pos);
        AttributeSet attributes = characterElement.getAttributes();
        if (attributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT && (a = attributes.getAttribute(HTML.Tag.SPAN)) != null) {
            SimpleAttributeSet sas = (SimpleAttributeSet)a;
            Object classAttribute = sas.getAttribute(HTML.Attribute.CLASS);
            Object valueAtribute = sas.getAttribute(HTML.Attribute.ALT);
            if (classAttribute != null && classAttribute.equals("tooltip") && valueAtribute != null) {
                return (String)valueAtribute;
            }
        }
        return super.getToolTipText(event);
    }

    class ModifiedAccessibleJEditorPaneHTML
    extends JEditorPane.AccessibleJEditorPaneHTML {
        private static final long serialVersionUID = 1L;
        private JEditorPane.JEditorPaneAccessibleHypertextSupport textSupport;

        ModifiedAccessibleJEditorPaneHTML() {
            super(AxJEditorPane.this);
            this.textSupport = null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (this.textSupport != null) {
                return this.textSupport;
            }
            this.textSupport = new JEditorPane.JEditorPaneAccessibleHypertextSupport(AxJEditorPane.this);
            return this.textSupport;
        }
    }
}

