/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.caption;

import com.elluminate.classroom.swing.caption.CaptionWindowModel;
import com.elluminate.classroom.swing.caption.StringsProperties;
import com.elluminate.gui.FontUtils;
import com.elluminate.gui.component.PopupColorPicker;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CaptionFGToolPanel
extends JPanel {
    private static final Dimension BUTTON_SIZE = new Dimension(20, 20);
    private static final Color NO_COLOR = null;
    private I18n i18n = I18n.create(CaptionFGToolPanel.class);
    private static final int[] fontSizes = new int[]{8, 9, 10, 11, 12, 14, 18, 24, 36, 48, 72};
    private static final String[] fontFamilyNames = FontUtils.getFontNames();
    private JLabel textLabel;
    private JComboBox textFontFamily;
    private JComboBox textFontSize;
    private PopupColorPicker colorPicker;
    private CaptionWindowModel windowModel;

    @Inject
    public CaptionFGToolPanel() {
        this.setupUI();
    }

    @Inject
    public void initCaptionWindowModel(CaptionWindowModel cwm) {
        this.windowModel = cwm;
        this.setupListeners();
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        if (Platform.getLAF() == 502) {
            constraints.insets.top = -1;
            constraints.insets.bottom = -2;
        } else {
            constraints.insets.top = 2;
            constraints.insets.bottom = 2;
        }
        constraints.insets.left = 2;
        constraints.insets.right = 2;
        this.textLabel = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_FOREGROUND_TEXT));
        this.textLabel.setForeground(UIManager.getColor("ShadeWindow.textColor"));
        this.add((Component)this.textLabel, constraints);
        this.textFontFamily = this.setupFontStyleComboBox();
        this.add((Component)this.textFontFamily, constraints);
        this.textFontSize = this.setupFontSizeComboBox();
        this.add((Component)this.textFontSize, constraints);
        this.colorPicker = new PopupColorPicker(BUTTON_SIZE, NO_COLOR);
        this.colorPicker.setFocusable(true);
        this.colorPicker.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_FOREGROUND_AXTEXT));
        this.colorPicker.addPropertyChangeListener("QuickColorPicker.chosenColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (ev.getNewValue() != null && ev.getNewValue() instanceof Color) {
                    CaptionFGToolPanel.this.changeFGColor((Color)ev.getNewValue());
                }
            }
        });
        this.add((Component)this.colorPicker, constraints);
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JComponent) {
            this.fontAdjustment((JComponent)comp);
        }
        return super.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof JComponent) {
            this.fontAdjustment((JComponent)comp);
        }
        super.add(comp, constraints);
    }

    private void fontAdjustment(JComponent comp) {
        Font btnFont = UIManager.getFont("Button.font");
        Font font = btnFont.deriveFont((float)btnFont.getSize() * 11.0f / 12.0f);
        comp.setFont(font);
        if (Platform.getLAF() == 502) {
            comp.putClientProperty("JComponent.sizeVariant", "small");
        }
    }

    private JComboBox setupFontSizeComboBox() {
        String[] textSizes = this.populateSizes();
        JComboBox<String> cbo = new JComboBox<String>(textSizes);
        cbo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String size = (String)cb.getSelectedItem();
                CaptionFGToolPanel.this.changeFontSize(Integer.valueOf(size));
            }
        });
        return cbo;
    }

    private String[] populateSizes() {
        String[] sizes = new String[fontSizes.length];
        for (int i = 0; i < fontSizes.length; ++i) {
            sizes[i] = Integer.toString(fontSizes[i]);
        }
        return sizes;
    }

    private void changeFontSize(int size) {
        String selectedSize = (String)this.textFontSize.getSelectedItem();
        if (selectedSize == null || !Integer.valueOf(selectedSize).equals(size)) {
            this.textFontSize.setSelectedItem(Integer.toString(size));
        }
        this.windowModel.setFontSize(size);
    }

    private JComboBox setupFontStyleComboBox() {
        JComboBox<String> cbo = new JComboBox<String>(fontFamilyNames);
        cbo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String font = (String)cb.getSelectedItem();
                CaptionFGToolPanel.this.changeFontFamily(font);
            }
        });
        return cbo;
    }

    private void changeFontFamily(String fontFamily) {
        String selectedStyle = (String)this.textFontFamily.getSelectedItem();
        if (selectedStyle == null || !selectedStyle.equals(fontFamily)) {
            this.textFontFamily.setSelectedItem(fontFamily);
        }
        this.windowModel.setFontFamily(fontFamily);
    }

    private void changeFGColor(Color color) {
        if (this.colorPicker.getColor() == null || !this.colorPicker.getColor().equals(color)) {
            this.colorPicker.setColor(color);
        }
        this.windowModel.setFgColor(color);
    }

    private void setupListeners() {
        this.windowModel.addPropertyChangeListener("Caption.fgcolor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Color) {
                    CaptionFGToolPanel.this.changeFGColor((Color)evt.getNewValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fontsize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Integer) {
                    CaptionFGToolPanel.this.changeFontSize((Integer)evt.getNewValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fontfamily", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof String) {
                    CaptionFGToolPanel.this.changeFontFamily((String)evt.getNewValue());
                }
            }
        });
    }
}

