/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.gui.component.MarqueeScroller;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.VersionManager;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class SplashContentPane
extends JPanel {
    public static final int LOADING_STEP = 5;
    public static final Color BACKGROUND = new Color(96, 96, 98);
    public static final Color FONT_LABEL_COLOR = new Color(129, 129, 129);
    public static final Color FONT_COLOR = new Color(229, 229, 229);
    public static final Color PURPLE = new Color(120, 35, 144);
    private VersionManager versionManager;
    protected JLabel progressLabel;
    protected JPanel left;
    protected JPanel right;
    public JButton button;
    I18n branding;

    @Inject
    public SplashContentPane(VersionManager versionManager, BrandingI18nProvider brandingProvider) {
        this.versionManager = versionManager;
        this.branding = brandingProvider.get();
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(583, 280));
        this.left = new LeftPanel();
        this.right = new RightPanel();
        this.add((Component)this.left, "West");
        this.add((Component)this.right, "East");
    }

    public void setInitialFocus() {
    }

    class LeftPanel
    extends JPanel {
        public LeftPanel() {
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(254, 250));
            this.setBackground(Color.WHITE);
            JLabel top = new JLabel("Version " + SplashContentPane.this.versionManager.getProductVer(), SplashContentPane.this.branding.getIcon((PropertiesEnum)BrandingI18nProvider.Values.SPLASH_LOGO_LH), 0);
            top.setBorder(BorderFactory.createEmptyBorder(17, 10, 0, 0));
            top.setLayout(new BorderLayout());
            top.setSize(new Dimension(254, 90));
            top.setOpaque(false);
            top.setIconTextGap(10);
            top.setVerticalTextPosition(3);
            top.setHorizontalTextPosition(0);
            top.setFont(new Font("Arial", 0, 11));
            top.setForeground(FONT_LABEL_COLOR);
            this.add((Component)top, "North");
        }
    }

    class RightPanel
    extends JPanel {
        public RightPanel() {
            this.setLayout(new BorderLayout());
            this.setBackground(BACKGROUND);
            Dimension minDimension = new Dimension(322, 100);
            this.setPreferredSize(new Dimension(332, 100));
            JLabel rectangle = new JLabel();
            rectangle.setOpaque(true);
            rectangle.setBackground(PURPLE);
            rectangle.setPreferredSize(new Dimension(100, 15));
            JPanel rectangle_holder = new JPanel(new FlowLayout(3, 0, 0));
            rectangle_holder.add(rectangle);
            rectangle_holder.setOpaque(false);
            JLabel picLabel = new JLabel(SplashContentPane.this.branding.getIcon((PropertiesEnum)BrandingI18nProvider.Values.SPLASH_LOGO_RH));
            picLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            JTextArea copy = new JTextArea(SplashContentPane.this.versionManager.getHtmlCopyrights());
            copy.getAccessibleContext().setAccessibleName("");
            copy.getAccessibleContext().setAccessibleDescription("");
            copy.setPreferredSize(minDimension);
            copy.setSize(minDimension);
            try {
                Rectangle r = copy.modelToView(copy.getDocument().getLength());
                int hFactor = 0;
                if (r.y >= r.height) {
                    hFactor = 220;
                }
                Dimension d = new Dimension(minDimension.width, r.y + r.height + hFactor);
                copy.setPreferredSize(d);
            }
            catch (BadLocationException e) {
                LogSupport.message((Object)this, (String)"after modelToView ", (String)Debug.getStackTrace((Throwable)e));
            }
            copy.setFont(new Font("Arial", 0, 10));
            copy.setForeground(FONT_COLOR);
            copy.setEditable(false);
            copy.setWrapStyleWord(true);
            copy.setLineWrap(true);
            copy.setOpaque(true);
            copy.setBackground(BACKGROUND);
            MarqueeScroller scroller = new MarqueeScroller();
            scroller.setScrollOrientationHorizontal(false);
            scroller.setScrollingContent((JComponent)copy);
            scroller.setPreferredSize(new Dimension(320, 160));
            scroller.setOpaque(true);
            scroller.setBackground(BACKGROUND);
            scroller.setBorder(BorderFactory.createEmptyBorder(25, 0, 15, 0));
            copy.setBorder(BorderFactory.createEmptyBorder(0, 22, 30, 20));
            this.add((Component)rectangle_holder, "North");
            this.add((Component)picLabel, "Center");
            this.add((Component)scroller, "South");
        }
    }
}

