/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import java.awt.Rectangle;

public class RectDistance {
    public int dx;
    public int dy;
    public int delta;

    public RectDistance(Rectangle inner, Rectangle outer) {
        this.dx = this.getDelta(inner.x, inner.width, outer.x, outer.width);
        this.dy = this.getDelta(inner.y, inner.height, outer.y, outer.height);
    }

    private boolean adjustAxis(int iMin, int iSpan, int oMin, int oSpan) {
        return iMin < oMin || iMin + iSpan > oMin + oSpan;
    }

    private int getDelta(int iMin, int iSpan, int oMin, int oSpan) {
        if (this.adjustAxis(iMin, iSpan, oMin, oSpan)) {
            if (iSpan > oSpan) {
                return 9999999;
            }
            if (iMin < oMin) {
                return oMin - iMin;
            }
            return oMin + oSpan - (iMin + iSpan);
        }
        return 0;
    }

    public int getDistance() {
        if (this.delta > 0) {
            return this.delta;
        }
        this.delta = (int)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        return this.delta;
    }

    public RectDistance nearer(RectDistance other) {
        if (other == null) {
            return this;
        }
        if (other.getDistance() > this.getDistance()) {
            return this;
        }
        return other;
    }

    public void apply(Rectangle r) {
        r.translate(this.dx, this.dy);
    }
}

