/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.platform.Platform;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;

public class NullableActionSButton
extends SButton {
    private final Object lock = new Object();
    private Icon origIcon;
    private Icon grayIcon;
    private List<ActionListener> listeners;
    private boolean actionsEnabled = true;
    private boolean inTransition = false;
    private Color enabledTextColor;
    private Color disabledTextColor;

    @Override
    public void setEnabled(boolean b) {
        this.setActionEnabled(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActionEnabled(boolean enabled) {
        if (this.actionsEnabled == enabled) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.inTransition = true;
                this.actionsEnabled = enabled;
                if (enabled) {
                    this.enableActions();
                    this.restoreIcon();
                    this.restoreText();
                } else {
                    this.disableActions();
                    this.greyOutIcon();
                    this.greyOutText();
                }
            }
            finally {
                this.inTransition = false;
            }
        }
    }

    private void greyOutText() {
        this.enabledTextColor = this.getForeground();
        if (this.disabledTextColor == null) {
            this.disabledTextColor = 202 == Platform.getOS() ? new Color(UIManager.getColor("Button.disabledText").getRGB()) : (300 == Platform.getOS() ? new Color(UIManager.getColor("Button.light").getRGB()) : new Color(UIManager.getColor("Button.disabledForeground").getRGB()));
        }
        this.setForeground(this.disabledTextColor);
        this.repaint();
    }

    private void restoreText() {
        this.setForeground(this.enabledTextColor);
        this.repaint();
    }

    private void enableActions() {
        ArrayList<ActionListener> working = new ArrayList<ActionListener>(this.listeners);
        if (working != null) {
            for (ActionListener listener : working) {
                this.addActionListener(listener);
            }
        }
        this.listeners = null;
    }

    private void disableActions() {
        this.listeners = new ArrayList<EventListener>(Arrays.asList(this.getListeners(ActionListener.class)));
        ArrayList<ActionListener> working = new ArrayList<ActionListener>(this.listeners);
        if (working != null) {
            for (ActionListener listener : working) {
                this.removeActionListener(listener);
            }
        }
    }

    private void greyOutIcon() {
        if (this.grayIcon == null) {
            this.grayIcon = this.getDisabledIcon();
        }
        if (this.grayIcon != null) {
            this.setIcon(this.grayIcon);
        }
        this.repaint();
    }

    private void restoreIcon() {
        if (this.origIcon != null) {
            this.setIcon(this.origIcon);
        }
        this.repaint();
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        if (this.origIcon != null) {
            if (this.grayIcon != null) {
                if (this.grayIcon != defaultIcon && this.origIcon != defaultIcon) {
                    this.grayIcon = null;
                    this.origIcon = defaultIcon;
                }
            } else if (this.origIcon != defaultIcon) {
                this.origIcon = defaultIcon;
            }
        } else {
            this.origIcon = defaultIcon;
        }
        super.setIcon(defaultIcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener l) {
        Object object = this.lock;
        synchronized (object) {
            if (this.actionsEnabled) {
                super.addActionListener(l);
            } else if (this.listeners != null) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener l) {
        Object object = this.lock;
        synchronized (object) {
            if (this.actionsEnabled || this.inTransition) {
                super.removeActionListener(l);
            } else if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }
    }
}

