/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.swing.AboutUIClerk;
import com.elluminate.classroom.swing.AbstractEditMenuItem;
import com.elluminate.classroom.swing.CopyMenuItem;
import com.elluminate.classroom.swing.CutMenuItem;
import com.elluminate.classroom.swing.ModeController;
import com.elluminate.classroom.swing.PasteMenuItem;
import com.elluminate.classroom.swing.PreferencesUIClerk;
import com.elluminate.classroom.swing.SelectAllMenuItem;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.framework.location.DefaultMenuHandler;
import com.elluminate.framework.location.DefaultMenuHandlerProvider;
import com.elluminate.framework.location.ParameterSource;
import com.elluminate.framework.location.SelectionParameterSource;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.gui.KeyBindingAdapter;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.DebugDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.CRadioButtonMenuItem;
import com.elluminate.gui.swing.CTable;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.platform.Platform;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.browser.BrowserUtil;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class MainMenuBar
extends JMenuBar {
    public static final String FILE_MENU_LOCATION = "menus.file";
    public static final String FILE_NEW_MENU_LOCATION = "menus.file.new";
    public static final String FILE_OPEN_MENU_LOCATION = "menus.file.open";
    public static final String FILE_SAVE_MENU_LOCATION = "menus.file.save";
    public static final String FILE_PRINT_MENU_LOCATION = "menus.file.print";
    public static final String EDIT_MENU_LOCATION = "menus.edit";
    public static final String PLAYBACK_MENU_LOCATION = "menus.playback";
    public static final String VIEW_MENU_LOCATION = "menus.view";
    public static final String TOOLS_MENU_LOCATION = "menus.tools";
    public static final String WINDOW_MENU_LOCATION = "menus.window";
    public static final String HELP_MENU_LOCATION = "menus.help";
    private PasteMenuItem pasteItem;
    private JRadioButtonMenuItem whiteboardItem;
    private JRadioButtonMenuItem screenSharingItem;
    private JRadioButtonMenuItem webTourItem;
    private JMenuItem shortcutsItem;
    private JMenuItem diagnosticsItem;
    private JMenuItem aboutMenuItem;
    private ModeController modeController;
    private DialogParentProvider parentProvider;
    private AboutUIClerk aboutClerk;
    private Window shortcutsWindow = null;
    private DebugDialog debugDialog = null;
    private Provider<KeyBindingAdapter> keyBinding;
    private DefaultMenuHandler fileMenu;
    private DefaultMenuHandler fileNewMenu;
    private DefaultMenuHandler fileOpenMenu;
    private DefaultMenuHandler fileSaveMenu;
    private DefaultMenuHandler filePrintMenu;
    private DefaultMenuHandler editMenu;
    private DefaultMenuHandler playbackMenu;
    private DefaultMenuHandler viewMenu;
    private DefaultMenuHandler windowMenu;
    private DefaultMenuHandler toolsMenu;
    private DefaultMenuHandler helpMenu;
    private I18n i18n;
    private I18n branding;
    private JMenuItem moderatorGuideItem;
    private JMenuItem additionalDocumentationItem;
    private JMenuItem participantsGuideItem;
    private CRSession session = null;
    private boolean participantIsChair = false;

    @Inject
    public MainMenuBar(DefaultMenuHandlerProvider mHandler, BrokerAdapter brokerAdapter, I18nProvider i18nProvider, SelectionParameterSource paramSrc, DialogParentProvider parentProv, AboutUIClerk aboutUIClerk, Provider<KeyBindingAdapter> keyBindingProvider, BrandingI18nProvider brandingProvider) {
        this.i18n = i18nProvider.get((Object)this);
        this.branding = brandingProvider.get();
        this.keyBinding = keyBindingProvider;
        this.parentProvider = parentProv;
        this.aboutClerk = aboutUIClerk;
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ArrayList<ParameterSource> sources = new ArrayList<ParameterSource>();
        sources.add(paramSrc.getParticipantParameterSource());
        sources.add(paramSrc.getRoomParameterSource());
        this.fileMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_FILE), FILE_MENU_LOCATION, 70, sources);
        MacFileOverrideProxy lh = Platform.getOS() == 202 ? new MacFileOverrideProxy(this.fileMenu) : this.fileMenu;
        brokerAdapter.addLocationHandler(FILE_MENU_LOCATION, (LocationHandler)lh);
        this.add(this.fileMenu.getMenu());
        this.fileNewMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_FILE_NEW), FILE_NEW_MENU_LOCATION, sources);
        this.fileNewMenu.setSorted(true);
        AbstractAction fileNewAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.showMenuDialog(MainMenuBar.this.fileNewMenu.getMenu(), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_NEW), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_NEW));
            }
        };
        ((KeyBindingAdapter)this.keyBinding.get()).bind("file.new.action", fileNewAction, "PLATFORM N");
        brokerAdapter.addLocationHandler(FILE_NEW_MENU_LOCATION, (LocationHandler)this.fileNewMenu);
        this.fileMenu.add((JMenuItem)this.fileNewMenu.getMenu(), 1.3f);
        this.fileOpenMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_FILE_OPEN), FILE_OPEN_MENU_LOCATION, sources);
        this.fileOpenMenu.setSorted(true);
        AbstractAction fileOpenAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.showMenuDialog(MainMenuBar.this.fileOpenMenu.getMenu(), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_OPEN), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_OPEN));
            }
        };
        ((KeyBindingAdapter)this.keyBinding.get()).bind("file.open.action", fileOpenAction, "PLATFORM O");
        brokerAdapter.addLocationHandler(FILE_OPEN_MENU_LOCATION, (LocationHandler)this.fileOpenMenu);
        this.fileMenu.add((JMenuItem)this.fileOpenMenu.getMenu(), 1.6f);
        this.fileSaveMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_FILE_SAVE), FILE_SAVE_MENU_LOCATION, sources);
        this.fileSaveMenu.setSorted(true);
        AbstractAction fileSaveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.showMenuDialog(MainMenuBar.this.fileSaveMenu.getMenu(), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_SAVE), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_SAVE));
            }
        };
        ((KeyBindingAdapter)this.keyBinding.get()).bind("file.save.action", fileSaveAction, "PLATFORM S");
        brokerAdapter.addLocationHandler(FILE_SAVE_MENU_LOCATION, (LocationHandler)this.fileSaveMenu);
        this.fileMenu.add((JMenuItem)this.fileSaveMenu.getMenu(), 3.5f);
        this.filePrintMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_FILE_PRINT), FILE_PRINT_MENU_LOCATION, sources);
        this.filePrintMenu.setSorted(true);
        AbstractAction filePrintAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.showMenuDialog(MainMenuBar.this.filePrintMenu.getMenu(), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_PRINT), MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_BUTTON_PRINT));
            }
        };
        ((KeyBindingAdapter)this.keyBinding.get()).bind("file.print.action", filePrintAction, "PLATFORM P");
        brokerAdapter.addLocationHandler(FILE_PRINT_MENU_LOCATION, (LocationHandler)this.filePrintMenu);
        this.fileMenu.add((JMenuItem)this.filePrintMenu.getMenu(), 5.5f);
        this.editMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_EDIT), EDIT_MENU_LOCATION, 69, sources);
        brokerAdapter.addLocationHandler(EDIT_MENU_LOCATION, (LocationHandler)this.editMenu);
        this.add(this.editMenu.getMenu());
        AbstractEditMenuItem mi = new CutMenuItem(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                if (Platform.getOS() != 202) {
                    MainMenuBar.this.pasteItem.adjustEnabled();
                }
            }
        };
        mi.setText(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_EDIT_CUT));
        mi.setAccelerator(KeyStroke.getKeyStroke(88, mask));
        this.editMenu.add((JMenuItem)mi, 4.3f);
        mi = new CopyMenuItem(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                if (Platform.getOS() != 202) {
                    MainMenuBar.this.pasteItem.adjustEnabled();
                }
            }
        };
        mi.setText(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_EDIT_COPY));
        mi.setAccelerator(KeyStroke.getKeyStroke(67, mask));
        this.editMenu.add((JMenuItem)mi, 4.4f);
        this.pasteItem = new PasteMenuItem();
        this.pasteItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_EDIT_PASTE));
        this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, mask));
        this.editMenu.add((JMenuItem)this.pasteItem, 4.5f);
        mi = new SelectAllMenuItem();
        mi.setText(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_EDIT_SELECTALL));
        mi.setAccelerator(KeyStroke.getKeyStroke(65, mask));
        this.editMenu.add((JMenuItem)mi, 4.6f);
        this.viewMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_VIEW), VIEW_MENU_LOCATION, 86);
        brokerAdapter.addLocationHandler(VIEW_MENU_LOCATION, (LocationHandler)this.viewMenu);
        this.add(this.viewMenu.getMenu());
        ButtonGroup grp = new ButtonGroup();
        this.whiteboardItem = new CRadioButtonMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_VIEW_WHITEBOARD), true);
        this.whiteboardItem.setAccelerator(KeyStroke.getKeyStroke(87, mask | 0x200));
        grp.add(this.whiteboardItem);
        this.whiteboardItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                MainMenuBar.this.modeController.setMode(ViewMode.WHITEBOARD);
            }
        });
        this.screenSharingItem = new CRadioButtonMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_VIEW_SCREENSHARE));
        grp.add(this.screenSharingItem);
        this.screenSharingItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                MainMenuBar.this.modeController.setMode(ViewMode.APPSHARE);
            }
        });
        this.webTourItem = new CRadioButtonMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_VIEW_WEBTOuR));
        this.webTourItem.setAccelerator(KeyStroke.getKeyStroke(85, mask | 0x200));
        grp.add(this.webTourItem);
        this.webTourItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                MainMenuBar.this.modeController.setMode(ViewMode.WEBTOUR);
            }
        });
        this.whiteboardItem.setEnabled(false);
        this.screenSharingItem.setEnabled(false);
        this.webTourItem.setEnabled(false);
        this.playbackMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_PLAYBACK), PLAYBACK_MENU_LOCATION, 80);
        brokerAdapter.addLocationHandler(PLAYBACK_MENU_LOCATION, (LocationHandler)this.playbackMenu);
        this.add(this.playbackMenu.getMenu());
        this.toolsMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_TOOLS), TOOLS_MENU_LOCATION, 84, sources);
        this.toolsMenu.setSorted(true);
        brokerAdapter.addLocationHandler(TOOLS_MENU_LOCATION, (LocationHandler)this.toolsMenu);
        this.add(this.toolsMenu.getMenu());
        this.windowMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_WINDOW), WINDOW_MENU_LOCATION, 87, sources);
        this.windowMenu.setSorted(true);
        brokerAdapter.addLocationHandler(WINDOW_MENU_LOCATION, (LocationHandler)this.windowMenu);
        this.add(this.windowMenu.getMenu());
        this.helpMenu = mHandler.get(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_HELP), HELP_MENU_LOCATION, sources);
        brokerAdapter.addLocationHandler(HELP_MENU_LOCATION, (LocationHandler)this.helpMenu);
        this.add(this.helpMenu.getMenu());
        this.shortcutsItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_HELP_SHORTCUS));
        this.shortcutsItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                MainMenuBar.this.showShortcutsWindow();
            }
        });
        this.helpMenu.add(this.shortcutsItem, 2.5f);
        String appName = this.branding.getString((PropertiesEnum)BrandingI18nProvider.Values.APP_NAME);
        this.moderatorGuideItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_HELP_ESSENTIALS_MODERATOR, new Object[]{appName}));
        this.moderatorGuideItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                String url = MainMenuBar.this.branding.getString((PropertiesEnum)BrandingI18nProvider.Values.ESSENTIALS_MODERATOR_URL);
                try {
                    BrowserUtil.gotoURL((String)url);
                }
                catch (IOException ex) {
                    ModalDialog.showMessageDialog((Component)MainMenuBar.this.parentProvider.getDialogParent(), (Object)MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_CANTOPENONLINEHELPMSG, new Object[]{url, ex.getMessage()}), (String)MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_CANTOPENONLINEHELPTITLE), (int)0);
                }
            }
        });
        this.helpMenu.add(this.moderatorGuideItem, 2.7f);
        this.participantsGuideItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_HELP_ESSENTIALS_PARTICIPANTS, new Object[]{appName}));
        this.participantsGuideItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                String url = MainMenuBar.this.branding.getString((PropertiesEnum)BrandingI18nProvider.Values.ESSENTIALS_PARTICIPANTS_URL);
                try {
                    BrowserUtil.gotoURL((String)url);
                }
                catch (IOException ex) {
                    ModalDialog.showMessageDialog((Component)MainMenuBar.this.parentProvider.getDialogParent(), (Object)MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_CANTOPENONLINEHELPMSG, new Object[]{url, ex.getMessage()}), (String)MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_CANTOPENONLINEHELPTITLE), (int)0);
                }
            }
        });
        this.helpMenu.add(this.participantsGuideItem, 2.8f);
        this.additionalDocumentationItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_HELP_ADDITIONAL_DOC));
        this.additionalDocumentationItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                String url = MainMenuBar.this.branding.getString((PropertiesEnum)BrandingI18nProvider.Values.ADDITIONAL_DOCUMENTATION_URL);
                try {
                    BrowserUtil.gotoURL((String)url);
                }
                catch (IOException ex) {
                    ModalDialog.showMessageDialog((Component)MainMenuBar.this.parentProvider.getDialogParent(), (Object)MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_CANTOPENONLINEHELPMSG, new Object[]{url, ex.getMessage()}), (String)MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_CANTOPENONLINEHELPTITLE), (int)0);
                }
            }
        });
        this.helpMenu.add(this.additionalDocumentationItem, 2.9f);
        this.diagnosticsItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_HELP_DIAGNOSTICS));
        this.diagnosticsItem.addActionListener(new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                Frame parent = MainMenuBar.this.parentProvider.getDialogParent();
                MainMenuBar.this.debugDialog = new DebugDialog(parent, MainMenuBar.this.i18n.getString((PropertiesEnum)StringsProperties.DIAGNOSTICS_TITLE));
                MainMenuBar.this.debugDialog.pack();
                MainMenuBar.this.debugDialog.setLocationRelativeTo((Component)parent);
                MainMenuBar.this.debugDialog.setVisible(true);
            }
        });
        this.helpMenu.add(this.diagnosticsItem, 3.5f);
        if (Platform.getOS() != 202) {
            this.aboutMenuItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_HELP_ABOUT));
            this.aboutMenuItem.addActionListener(new AutoDeferringActionListener(){

                @Override
                protected void doPerformAction() {
                    MainMenuBar.this.aboutClerk.setAboutBoxVisible(true);
                }
            });
            this.helpMenu.add(this.aboutMenuItem, 10.5f);
        }
        this.updateGuidesVisibility();
    }

    @Inject
    protected void initImps(Imps imps) {
        ImpsAvailableListener<ViewAPI> listener = new ImpsAvailableListener<ViewAPI>(){

            public void available(ViewAPI api) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MainMenuBar.this.viewMenu.add((JMenuItem)MainMenuBar.this.whiteboardItem, 2.1f);
                        MainMenuBar.this.viewMenu.add((JMenuItem)MainMenuBar.this.screenSharingItem, 2.2f);
                        MainMenuBar.this.viewMenu.add((JMenuItem)MainMenuBar.this.webTourItem, 2.3f);
                    }
                });
            }

            public void removed(ViewAPI api) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MainMenuBar.this.viewMenu.remove((JMenuItem)MainMenuBar.this.whiteboardItem);
                        MainMenuBar.this.viewMenu.remove((JMenuItem)MainMenuBar.this.screenSharingItem);
                        MainMenuBar.this.viewMenu.remove((JMenuItem)MainMenuBar.this.webTourItem);
                    }
                });
            }
        };
        imps.addImpsAvailableListener((ImpsAvailableListener)listener, ViewAPI.class);
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
        if (session == null) {
            return;
        }
        session.addPermissionChangeListener("ChairPermission", new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                CRParticipant p;
                CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT && (p = MainMenuBar.this.session.getParticipantById(perm.getID())).isMe()) {
                    MainMenuBar.this.updateGuidesVisibilityFromChairPermission();
                }
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
            }
        });
    }

    private void updateGuidesVisibilityFromChairPermission() {
        CRParticipant me = this.session.getMe();
        if (me != null) {
            this.participantIsChair = this.session.getMe().isChair();
            this.updateGuidesVisibility();
        }
    }

    private void updateGuidesVisibility() {
        this.moderatorGuideItem.setVisible(this.participantIsChair);
        this.participantsGuideItem.setVisible(!this.participantIsChair);
    }

    @Inject
    public void initPreferencesUI(final PreferencesUIClerk preferencesUIClerk) {
        CMenuItem prefsMenu = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.MENUS_EDIT_PREFS));
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        prefsMenu.setAccelerator(KeyStroke.getKeyStroke(44, mask));
        prefsMenu.addActionListener((ActionListener)new AutoDeferringActionListener(){

            @Override
            protected void doPerformAction() {
                preferencesUIClerk.setPreferencesDialogVisible(true);
            }
        });
        if (Platform.getOS() != 202) {
            this.editMenu.add((JMenuItem)prefsMenu, 9.5f);
        }
    }

    @Inject
    public void initModeController(ModeController modeController) {
        this.modeController = modeController;
        modeController.addModeChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent e) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ViewMode mode = (ViewMode)e.getNewValue();
                        switch (mode) {
                            case WHITEBOARD: {
                                MainMenuBar.this.whiteboardItem.setSelected(true);
                                break;
                            }
                            case APPSHARE: {
                                MainMenuBar.this.screenSharingItem.setSelected(true);
                                break;
                            }
                            case WEBTOUR: {
                                MainMenuBar.this.webTourItem.setSelected(true);
                            }
                        }
                    }
                });
            }
        });
        modeController.addModeEnabledListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent e) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ViewMode mode = (ViewMode)e.getSource();
                        boolean enabled = (Boolean)e.getNewValue();
                        switch (mode) {
                            case WHITEBOARD: {
                                MainMenuBar.this.whiteboardItem.setEnabled(enabled);
                                break;
                            }
                            case APPSHARE: {
                                MainMenuBar.this.screenSharingItem.setEnabled(enabled);
                                break;
                            }
                            case WEBTOUR: {
                                MainMenuBar.this.webTourItem.setEnabled(enabled);
                            }
                        }
                    }
                });
            }
        });
    }

    private void showMenuDialog(final JMenu menu, final String title, final String buttonText) {
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS || PlatformIssues.MAC_SCREEN_MENU_ITEMS_DO_NOT_FIRE) {
            Runnable runOnSwingThread = new Runnable(){

                @Override
                public void run() {
                    MainMenuBar.this.doShowMenuDialog(menu, title, buttonText);
                }
            };
            SwingRunnerSupport.invokeOnEventThread((Runnable)runOnSwingThread);
        } else {
            this.doShowMenuDialog(menu, title, buttonText);
        }
    }

    private void doShowMenuDialog(JMenu menu, String title, String buttonText) {
        int row;
        int selectedRow = -1;
        Vector<JMenuItem> menuItems = new Vector<JMenuItem>();
        Vector tableData = new Vector();
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem mi = menu.getItem(i);
            if (!mi.isVisible() || !mi.isEnabled() || mi instanceof JMenu) continue;
            Vector<String> row2 = new Vector<String>();
            String text = mi.getText();
            if (text.endsWith("...")) {
                text = text.substring(0, text.length() - 3);
            }
            row2.add(text);
            tableData.add(row2);
            menuItems.add(mi);
        }
        EasyDialog d = new EasyDialog((Component)this.parentProvider.getDialogParent(), title);
        final JButton okButton = d.makeButton(buttonText);
        d.addActionButton(okButton, true);
        d.addCancelButton(d.makeButton(0));
        Vector<String> cols = new Vector<String>();
        cols.add("");
        DefaultTableModel m = new DefaultTableModel(tableData, cols){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        final CTable t = new CTable((TableModel)m);
        t.setTableHeader(null);
        t.setSelectionMode(0);
        t.setPreferredScrollableViewportSize(new Dimension(200, 200));
        if (selectedRow != -1) {
            t.addRowSelectionInterval(selectedRow, selectedRow);
        } else if (m.getRowCount() > 0) {
            t.addRowSelectionInterval(0, 0);
        }
        t.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                okButton.setEnabled(t.getSelectedRow() != -1);
            }
        });
        t.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && okButton.isEnabled()) {
                    okButton.doClick();
                }
            }
        });
        JScrollPane sp = new JScrollPane((Component)t, 22, 31);
        d.setContent((Component)sp);
        okButton.setEnabled(t.getSelectedRow() != -1);
        d.show();
        if (!d.wasCanceled() && (row = t.getSelectedRow()) >= 0) {
            JMenuItem mi = (JMenuItem)menuItems.get(row);
            mi.doClick();
        }
    }

    private void showShortcutsWindow() {
        if (this.shortcutsWindow == null) {
            String title = this.i18n.getString((PropertiesEnum)StringsProperties.SHORTCUTS_TITLE);
            EasyDialog d = new EasyDialog((Component)this.parentProvider.getDialogParent(), title, false);
            d.setDefaultCloseOperation(1);
            d.setResizable(true);
            d.setInsets(null);
            JEditorPane tp = new JEditorPane("text/html", null);
            tp.setEditable(false);
            tp.setMargin(new Insets(0, 0, 0, 0));
            JScrollPane sp = new JScrollPane(tp);
            sp.setBorder(BorderFactory.createEmptyBorder());
            sp.setViewportBorder(BorderFactory.createEmptyBorder());
            d.setContent((Component)sp);
            String closeWindowAction = "close-window";
            JRootPane r = d.getRootPane();
            r.getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "close-window");
            r.getActionMap().put("close-window", new AbstractAction("close-window"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.shortcutsWindow.setVisible(false);
                }
            });
            try {
                Resource resource = new Resource((Object)this, this.i18n.getString((PropertiesEnum)StringsProperties.SHORTCUTS_HTML));
                String html = resource.readString();
                Font f = UIManager.getFont("EditorPane.font");
                html = html.replaceAll("%FONT_FAMILY%", f.getFamily());
                html = html.replaceAll("%FONT_SIZE%", String.valueOf(f.getSize()));
                tp.setText(html);
                tp.setCaretPosition(0);
            }
            catch (IOException ex) {
                // empty catch block
            }
            d.setSize(500, 500);
            Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
            d.setLocation(ss.width - d.getWidth(), 0);
            this.shortcutsWindow = d;
        }
        this.shortcutsWindow.setVisible(true);
    }

    private abstract class AutoDeferringActionListener
    implements ActionListener {
        private final Runnable doPerformActionRunner = new Runnable(){

            @Override
            public void run() {
                AutoDeferringActionListener.this.doPerformAction();
            }
        };

        private AutoDeferringActionListener() {
        }

        protected abstract void doPerformAction();

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS || PlatformIssues.MAC_SCREEN_MENU_ITEMS_DO_NOT_FIRE) {
                SwingRunnerSupport.invokeOnEventThread((Runnable)this.doPerformActionRunner);
            } else {
                this.doPerformAction();
            }
        }
    }

    private static class MacFileOverrideProxy
    implements LocationHandler {
        private static final String EXIT_PATH = "/classroom/exit";
        private DefaultMenuHandler defaultHandler;

        public MacFileOverrideProxy(DefaultMenuHandler defaultHandler) {
            this.defaultHandler = defaultHandler;
        }

        public void addFeature(Feature feature) {
            if (!feature.getPath().equals(EXIT_PATH)) {
                this.defaultHandler.addFeature(feature);
            }
        }

        public void removeFeature(Feature feature) {
            if (!feature.getPath().equals(EXIT_PATH)) {
                this.defaultHandler.removeFeature(feature);
            }
        }

        public void announceFeature(Feature feature) {
            this.defaultHandler.announceFeature(feature);
        }

        public void deliverNotification(Notification notification) {
            this.defaultHandler.deliverNotification(notification);
        }

        public void abortNotification(Notification notification) {
            this.defaultHandler.abortNotification(notification);
        }

        public void announceNotification(Notification notification) {
            this.defaultHandler.announceNotification(notification);
        }
    }
}

