/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.TopFocusReceiver;
import com.elluminate.classroom.swing.chat.ChatMessagePanel;
import com.elluminate.classroom.swing.chat.ChatServerProperties;
import com.elluminate.classroom.swing.chat.EmoticonSupport;
import com.elluminate.classroom.swing.chat.FontSizable;
import com.elluminate.classroom.swing.chat.FontSizableStack;
import com.elluminate.classroom.swing.chat.SaveChatSupport;
import com.elluminate.classroom.swing.components.MenuButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.classroom.swing.components.SSideBarPanel;
import com.elluminate.classroom.swing.components.SSideBarTab;
import com.elluminate.classroom.swing.components.SSideBarTabBar;
import com.elluminate.classroom.swing.components.WatermarkTextPane;
import com.elluminate.classroom.swing.debug.ParticipantSelectionChangeDebugFlags;
import com.elluminate.classroom.swing.location.ChatLocationHandler;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.location.ParameterSource;
import com.elluminate.framework.location.SelectionParameterSource;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEventType;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.ArraySet;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class ChatPanel
extends SSideBarPanel
implements TopFocusReceiver,
ParticipantSelectionListener {
    private static final String ROOM_TAB_ID = "room";
    private static final String MODERATORS_TAB_ID = "moderators";
    private static final int FONT_SIZE_STEP = 2;
    private boolean initialized = false;
    private boolean supervised;
    private int countOfModerators = 0;
    private JLabel supervisedLabel;
    private SSideBarTabBar tabBar;
    private Map<String, ChatInfo> chats = new HashMap<String, ChatInfo>();
    private CardLayout messageLayout;
    private FontSizableStack messageStack;
    private FontSizableStack inputStack;
    private CardLayout inputLayout;
    private String myDisplayName;
    private SendOutgoingMessageListener sendOutgoingMessageListener;
    private Provider<EmoticonSupport> emoticonSupportProvider;
    private DocumentListener inputFieldDocumentListener;
    private I18n i18n;
    private FeatureBroker featureBroker;
    private ActionFeature dockFeature;
    private Set<String> forbiddenParticipantsFilter;
    private boolean mainRoomChatEnabled = false;
    private ParameterSource<CRParticipant> participantParameterSource;
    private Provider<SaveChatSupport> saveChatSupportProvider;
    private CRSession session;
    private ActionFeature initiateChatFeature;
    private ActionFeature initiateChatParameterizedFeature;
    private BooleanFeature showSupervisedMessages;
    private BooleanFeature showRoomPrivateMessages;
    private BooleanFeature showEventMessages;
    private final String CHAT_SHOW_ROOM_PRIVATE_PREFERENCE = "chatShowRoomPrivatePreference";
    private final String CHAT_SHOW_EVENT_PREFERENCE = "chatShowEventPreference";
    private Preferences preferences;
    private ParticipantSelectorAPI participantSelector = null;
    private TelephonyAPI telephonyAPI = null;
    private Imps imps = null;
    private ClientList clients = null;
    private ClientProvider clientProvider = null;

    public ChatPanel() {
        this.addPropertyChangeListener("docked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean docked = (Boolean)e.getNewValue();
                if (docked) {
                    ChatPanel.this.dockFeature.setName(ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_DETACH_PANEL));
                } else {
                    ChatPanel.this.dockFeature.setName(ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_ATTACH_PANEL));
                }
            }
        });
        this.supervisedLabel = new JLabel();
        this.addTitleBarItem(this.supervisedLabel);
        this.tabBar = new SSideBarTabBar();
        this.tabBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String id = (String)ChatPanel.this.tabBar.getSelectedTab();
                ChatPanel.this.updateInputVisibility();
                ChatPanel.this.inputLayout.show(ChatPanel.this.inputStack, id);
                if (ChatPanel.this.messageLayout != null) {
                    ChatPanel.this.messageLayout.show(ChatPanel.this.messageStack, id);
                }
                ChatInfo ci = (ChatInfo)ChatPanel.this.chats.get(id);
                ChatPanel.this.tabBar.setTabIcon(id, ci.icon);
                ci.inputPanel.requestFocusInInputField();
            }
        });
        this.tabBar.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                SSideBarTab removedTab = (SSideBarTab)e.getChild();
                String removedID = (String)removedTab.getID();
                ChatPanel.this.hideChat(removedID);
            }
        });
        this.setTabBar(this.tabBar);
        JPanel c = (JPanel)this.getContentPane();
        c.setLayout(new BorderLayout());
        this.messageLayout = new CardLayout();
        this.messageStack = new FontSizableStack(this.messageLayout){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            }
        };
        this.messageStack.setBackground(UIManager.getColor("SideBar.contentBackground"));
        this.messageStack.setBorder(UIManager.getBorder("SideBar.contentBorder"));
        this.messageStack.setOpaque(false);
        c.add((Component)this.messageStack, "Center");
        this.inputLayout = new CardLayout();
        this.inputStack = new FontSizableStack(this.inputLayout){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                int h = ChatPanel.this.getHeight();
                if (ps.height > h / 2) {
                    ps = new Dimension(ps.width, h / 2);
                }
                return ps;
            }
        };
        this.inputStack.setBackground(Color.WHITE);
        this.inputStack.setBorder(UIManager.getBorder("SideBar.contentBorder"));
        this.inputStack.setOpaque(false);
        c.add((Component)this.inputStack, "South");
        this.applyPlatformStyling();
    }

    @Inject
    public void initLocationHandler(ChatLocationHandler locationHandler) {
        locationHandler.setChatPanel(this);
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
        this.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.CHATPANEL_NAME));
    }

    @Inject
    public void initSelectionParameterSource(SelectionParameterSource paramSrc) {
        this.participantParameterSource = paramSrc.getParticipantParameterSource();
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
        session.addPermissionChangeListener("ChairPermission", new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT) {
                    CRParticipant p;
                    if ("ChairPermission".equals(e.getPermission().getName())) {
                        if (e.getValueChange() == CRPermissionChangeEventType.TRUE_TO_FALSE) {
                            ChatPanel.this.decrementCountOfModerators();
                        } else if (e.getValueChange() == CRPermissionChangeEventType.FALSE_TO_TRUE) {
                            ChatPanel.this.incrementCountOfModerators();
                        }
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChatPanel.this.updateInputVisibility();
                            }
                        });
                    }
                    if ((p = ChatPanel.this.session.getParticipantById(perm.getID())).isMe()) {
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChatPanel.this.updateShowSupervisedMessagesVisible();
                                ChatPanel.this.updateShowRoomPrivateMessagesVisible();
                            }
                        });
                    }
                }
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
            }
        });
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    private void createFeatures() {
        this.initiateChatFeature = this.featureBroker.createActionFeature((Object)this, "/ui/chat/initiateChat", this.i18n.getString((PropertiesEnum)StringsProperties.INITIATE_PRIVATE_CHAT), null);
        this.initiateChatFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent e) {
                CRParticipant me = ChatPanel.this.session.getMe();
                Collection c = ChatPanel.this.participantParameterSource.getParameters();
                if (c.contains(me)) {
                    return;
                }
                CRParticipant[] participants = c.toArray(new CRParticipant[c.size()]);
                String[] recipients = new String[participants.length];
                for (int i = 0; i < participants.length; ++i) {
                    recipients[i] = participants[i].getDisplayName();
                }
                ChatPanel.this.initiateChat(recipients);
            }
        });
        this.featureBroker.addFeature((Feature)this.initiateChatFeature);
        ArrayList<ActionParameterDescriptor> paramDescs = new ArrayList<ActionParameterDescriptor>();
        paramDescs.add(new ActionParameterDescriptor("participants", ActionParameterDescriptor.Type.PARTICIPANT, 1, Integer.MAX_VALUE));
        this.initiateChatParameterizedFeature = this.featureBroker.createActionFeature((Object)this, "/ui/chat/initiateChatParameterized", paramDescs, null, null);
        this.initiateChatParameterizedFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent e) {
                boolean success = false;
                Collection participants = e.getParameterAsCollectionOf(CRParticipant.class, "participants");
                if (participants != null) {
                    ArrayList<String> recipients = new ArrayList<String>();
                    for (CRParticipant p : participants) {
                        recipients.add(p.getDisplayName());
                    }
                    ChatPanel.this.initiateChat(recipients.toArray(new String[0]));
                    success = true;
                }
                e.setComplete(success);
            }
        });
        this.featureBroker.addFeature((Feature)this.initiateChatParameterizedFeature);
        this.featureBroker.setFeaturePublished((Feature)this.initiateChatParameterizedFeature, true);
        this.dockFeature = this.featureBroker.createActionFeature((Object)this, "/ui/chat/dock", this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_DETACH_PANEL), null);
        this.dockFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent e) {
                ChatPanel.this.setDocked(!ChatPanel.this.isDocked());
            }
        });
        this.featureBroker.addFeature((Feature)this.dockFeature);
        this.featureBroker.setFeaturePublished((Feature)this.dockFeature, true);
        final ActionFeature increaseFontSizeFeature = this.featureBroker.createActionFeature((Object)this, "/ui/chat/increaseFontSize", this.i18n.getString((PropertiesEnum)StringsProperties.CHATPANEL_INCREASE_FONT), null);
        final ActionFeature decreaseFontSizeFeature = this.featureBroker.createActionFeature((Object)this, "/ui/chat/decreaseFontSize", this.i18n.getString((PropertiesEnum)StringsProperties.CHATPANEL_DECREASE_FONT), null);
        increaseFontSizeFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ChatPanel.this.messageStack.increaseFontSize();
                ChatPanel.this.inputStack.increaseFontSize();
                increaseFontSizeFeature.setEnabled(ChatPanel.this.messageStack.canIncreaseFontSize() && ChatPanel.this.inputStack.canIncreaseFontSize());
                decreaseFontSizeFeature.setEnabled(ChatPanel.this.messageStack.canDecreaseFontSize() && ChatPanel.this.inputStack.canDecreaseFontSize());
            }
        });
        this.featureBroker.addFeature((Feature)increaseFontSizeFeature);
        this.featureBroker.setFeaturePublished((Feature)increaseFontSizeFeature, true);
        decreaseFontSizeFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ChatPanel.this.messageStack.decreaseFontSize();
                ChatPanel.this.inputStack.decreaseFontSize();
                decreaseFontSizeFeature.setEnabled(ChatPanel.this.messageStack.canDecreaseFontSize() && ChatPanel.this.inputStack.canDecreaseFontSize());
                increaseFontSizeFeature.setEnabled(ChatPanel.this.messageStack.canIncreaseFontSize() && ChatPanel.this.inputStack.canIncreaseFontSize());
            }
        });
        this.featureBroker.addFeature((Feature)decreaseFontSizeFeature);
        this.featureBroker.setFeaturePublished((Feature)decreaseFontSizeFeature, true);
        ActionFeature saveChatFeature = this.featureBroker.createActionFeature((Object)this, "/ui/chat/saveChat", this.i18n.getString((PropertiesEnum)StringsProperties.SAVE_CHAT), null);
        saveChatFeature.setInteractive(true);
        saveChatFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ChatMessagePanel currentPanel = null;
                for (Component c : ChatPanel.this.messageStack.getComponents()) {
                    if (!(c instanceof ChatMessagePanel) || !c.isVisible()) continue;
                    currentPanel = (ChatMessagePanel)c;
                    break;
                }
                currentPanel.saveToDisk();
            }
        });
        this.featureBroker.addFeature((Feature)saveChatFeature);
        this.featureBroker.setFeaturePublished((Feature)saveChatFeature, true);
        this.showSupervisedMessages = this.featureBroker.createBooleanFeature((Object)this, "/ui/chat/showSupervisedMessages", true, true, this.i18n.getString((PropertiesEnum)StringsProperties.SHOW_SUPERVISED_MESSAGES), null);
        this.showSupervisedMessages.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                boolean showing = (Boolean)event.getNewValue();
                for (ChatInfo ci : ChatPanel.this.chats.values()) {
                    ci.getMessagePanel().setShowingSupervisedMessages(showing);
                }
            }
        });
        this.showRoomPrivateMessages = this.featureBroker.createBooleanFeature((Object)this, "/ui/chat/showRoomPrivateMessages", true, this.preferences.getBooleanSetting("chatShowRoomPrivatePreference", false), this.i18n.getString((PropertiesEnum)StringsProperties.SHOW_ROOM_PRIVATE_MESSAGES), null);
        this.showRoomPrivateMessages.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                boolean showing = (Boolean)event.getNewValue();
                ChatPanel.this.preferences.setSetting("chatShowRoomPrivatePreference", showing);
                for (ChatInfo ci : ChatPanel.this.chats.values()) {
                    ci.getMessagePanel().setShowingRoomPrivateMessages(showing);
                }
            }
        });
        this.showEventMessages = this.featureBroker.createBooleanFeature((Object)this, "/ui/chat/showEventMessages", true, this.preferences.getBooleanSetting("chatShowEventPreference", false), this.i18n.getString((PropertiesEnum)StringsProperties.SHOW_EVENT_MESSAGES), null);
        this.showEventMessages.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                boolean showing = (Boolean)event.getNewValue();
                ChatPanel.this.preferences.setSetting("chatShowEventPreference", showing);
                for (ChatInfo ci : ChatPanel.this.chats.values()) {
                    ci.getMessagePanel().setShowingEventMessages(showing);
                }
            }
        });
        this.featureBroker.addFeature((Feature)this.showEventMessages);
        Boolean initialEventMsgSetting = true;
        if (this.preferences.hasSetting("chatShowEventPreference")) {
            initialEventMsgSetting = Boolean.valueOf(this.preferences.getSetting("chatShowEventPreference"));
            for (ChatInfo ci : this.chats.values()) {
                ci.getMessagePanel().setShowingEventMessages(initialEventMsgSetting);
            }
        }
        this.showEventMessages.setValue((Object)initialEventMsgSetting);
        this.featureBroker.setFeaturePublished((Feature)this.showEventMessages, true);
    }

    @Inject
    public void initFeatureBroker(FeatureBroker featureBroker) {
        this.featureBroker = featureBroker;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.addChatInfo(ROOM_TAB_ID, UIManager.getIcon("Chat.groupChatIcon"), this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_ROOM_TAB), null, false);
            this.addChatToTabBar(ROOM_TAB_ID);
            this.addChatInfo(MODERATORS_TAB_ID, UIManager.getIcon("Chat.groupChatIcon"), this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_MODERATORS_TAB), null, false);
            this.participantSelector = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
            this.participantSelector.addSelectionListener((ParticipantSelectionListener)this);
            this.telephonyAPI = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
            this.createFeatures();
            this.featureBroker.setFeaturePublished((Feature)this.initiateChatFeature, false);
            CRPermissionChangeListener pl = new CRPermissionChangeListener(){

                public void onPermissionValueChange(CRPermissionChangeEvent e) {
                    CRParticipant p;
                    CRPermission perm = (CRPermission)e.getSource();
                    if (perm.getName() == "ChatPermission" && perm.getScope() == CRPermissionScope.PARTICIPANT && (p = ChatPanel.this.session.getParticipantById(perm.getID())).isMe()) {
                        final boolean permissionValue = perm.getValue();
                        ChatPanel.this.initiateChatFeature.setEnabled(permissionValue);
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChatPanel.this.appendEventMessage(permissionValue ? ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_PERMISSION_ENABLED) : ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_PERMISSION_DISABLED), new Date(), "");
                                String inputFieldChatPermMsg = permissionValue ? "" : ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_INPUT_PERMISSION_DISABLED);
                                for (ChatInfo ci : ChatPanel.this.chats.values()) {
                                    ci.getInputPanel().getInputField().setOpaque(permissionValue);
                                    ci.getInputPanel().getInputField().repaint();
                                    if (ci.getId() != ChatPanel.ROOM_TAB_ID) continue;
                                    ci.getInputPanel().getInputField().setWatermarkText(inputFieldChatPermMsg);
                                }
                            }
                        });
                    }
                }

                public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
                }
            };
            this.session.addPermissionChangeListener("ChatPermission", pl);
            this.initialized = true;
        }
    }

    @Inject
    public void initEmoticonSupport(Provider<EmoticonSupport> emoticonSupportProvider) {
        this.emoticonSupportProvider = emoticonSupportProvider;
    }

    @Inject
    public void initSaveChatSupport(Provider<SaveChatSupport> saveChatSupportProvider) {
        this.saveChatSupportProvider = saveChatSupportProvider;
    }

    private void applyPlatformStyling() {
        if (Platform.getOS() != 202) {
            this.messageStack.increaseFontSize();
            this.inputStack.increaseFontSize();
        }
    }

    public void setSupervised(boolean supervised) {
        this.supervised = supervised;
        if (supervised) {
            StringBuilder b = new StringBuilder();
            b.append(" - ");
            b.append(this.i18n.getString((PropertiesEnum)StringsProperties.CHATPANEL_SUPERVISED));
            this.supervisedLabel.setText(b.toString());
        } else {
            this.supervisedLabel.setText(null);
        }
        this.updateShowSupervisedMessagesVisible();
    }

    private void updateShowSupervisedMessagesVisible() {
        CRParticipant me = this.session.getMe();
        boolean amChair = me == null ? false : me.isChair();
        this.featureBroker.setFeaturePublished((Feature)this.showSupervisedMessages, this.supervised && amChair);
    }

    public void updateEmoticonState(boolean emoticonState) {
        for (ChatInfo ci : this.chats.values()) {
            ci.getMessagePanel().setShowEmoticons(emoticonState);
            ci.getInputPanel().emoticonButton.setVisible(emoticonState);
        }
    }

    private void incrementCountOfModerators() {
        ++this.countOfModerators;
    }

    private void decrementCountOfModerators() {
        --this.countOfModerators;
    }

    private void updateShowRoomPrivateMessagesVisible() {
        CRParticipant me = this.session.getMe();
        boolean amChair = me == null ? false : me.isChair();
        this.featureBroker.setFeaturePublished((Feature)this.showRoomPrivateMessages, amChair);
        for (ChatInfo ci : this.chats.values()) {
            ci.getMessagePanel().setShowingRoomPrivateMessages(amChair && (Boolean)this.showRoomPrivateMessages.getValue() != false);
        }
    }

    public void setMyDisplayName(String myDisplayName) {
        this.myDisplayName = myDisplayName;
    }

    public String getMyDisplayName() {
        return this.myDisplayName;
    }

    private void badgeIfTabInBackground(String tabId) {
        String selectedId = (String)this.tabBar.getSelectedTab();
        if (selectedId != null && !selectedId.equals(tabId)) {
            this.tabBar.setTabIcon(tabId, UIManager.getIcon("SideBar.newMessageIcon"));
        }
    }

    private void appendNormalMessage(String id, String sender, Date timestamp, String message) {
        ChatMessagePanel.MessageType msgType = sender.equals(this.getMyDisplayName()) ? ChatMessagePanel.MessageType.NORMAL_FROM_ME : ChatMessagePanel.MessageType.NORMAL_NOT_FROM_ME;
        ChatMessagePanel messagePanel = this.chats.get(id).getMessagePanel();
        messagePanel.appendMessage(sender, timestamp, message, msgType);
        this.badgeIfTabInBackground(id);
    }

    public void appendParticipantMessage(List<String> recipients, String sender, Date timestamp, String message) {
        this.appendParticipantMessage(recipients, sender, timestamp, message, false);
    }

    public void appendParticipantMessage(List<String> recipients, String sender, Date timestamp, String message, boolean bringFocusToInput) {
        String id = this.getOrCreateChatForConversation(recipients.toArray(new String[0]), sender);
        this.addChatToTabBar(id);
        this.appendNormalMessage(id, sender, timestamp, message);
        if (bringFocusToInput) {
            this.tabBar.setSelectedTab(id);
            this.bringFocusToInput();
        }
    }

    public void appendModeratorMessage(String sender, Date timestamp, String message) {
        this.appendNormalMessage(MODERATORS_TAB_ID, sender, timestamp, message);
    }

    public void appendRoomMessage(String sender, Date timestamp, String message) {
        this.appendNormalMessage(ROOM_TAB_ID, sender, timestamp, message);
    }

    public void appendSupervisedMessage(List<String> recipients, String sender, Date timestamp, String message) {
        StringBuilder recipientsBuilder = new StringBuilder();
        for (int i = 0; i < recipients.size(); ++i) {
            recipientsBuilder.append(recipients.get(i));
            if (i >= recipients.size() - 1) continue;
            recipientsBuilder.append(", ");
        }
        String senderAndRecipients = this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_SUPERVISED_SENDER_AND_RECIPIENTS, new Object[]{sender, recipientsBuilder.toString()});
        ChatMessagePanel messagePanel = this.chats.get(ROOM_TAB_ID).getMessagePanel();
        messagePanel.appendMessage(sender, senderAndRecipients, timestamp, message, ChatMessagePanel.MessageType.SUPERVISED);
        this.badgeIfTabInBackground(ROOM_TAB_ID);
    }

    public void appendRoomPrivateMessage(List<String> recipients, String sender, Date timestamp, String message) {
        if (!this.session.getMe().isChair() && !this.session.getMe().getName().equals(sender)) {
            return;
        }
        if (!((Boolean)this.showRoomPrivateMessages.getValue()).booleanValue()) {
            return;
        }
        StringBuilder privateMessageParticipantsNotMe = new StringBuilder();
        StringBuilder recipientsBuilder = new StringBuilder();
        for (int i = 0; i < recipients.size(); ++i) {
            recipientsBuilder.append(recipients.get(i));
            if (!this.session.getMe().getName().equals(recipients.get(i))) {
                privateMessageParticipantsNotMe.append(recipients.get(i) + ",");
            }
            if (i >= recipients.size() - 1) continue;
            recipientsBuilder.append(", ");
        }
        privateMessageParticipantsNotMe.append(sender);
        String senderAndRecipients = this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_ROOM_PRIVATE_SENDER_AND_RECIPIENTS, new Object[]{sender, recipientsBuilder.toString()});
        ChatMessagePanel messagePanel = this.chats.get(ROOM_TAB_ID).getMessagePanel();
        messagePanel.appendMessage(privateMessageParticipantsNotMe.toString(), senderAndRecipients, timestamp, message, ChatMessagePanel.MessageType.ROOM_PRIVATE);
        this.badgeIfTabInBackground(ROOM_TAB_ID);
    }

    public void appendJoinedEventMessage(String participantName, String roomName, Date timestamp) {
        if (roomName == null || roomName.length() == 0) {
            roomName = this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_EVENT_MAIN_ROOM_NAME);
        }
        String message = participantName.equals(this.myDisplayName) ? this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_OUR_JOINED_EVENT_MSG, new Object[]{roomName}) : this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_OTHERS_JOINED_EVENT_MSG, new Object[]{participantName, roomName});
        this.appendEventMessage(message, timestamp, participantName);
    }

    public void appendLeftEventMessage(String participantName, String roomName, Date timestamp) {
        if (roomName == null || roomName.length() == 0) {
            roomName = this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_EVENT_MAIN_ROOM_NAME);
        }
        String message = participantName.equals(this.myDisplayName) ? this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_OUR_LEFT_EVENT_MSG, new Object[]{roomName}) : this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_OTHERS_LEFT_EVENT_MSG, new Object[]{participantName, roomName});
        this.appendEventMessage(message, timestamp, participantName);
    }

    public void appendEventMessage(String message, Date timestamp, String participantName) {
        for (ChatInfo ci : this.chats.values()) {
            boolean shouldAppend = false;
            if (ci.getId() == ROOM_TAB_ID) {
                shouldAppend = true;
            } else {
                if (ci.getId() == MODERATORS_TAB_ID) continue;
                shouldAppend = ci.getParticipantNames().contains(participantName);
            }
            if (!shouldAppend) continue;
            ci.getMessagePanel().appendMessage(null, timestamp, message, ChatMessagePanel.MessageType.EVENT);
        }
    }

    public void setOutgoingMessageListener(SendOutgoingMessageListener soml) {
        if (this.sendOutgoingMessageListener != null) {
            LogSupport.error((Object)this, (String)"setOutgoingMessageListener", (String)"a different listener was previously set");
            return;
        }
        this.sendOutgoingMessageListener = soml;
    }

    public void removeOutgoingMessageListener(SendOutgoingMessageListener soml) {
        if (this.sendOutgoingMessageListener != soml) {
            LogSupport.error((Object)this, (String)"removeOutgoingMessageListener", (String)"Passed listener was never set");
            return;
        }
        this.sendOutgoingMessageListener = null;
    }

    public DocumentListener getInputFieldDocumentListener() {
        return this.inputFieldDocumentListener;
    }

    public void setInputFieldDocumentListener(DocumentListener inputFieldDocumentListener) {
        this.inputFieldDocumentListener = inputFieldDocumentListener;
    }

    @Override
    protected void setContentVisible(boolean contentVisible) {
        this.messageStack.setVisible(contentVisible);
    }

    private void initiateChat(String[] recipients) {
        String id = this.getOrCreateChatForConversation(recipients, this.myDisplayName);
        this.addChatToTabBar(id);
        this.tabBar.setSelectedTab(id);
        this.bringFocusToInput();
    }

    private void bringFocusToInput() {
        for (Component c : this.inputStack.getComponents()) {
            if (!c.isVisible() || !(c instanceof InputPanel)) continue;
            InputPanel p = (InputPanel)c;
            p.requestFocusInInputField();
            break;
        }
    }

    private boolean filterAllowsChat(Set<String> participants) {
        if (this.forbiddenParticipantsFilter != null && !this.forbiddenParticipantsFilter.isEmpty()) {
            ArraySet intersection = new ArraySet(participants);
            intersection.retainAll(this.forbiddenParticipantsFilter);
            return intersection.isEmpty();
        }
        return true;
    }

    private void updateInputVisibility() {
        boolean iAMChair;
        ChatInfo chatInfo = this.chats.get((String)this.tabBar.getSelectedTab());
        if (chatInfo == null) {
            return;
        }
        boolean inputIsVisible = false;
        boolean allowedToChat = false;
        CRParticipant me = this.session.getMe();
        short myAddr = me == null ? (short)-32767 : (short)me.getID();
        boolean havePermission = this.session.getPermissionValue("ChatPermission", myAddr);
        allowedToChat = chatInfo.getId().equals(ROOM_TAB_ID) ? this.mainRoomChatEnabled && (havePermission || this.countOfModerators > 0) : (chatInfo.getId().equals(MODERATORS_TAB_ID) ? true : this.filterAllowsChat(chatInfo.getParticipantNames()));
        JPanel container = (JPanel)this.getContentPane();
        for (Component child : container.getComponents()) {
            if (!child.equals(this.inputStack)) continue;
            inputIsVisible = true;
            break;
        }
        boolean bl = iAMChair = this.session.getMe() != null ? this.session.getMe().isChair() : false;
        if (inputIsVisible != allowedToChat) {
            if (allowedToChat || iAMChair) {
                if (this.inputStack.getParent() != container) {
                    container.add((Component)this.inputStack, "South");
                }
                this.inputLayout.show(this.inputStack, chatInfo.getId());
                chatInfo.getInputPanel().setEditable(true);
            } else {
                container.remove(this.inputStack);
                chatInfo.getInputPanel().setEditable(false);
            }
            container.validate();
        } else if (inputIsVisible == allowedToChat && allowedToChat) {
            if (this.inputStack.getParent() != container) {
                container.add((Component)this.inputStack, "South");
            }
            this.inputLayout.show(this.inputStack, chatInfo.getId());
            chatInfo.getInputPanel().setEditable(true);
            container.validate();
        } else {
            chatInfo.getInputPanel().setEditable(false);
            container.validate();
        }
    }

    private void addChatInfo(String id, Icon icon, String title, Set<String> participants, boolean closeable) {
        if (!this.chats.containsKey(id)) {
            ChatMessagePanel mp = new ChatMessagePanel(this.emoticonSupportProvider, this.saveChatSupportProvider, id, this.session);
            mp.getChatHistory().addMouseListener(new ChatMouseListener((HTMLDocument)mp.getChatHistory().getDocument()));
            mp.setFontSizeStep(2);
            this.messageStack.add((Component)mp, id);
            InputPanel ip = new InputPanel(id, this.emoticonSupportProvider, this.inputFieldDocumentListener);
            if (id != MODERATORS_TAB_ID && id != ROOM_TAB_ID) {
                ip.setEditable(this.filterAllowsChat(participants));
            }
            this.inputStack.add((Component)ip, id);
            if (this.featureBroker.hasFeature("/chat/showEmoticons")) {
                boolean showEmoticons = (Boolean)((BooleanFeature)this.featureBroker.getFeature("/chat/showEmoticons")).getValue();
                mp.setShowEmoticons(showEmoticons);
                ip.emoticonButton.setVisible(showEmoticons);
            }
            ChatInfo ci = new ChatInfo(mp, ip, participants, id, icon, title);
            this.chats.put(id, ci);
        }
    }

    private void addChatToTabBar(String id) {
        if (!this.chats.containsKey(id) || this.tabBar.getTabComponent(id) != null) {
            return;
        }
        ChatInfo ci = this.chats.get(id);
        this.tabBar.addTab(id, ci.getIcon(), ci.getTitle(), this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_TAB_TOOLTIP, new Object[]{ci.getTitle()}));
        this.tabBar.setTabCloseable(id, id != MODERATORS_TAB_ID && id != ROOM_TAB_ID);
    }

    private void hideChat(String id) {
        this.tabBar.removeTab(id);
    }

    public void setMainRoomChatEnabled(boolean enabled) {
        this.mainRoomChatEnabled = enabled;
        this.updateInputVisibility();
    }

    public void setForbiddenParticipantsFilter(Set<String> participantNames) {
        this.forbiddenParticipantsFilter = participantNames;
        this.updateInputVisibility();
    }

    public void showModeratorsTab() {
        this.addChatToTabBar(MODERATORS_TAB_ID);
    }

    public void hideModeratorsTab() {
        this.hideChat(MODERATORS_TAB_ID);
    }

    public void reset() {
        for (ChatInfo ci : this.chats.values()) {
            ci.messagePanel.clear();
        }
    }

    private static Set<String> createInterlocutorSet(String[] recipients, String sender) {
        TreeSet<String> ps = new TreeSet<String>();
        Collections.addAll(ps, recipients);
        if (sender != null) {
            ps.add(sender);
        }
        return ps;
    }

    private String getOrCreateChatForConversation(String[] recipients, String sender) {
        Set<String> rs = ChatPanel.createInterlocutorSet(recipients, sender);
        String id = ChatPanel.createConversationID(rs);
        if (!this.chats.containsKey(id)) {
            StringBuilder b = new StringBuilder();
            rs.remove(this.myDisplayName);
            for (String dn : rs) {
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(dn);
            }
            String title = b.toString();
            Icon ic = rs.size() > 1 ? UIManager.getIcon("Chat.groupChatIcon") : UIManager.getIcon("Chat.privateChatIcon");
            this.addChatInfo(id, ic, title, rs, true);
        }
        return id;
    }

    private static String createConversationID(Set<String> interlocutors) {
        StringBuilder b = new StringBuilder();
        for (String dn : interlocutors) {
            b.append(dn + '|');
        }
        return b.toString();
    }

    @Override
    public boolean requestTopFocus() {
        for (Component c : this.inputStack.getComponents()) {
            if (!c.isVisible() || !(c instanceof InputPanel)) continue;
            InputPanel p = (InputPanel)c;
            p.requestFocusInInputField();
            return true;
        }
        return false;
    }

    public void participantSelectionChanged() {
        CRParticipant me = this.session.getMe();
        Collection c = this.participantParameterSource.getParameters();
        if (c.contains(me)) {
            this.featureBroker.setFeaturePublished((Feature)this.initiateChatFeature, false);
            if (ParticipantSelectionChangeDebugFlags.ParticipantSelectionChange.show()) {
                LogSupport.message((Object)this, (String)"participantSelectionChanged", (String)"ChatPanel.participantSelectionChanged - selection contains 'me'");
            }
        } else {
            boolean hasABridge = false;
            boolean hasPrivateChatRestricted = false;
            boolean privateChatRestrictedProperty = this.isPrivateChateRestricted();
            Iterator it = c.iterator();
            while (!hasABridge && !hasPrivateChatRestricted && it.hasNext()) {
                CRParticipant participant = (CRParticipant)it.next();
                if (this.telephonyAPI != null) {
                    hasABridge = this.telephonyAPI.isBridge(participant.getID());
                }
                hasPrivateChatRestricted = !participant.isChair() && privateChatRestrictedProperty && !this.session.getMe().isChair();
            }
            this.featureBroker.setFeaturePublished((Feature)this.initiateChatFeature, !hasABridge && !hasPrivateChatRestricted);
            if (ParticipantSelectionChangeDebugFlags.ParticipantSelectionChange.show()) {
                LogSupport.message((Object)this, (String)"participantSelectionChanged", (String)("ChatPanel.participantSelectionChanged - selection has a bridge (" + hasABridge + ") or private chat restricted (" + hasPrivateChatRestricted + ")"));
            }
        }
    }

    private boolean isPrivateChateRestricted() {
        if (this.clientProvider == null) {
            return true;
        }
        this.clients = this.clientProvider.get().getClientList();
        if (this.clients == null) {
            return true;
        }
        return this.clients.getProperty(ChatServerProperties.PRIVATE_CHAT_RESTRICTED_PROPERTY, true);
    }

    private static class ChatInfo {
        private ChatMessagePanel messagePanel;
        private InputPanel inputPanel;
        private Set<String> participantNames;
        private String id;
        private Icon icon;
        private String title;

        public ChatInfo(ChatMessagePanel messagePanel, InputPanel inputPanel, Set<String> participantNames, String id, Icon icon, String title) {
            this.messagePanel = messagePanel;
            this.inputPanel = inputPanel;
            this.participantNames = participantNames;
            this.id = id;
            this.icon = icon;
            this.title = title;
        }

        public ChatMessagePanel getMessagePanel() {
            return this.messagePanel;
        }

        public void setMessagePanel(ChatMessagePanel messagePanel) {
            this.messagePanel = messagePanel;
        }

        public InputPanel getInputPanel() {
            return this.inputPanel;
        }

        public void setInputPanel(InputPanel inputPanel) {
            this.inputPanel = inputPanel;
        }

        public Set<String> getParticipantNames() {
            return this.participantNames;
        }

        public void setParticipantNames(Set<String> participantNames) {
            this.participantNames = participantNames;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    protected class ChatMouseListener
    implements MouseListener {
        private HTMLDocument htmlDoc;

        public ChatMouseListener(HTMLDocument htmlDoc) {
            this.htmlDoc = htmlDoc;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object a;
            Point pt;
            if (ChatPanel.this.session == null || ChatPanel.this.session.getMe() == null || !ChatPanel.this.session.getMe().isChair()) {
                return;
            }
            JEditorPane source = (JEditorPane)event.getSource();
            int pos = source.viewToModel(pt = new Point(event.getX(), event.getY()));
            Element characterElement = this.htmlDoc.getCharacterElement(pos);
            AttributeSet attributes = characterElement.getAttributes();
            if (attributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT && (a = attributes.getAttribute(HTML.Tag.SPAN)) != null) {
                SimpleAttributeSet sas = (SimpleAttributeSet)a;
                Object classAttribute = sas.getAttribute(HTML.Attribute.CLASS);
                Object valueAtribute = sas.getAttribute(HTML.Attribute.VALUE);
                if (classAttribute != null && classAttribute.equals("tooltip") && valueAtribute != null) {
                    String[] allRecipients = ((String)valueAtribute).split(",");
                    Vector<String> recipients = new Vector<String>();
                    for (String recipient : allRecipients) {
                        if (ChatPanel.this.session.getMe().getName().equals(recipient)) continue;
                        recipients.add(recipient);
                    }
                    ChatPanel.this.initiateChat(recipients.toArray(new String[recipients.size()]));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private static class EmoticonItem
    extends JMenuItem {
        private static final int SIZE = 24;
        private static Integer leftBorder = -1;
        private String symbol;

        public EmoticonItem(Icon icon, String symbol) {
            super(icon);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(24, 24));
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotify() {
            super.addNotify();
            Integer n = leftBorder;
            synchronized (n) {
                if (leftBorder == -1) {
                    JMenuItem mi = new JMenuItem(new Icon(){

                        @Override
                        public int getIconWidth() {
                            return 16;
                        }

                        @Override
                        public int getIconHeight() {
                            return 16;
                        }

                        @Override
                        public void paintIcon(Component c, Graphics g, int x, int y) {
                            leftBorder = x;
                        }
                    });
                    mi.setBorder(BorderFactory.createEmptyBorder());
                    mi.setMargin(new Insets(0, 0, 0, 0));
                    mi.setSize(24, 24);
                    mi.addNotify();
                    mi.paint(this.getGraphics());
                }
            }
            int iconSize = this.getIcon().getIconWidth();
            this.setBorder(BorderFactory.createEmptyBorder(0, -leftBorder.intValue() + (24 - iconSize) / 2, 0, 0));
        }
    }

    private class InputPanel
    extends JComponent
    implements Accessible,
    FontSizable {
        private static final String SEND_MESSAGE_ACTION_NAME = "send-message-action";
        private String id;
        private WatermarkTextPane inputField;
        private SMenuButton emoticonButton;
        private Provider<EmoticonSupport> emoticonSupportProvider;
        private int fontSizeDelta = 0;
        private int ptStep = 2;
        private String watermarkText;

        public InputPanel(String id, Provider<EmoticonSupport> emoticonSupportProvider, DocumentListener inputFieldDocumentListener) {
            this.id = id;
            this.emoticonSupportProvider = emoticonSupportProvider;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weighty = 1.0;
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.inputField = new WatermarkTextPane(){

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return true;
                }
            };
            this.inputField.setToolTipText(ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_INPUT_TOOLTIP));
            this.inputField.setMargin(new Insets(2, 4, 2, 4));
            this.inputField.setBackground(Color.WHITE);
            if (inputFieldDocumentListener != null) {
                this.inputField.getDocument().addDocumentListener(inputFieldDocumentListener);
            }
            this.inputField.setFocusTraversalKeys(0, null);
            this.inputField.setFocusTraversalKeys(1, null);
            InputMap im = this.inputField.getInputMap(0);
            im.put(KeyStroke.getKeyStroke("control shift O"), "none");
            im.put(KeyStroke.getKeyStroke(10, 0), SEND_MESSAGE_ACTION_NAME);
            ActionMap am = this.inputField.getActionMap();
            am.put(SEND_MESSAGE_ACTION_NAME, new AbstractAction(SEND_MESSAGE_ACTION_NAME){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String msg = InputPanel.this.inputField.getText();
                    InputPanel.this.inputField.setText("");
                    SendOutgoingMessageListener outgoingListener = ChatPanel.this.sendOutgoingMessageListener;
                    if (InputPanel.this.id.equals(ChatPanel.MODERATORS_TAB_ID)) {
                        outgoingListener.sendMessageToModerators(msg);
                    } else if (InputPanel.this.id.equals(ChatPanel.ROOM_TAB_ID)) {
                        outgoingListener.sendMessageToRoom(msg);
                    } else {
                        Set<String> recipients = ((ChatInfo)ChatPanel.this.chats.get(InputPanel.this.id)).getParticipantNames();
                        recipients.remove(ChatPanel.this.getMyDisplayName());
                        outgoingListener.sendMessageToRecipients(recipients.toArray(new String[0]), msg);
                    }
                }
            });
            JScrollPane sp = new JScrollPane(this.inputField, 21, 31);
            sp.setBorder(BorderFactory.createEmptyBorder());
            sp.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)sp, gbc);
            this.inputField.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    InputPanel.this.revalidate();
                }
            });
            this.inputField.getAccessibleContext().setAccessibleName(ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.INPUTPANEL_TEXT_AX_NAME, new Object[]{id}));
            gbc.anchor = 15;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.emoticonButton = new SMenuButton(UIManager.getIcon("Chat.emoticonIcon"));
            this.emoticonButton.setSelectedIcon(UIManager.getIcon("Chat.emoticonRolloverIcon"));
            this.emoticonButton.setPressedIcon(UIManager.getIcon("Chat.emoticonRolloverIcon"));
            this.emoticonButton.setRolloverIcon(UIManager.getIcon("Chat.emoticonRolloverIcon"));
            this.emoticonButton.setRolloverSelectedIcon(UIManager.getIcon("Chat.emoticonRolloverIcon"));
            this.emoticonButton.addFocusListener(new MenuButtonFocusDisplayer());
            this.emoticonButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.emoticonButton.setContentAreaFilled(false);
            this.emoticonButton.setFocusPainted(false);
            this.emoticonButton.setArrowPainted(false);
            this.emoticonButton.setToolTipText(ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_EMOTICON_BUTTON_TOOLTIP));
            this.populateEmoticonPopup(this.emoticonButton.getMenu());
            this.add((Component)this.emoticonButton, gbc);
            this.emoticonButton.getAccessibleContext().setAccessibleName(ChatPanel.this.i18n.getString((PropertiesEnum)StringsProperties.INPUTPANEL_EMOT_AX_NAME, new Object[]{id}));
            this.inputField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!InputPanel.this.inputField.hasFocus()) {
                        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        mgr.clearGlobalFocusOwner();
                    }
                }
            });
        }

        private void populateEmoticonPopup(JPopupMenu popup) {
            final JLabel symbolLabel = new JLabel(" ");
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    EmoticonItem it = (EmoticonItem)e.getComponent();
                    symbolLabel.setText(it.getSymbol());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    symbolLabel.setText(" ");
                }
            };
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmoticonItem it = (EmoticonItem)e.getSource();
                    InputPanel.this.inputField.replaceSelection(it.getSymbol());
                    InputPanel.this.inputField.requestFocus();
                }
            };
            LinkedHashMap<String, Icon> icons = new LinkedHashMap<String, Icon>();
            LinkedHashMap<String, String> iconDesc = new LinkedHashMap<String, String>();
            EmoticonSupport es = (EmoticonSupport)this.emoticonSupportProvider.get();
            for (String emoticonName : es.getEmoticonNameSet()) {
                String shortcut = es.getFirstShortcutForEmoticonName(emoticonName);
                String toolTip = null;
                try {
                    toolTip = ChatPanel.this.i18n.getStringLegacy(emoticonName);
                }
                catch (MissingResourceException mre) {
                    toolTip = es.getDescriptionFromName(emoticonName);
                }
                icons.put(shortcut, es.getIconForShortcut(shortcut, EmoticonSupport.ShortcutType.RAW_TEXT));
                iconDesc.put(shortcut, toolTip);
            }
            popup.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridy = 0;
            int COLUMN_COUNT = 8;
            for (String symbol : icons.keySet()) {
                Icon ic = (Icon)icons.get(symbol);
                EmoticonItem it = new EmoticonItem(ic, symbol);
                it.addMouseListener(ml);
                it.addActionListener(al);
                it.setToolTipText((String)iconDesc.get(symbol));
                it.getAccessibleContext().setAccessibleName((String)iconDesc.get(symbol));
                popup.add((Component)it, gbc);
                if (popup.getComponentCount() % 8 != 0) continue;
                ++gbc.gridy;
            }
            if (popup.getComponentCount() % 8 == 0) {
                ++gbc.gridy;
            }
            gbc.gridwidth = 8;
            symbolLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            popup.add((Component)symbolLabel, gbc);
        }

        public void requestFocusInInputField() {
            this.inputField.requestFocus();
        }

        public void setEditable(boolean editable) {
            if (!editable) {
                this.inputField.setText("");
            }
            this.inputField.setFocusable(editable);
            this.inputField.setEditable(editable);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleInputPanel();
            }
            return this.accessibleContext;
        }

        private void applyFontSizeDelta() {
            Font f = UIManager.getFont("EditorPane.font");
            this.inputField.setFont(f.deriveFont(f.getSize2D() + (float)this.fontSizeDelta));
        }

        @Override
        public void increaseFontSize() {
            this.fontSizeDelta += this.ptStep;
            this.applyFontSizeDelta();
        }

        @Override
        public void decreaseFontSize() {
            this.fontSizeDelta -= this.ptStep;
            this.applyFontSizeDelta();
        }

        @Override
        public void resetFontSize() {
            this.fontSizeDelta = 0;
            this.inputField.setFont(UIManager.getFont("EditorPane.font"));
        }

        @Override
        public void setFontSizeStep(int pts) {
            this.ptStep = pts;
        }

        public WatermarkTextPane getInputField() {
            return this.inputField;
        }

        private class AccessibleInputPanel
        extends JComponent.AccessibleJComponent {
            private AccessibleInputPanel() {
                super(InputPanel.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }

    public static interface SendOutgoingMessageListener {
        public void sendMessageToRecipients(String[] var1, String var2);

        public void sendMessageToRoom(String var1);

        public void sendMessageToModerators(String var1);
    }
}

