/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

class ArrowNavigation {
    private static final KeyStroke leftArrowKeyStroke = KeyStroke.getKeyStroke(37, 0);
    private static final KeyStroke rightArrowKeyStroke = KeyStroke.getKeyStroke(39, 0);
    private static final String leftArrowName = "left-arrow-nav";
    private static final String rightArrowName = "right-arrow-nav";

    ArrowNavigation() {
    }

    public static void install(final JComponent container) {
        AbstractAction leftArrowAction = new AbstractAction(leftArrowName){

            @Override
            public void actionPerformed(ActionEvent e) {
                FocusTraversalPolicy p;
                Component prev;
                KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Container root = mgr.getCurrentFocusCycleRoot();
                Component c = mgr.getFocusOwner();
                if (root != null && c != null && (prev = (p = root.getFocusTraversalPolicy()).getComponentBefore(root, c)) != null && container.isAncestorOf(prev)) {
                    c.transferFocusBackward();
                }
            }
        };
        AbstractAction rightArrowAction = new AbstractAction(rightArrowName){

            @Override
            public void actionPerformed(ActionEvent e) {
                FocusTraversalPolicy p;
                Component next;
                KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Container root = mgr.getCurrentFocusCycleRoot();
                Component c = mgr.getFocusOwner();
                if (root != null && c != null && (next = (p = root.getFocusTraversalPolicy()).getComponentAfter(root, c)) != null && container.isAncestorOf(next)) {
                    c.transferFocus();
                }
            }
        };
        InputMap imap = container.getInputMap(1);
        imap.put(leftArrowKeyStroke, leftArrowName);
        imap.put(rightArrowKeyStroke, rightArrowName);
        ActionMap amap = container.getActionMap();
        amap.put(leftArrowName, leftArrowAction);
        amap.put(rightArrowName, rightArrowAction);
    }
}

