/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.hand;

import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.ShortList;
import java.io.DataInputStream;

public class HandProtocol
extends JinxProtocolAdapter {
    public static final byte RAISE_HAND = 1;
    public static final byte LOWER_HAND = 2;
    public static final byte LOWER_ALL_HANDS = 3;
    public static final byte LOWER_GROUP_HANDS = 4;
    public static final char EMOTION_NONE = ' ';
    public static final char EMOTION_SMILE = ')';
    public static final char EMOTION_LAUGH = 'l';
    public static final char EMOTION_CLAP = 'c';
    public static final char EMOTION_CONFUSED = '?';
    public static final char EMOTION_ANGRY = 'a';
    public static final char EMOTION_APPROVE = 'p';
    public static final char EMOTION_SLOWER = 's';
    public static final char EMOTION_FASTER = 'f';
    public static final DebugFlag DEBUG = DebugFlag.get((String)"hand");
    public static final String PROPERTY = "hand.index";
    public static final String COUNT_PROPERTY = "hand.count";
    public static final String EMOTION_PROPERTY = "hand.emotion";
    public static final String NOTIFY_ON_JOIN_PROPERTY = "hand.notifyOnJoin";
    public static final String CHANNEL = "hand";
    public static final byte PRIORITY = 1;
    public static final short NONE = 0;
    private static final String[] COMMANDS = new String[]{"RaiseHand", "LowerHand", "LowerAllHands", "LowerGroupHands"};

    public HandProtocol() {
        this.defineChannel(CHANNEL, (byte)1);
        this.defineProperty(PROPERTY, (byte)0, ShortList.get((short)0));
        this.defineProperty(COUNT_PROPERTY, (byte)1, ShortList.get((short)0));
        this.defineProperty(EMOTION_PROPERTY, (byte)0, new Character(' ').charValue());
        this.defineProperty(NOTIFY_ON_JOIN_PROPERTY, (byte)1, Boolean.FALSE);
    }

    public String commandToString(byte cmd) {
        try {
            return COMMANDS[cmd - 1];
        }
        catch (Exception ex) {
            return "[ invalid hand protocol command - " + cmd + " ]";
        }
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String desc = this.commandToString(cmd);
        switch (cmd) {
            case 2: 
            case 4: {
                try {
                    short arg = str.readShort();
                    desc = desc + " - " + arg;
                    break;
                }
                catch (Exception ex) {
                    desc = desc + " - **** encoding error ****";
                }
            }
        }
        return desc;
    }

    public static boolean isHandRaised(ClientInfo ci) {
        short hand = ci.getProperty(PROPERTY, (short)0);
        return hand != 0;
    }
}

